/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads.model;

import com.datastax.driver.core.ColumnDefinitions;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.reads.model.CqlColumnImpl;
import com.netflix.astyanax.cql.reads.model.CqlColumnListImpl;
import com.netflix.astyanax.cql.reads.model.CqlRowImpl;
import com.netflix.astyanax.cql.reads.model.CqlRowListImpl;
import com.netflix.astyanax.cql.util.CqlTypeMapping;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.CqlResult;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import java.util.ArrayList;
import java.util.List;

public class DirectCqlResult<K, C>
implements CqlResult<K, C> {
    private Long number = null;
    private CqlRowListImpl<K, C> rows;

    public DirectCqlResult(List<com.datastax.driver.core.Row> rows, ColumnFamily<K, C> cf) {
        ArrayList rowList = new ArrayList();
        for (com.datastax.driver.core.Row row : rows) {
            rowList.add(this.getAstyanaxRow(row, cf));
        }
        this.rows = new CqlRowListImpl(rowList);
    }

    public DirectCqlResult(Long number) {
        this.number = number;
    }

    public Rows<K, C> getRows() {
        return this.rows;
    }

    public int getNumber() {
        return this.number.intValue();
    }

    public boolean hasRows() {
        return this.rows != null && this.rows.size() > 0;
    }

    public boolean hasNumber() {
        return this.number != null;
    }

    private Row<K, C> getAstyanaxRow(com.datastax.driver.core.Row row, ColumnFamily<K, C> cf) {
        CqlRowImpl<K, C> rowImpl = new CqlRowImpl<K, C>(this.getAstyanaxRowKey(row, cf), this.getAstyanaxColumnList(row), cf);
        return rowImpl;
    }

    private K getAstyanaxRowKey(com.datastax.driver.core.Row row, ColumnFamily<K, C> cf) {
        Serializer keySerializer = cf.getKeySerializer();
        return (K)CqlTypeMapping.getDynamicColumn(row, keySerializer, 0, cf);
    }

    private CqlColumnListImpl<C> getAstyanaxColumnList(com.datastax.driver.core.Row row) {
        ArrayList list = new ArrayList();
        List colDefs = row.getColumnDefinitions().asList();
        int index = 0;
        for (ColumnDefinitions.Definition colDef : colDefs) {
            String columnName = colDef.getName();
            list.add(new CqlColumnImpl<String>(columnName, row, index, colDef));
            ++index;
        }
        return new CqlColumnListImpl(list);
    }
}

