/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.schema;

import com.datastax.driver.core.Row;
import com.netflix.astyanax.cql.util.CqlTypeMapping;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.FieldMetadata;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.marshal.UTF8Type;

public class CqlColumnDefinitionImpl
implements ColumnDefinition,
Comparable<CqlColumnDefinitionImpl> {
    Map<String, Object> options = new HashMap<String, Object>();
    private CqlColumnType colType;
    private Integer componentIndex;

    public CqlColumnDefinitionImpl() {
    }

    public CqlColumnDefinitionImpl(Row row) {
        this.setName(row.getString("column_name"));
        String validationClass = row.getString("validator");
        if (validationClass.contains("(")) {
            int start = validationClass.indexOf("(");
            int end = validationClass.indexOf(")");
            validationClass = validationClass.substring(start + 1, end);
        }
        this.setValidationClass(validationClass);
        this.colType = CqlColumnType.valueOf(row.getString("type"));
        if (this.colType == CqlColumnType.clustering_key) {
            this.componentIndex = row.getInt("component_index");
        }
    }

    public ColumnDefinition setName(String name) {
        this.options.put("column_name", name);
        return this;
    }

    public ColumnDefinition setName(byte[] name) {
        return this.setName(ByteBuffer.wrap(name));
    }

    public ColumnDefinition setName(ByteBuffer name) {
        return this.setName(UTF8Type.instance.compose(name));
    }

    public ColumnDefinition setValidationClass(String value) {
        this.options.put("validator", value);
        return this;
    }

    public ColumnDefinition setIndex(String name, String type) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnDefinition setKeysIndex(String name) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnDefinition setKeysIndex() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnDefinition setIndexWithType(String type) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public String getName() {
        return (String)this.options.get("column_name");
    }

    public ByteBuffer getRawName() {
        return UTF8Type.instance.decompose(this.getName());
    }

    public String getValidationClass() {
        return (String)this.options.get("validator");
    }

    public String getIndexName() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public String getIndexType() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public boolean hasIndex() {
        return this.getIndexName() != null;
    }

    public Map<String, String> getOptions() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.options.keySet()) {
            result.put(key, this.options.get(key).toString());
        }
        return result;
    }

    public String getOption(String name, String defaultValue) {
        String value = (String)this.options.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public ColumnDefinition setOptions(Map<String, String> setOptions) {
        this.options.putAll(setOptions);
        return this;
    }

    public String setOption(String name, String value) {
        this.options.put(name, value);
        return this.options.get(name).toString();
    }

    public Collection<String> getFieldNames() {
        return this.options.keySet();
    }

    public Collection<FieldMetadata> getFieldsMetadata() {
        ArrayList<FieldMetadata> list = new ArrayList<FieldMetadata>();
        for (String key : this.options.keySet()) {
            Object value = this.options.get(key);
            Class<?> clazz = value.getClass();
            String name = key.toUpperCase();
            String type = clazz.getSimpleName().toUpperCase();
            boolean isContainer = Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
            list.add(new FieldMetadata(name, type, isContainer));
        }
        return list;
    }

    public Object getFieldValue(String name) {
        return this.options.get(name);
    }

    public ColumnDefinition setFieldValue(String name, Object value) {
        this.options.put(name, String.valueOf(value));
        return this;
    }

    public ColumnDefinition setFields(Map<String, Object> fields) {
        this.options.putAll(fields);
        return this;
    }

    public String getCqlType() {
        return CqlTypeMapping.getCqlTypeFromComparator(this.getValidationClass());
    }

    public CqlColumnType getColumnType() {
        return this.colType;
    }

    public int getComponentIndex() {
        return this.componentIndex;
    }

    @Override
    public int compareTo(CqlColumnDefinitionImpl o) {
        return this.componentIndex.compareTo(o.componentIndex);
    }

    public static enum CqlColumnType {
        partition_key,
        clustering_key,
        regular,
        compact_value;

    }
}

