/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.writes;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.writes.CqlColumnListMutationImpl;
import com.netflix.astyanax.cql.writes.CqlColumnMutationImpl;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.AnnotatedCompositeSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFMutationQueryGen {
    private static final Logger Logger = LoggerFactory.getLogger(CFMutationQueryGen.class);
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String OPEN_PARA = " (";
    private static final String CLOSE_PARA = ") ";
    private static final String VALUES = ") VALUES (";
    private static final String BIND_MARKER = "?,";
    private static final String LAST_BIND_MARKER = "?";
    private static final String COMMA = ",";
    private static final String USING = " USING ";
    private static final String TTL = " TTL ";
    private static final String AND = " AND ";
    private static final String TIMESTAMP = " TIMESTAMP ";
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String WHERE = " WHERE ";
    private static final String EQUALS = " = ";
    private static final String UPDATE = " UPDATE ";
    private static final String SET = " SET ";
    private final String keyspace;
    private final CqlColumnFamilyDefinitionImpl cfDef;
    private final Session session;
    private MutationQueryCache<CqlColumnListMutationImpl<?, ?>> DeleteRowQuery = new MutationQueryCache<CqlColumnListMutationImpl<?, ?>>(){
        private final Callable<String> queryGen = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return CFMutationQueryGen.DELETE_FROM + CFMutationQueryGen.this.keyspace + "." + CFMutationQueryGen.this.cfDef.getName() + CFMutationQueryGen.WHERE + CFMutationQueryGen.this.cfDef.getPartitionKeyColumnDefinition().getName() + CFMutationQueryGen.EQUALS + CFMutationQueryGen.LAST_BIND_MARKER;
            }
        };

        @Override
        public Callable<String> getQueryGen(CqlColumnListMutationImpl<?, ?> mutation) {
            return this.queryGen;
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnListMutationImpl<?, ?> mutation) {
            return pStatement.bind(new Object[]{mutation.getRowKey()});
        }
    };
    private BaseClusteringKeyMutation InsertColumnWithClusteringKey = new BaseClusteringKeyMutation(){

        @Override
        public Callable<String> getQueryGen(final CqlColumnMutationImpl<?, ?> mutation) {
            return new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return this.genQuery().toString();
                }

                private StringBuilder genQuery() {
                    int columnCount = 0;
                    StringBuilder sb = new StringBuilder(CFMutationQueryGen.INSERT_INTO);
                    sb.append(CFMutationQueryGen.this.keyspace + "." + CFMutationQueryGen.this.cfDef.getName());
                    sb.append(CFMutationQueryGen.OPEN_PARA);
                    Iterator<ColumnDefinition> iter = CFMutationQueryGen.this.cfDef.getPartitionKeyColumnDefinitionList().iterator();
                    while (iter.hasNext()) {
                        sb.append(iter.next().getName());
                        ++columnCount;
                        if (!iter.hasNext()) continue;
                        sb.append(CFMutationQueryGen.COMMA);
                    }
                    iter = CFMutationQueryGen.this.cfDef.getClusteringKeyColumnDefinitionList().iterator();
                    if (iter.hasNext()) {
                        sb.append(CFMutationQueryGen.COMMA);
                        while (iter.hasNext()) {
                            sb.append(iter.next().getName());
                            ++columnCount;
                            if (!iter.hasNext()) continue;
                            sb.append(CFMutationQueryGen.COMMA);
                        }
                    }
                    if ((iter = CFMutationQueryGen.this.cfDef.getRegularColumnDefinitionList().iterator()).hasNext()) {
                        sb.append(CFMutationQueryGen.COMMA);
                        while (iter.hasNext()) {
                            sb.append(iter.next().getName());
                            ++columnCount;
                            if (!iter.hasNext()) continue;
                            sb.append(CFMutationQueryGen.COMMA);
                        }
                    }
                    sb.append(CFMutationQueryGen.VALUES);
                    for (int i = 0; i < columnCount; ++i) {
                        if (i < columnCount - 1) {
                            sb.append(CFMutationQueryGen.BIND_MARKER);
                            continue;
                        }
                        sb.append(CFMutationQueryGen.LAST_BIND_MARKER);
                    }
                    sb.append(CFMutationQueryGen.CLOSE_PARA);
                    CFMutationQueryGen.appendWriteOptions(sb, mutation.getTTL(), mutation.getTimestamp());
                    return sb;
                }
            };
        }

        @Override
        public boolean isDeleteQuery() {
            return false;
        }
    };
    private BaseClusteringKeyMutation DeleteColumnWithClusteringKey = new BaseClusteringKeyMutation(){

        @Override
        public Callable<String> getQueryGen(final CqlColumnMutationImpl<?, ?> mutation) {
            return new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return this.genQuery().toString();
                }

                private StringBuilder genQuery() {
                    StringBuilder sb = new StringBuilder(CFMutationQueryGen.DELETE_FROM);
                    sb.append(CFMutationQueryGen.this.keyspace + "." + CFMutationQueryGen.this.cfDef.getName());
                    CFMutationQueryGen.appendWriteOptions(sb, mutation.getTTL(), mutation.getTimestamp());
                    Iterator<ColumnDefinition> iter = CFMutationQueryGen.this.cfDef.getPartitionKeyColumnDefinitionList().iterator();
                    sb.append(CFMutationQueryGen.WHERE);
                    while (iter.hasNext()) {
                        sb.append(iter.next().getName()).append(CFMutationQueryGen.EQUALS).append(CFMutationQueryGen.LAST_BIND_MARKER);
                        if (!iter.hasNext()) continue;
                        sb.append(CFMutationQueryGen.AND);
                    }
                    iter = CFMutationQueryGen.this.cfDef.getClusteringKeyColumnDefinitionList().iterator();
                    if (iter.hasNext()) {
                        sb.append(CFMutationQueryGen.AND);
                        while (iter.hasNext()) {
                            sb.append(iter.next().getName()).append(CFMutationQueryGen.EQUALS).append(CFMutationQueryGen.LAST_BIND_MARKER);
                            if (!iter.hasNext()) continue;
                            sb.append(CFMutationQueryGen.AND);
                        }
                    }
                    return sb;
                }
            };
        }

        @Override
        public boolean isDeleteQuery() {
            return true;
        }
    };
    private MutationQueryCache<CqlColumnMutationImpl<?, ?>> CounterColumnUpdate = new MutationQueryCache<CqlColumnMutationImpl<?, ?>>(){

        @Override
        public Callable<String> getQueryGen(final CqlColumnMutationImpl<?, ?> mutation) {
            return new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String valueAlias = CFMutationQueryGen.this.cfDef.getRegularColumnDefinitionList().get(0).getName();
                    StringBuilder sb = new StringBuilder();
                    sb.append(CFMutationQueryGen.UPDATE + CFMutationQueryGen.this.keyspace + "." + CFMutationQueryGen.this.cfDef.getName());
                    CFMutationQueryGen.appendWriteOptions(sb, mutation.getTTL(), mutation.getTimestamp());
                    sb.append(CFMutationQueryGen.SET + valueAlias + CFMutationQueryGen.EQUALS + valueAlias + " + ? ");
                    Iterator<ColumnDefinition> iter = CFMutationQueryGen.this.cfDef.getPartitionKeyColumnDefinitionList().iterator();
                    sb.append(CFMutationQueryGen.WHERE);
                    while (iter.hasNext()) {
                        sb.append(iter.next().getName()).append(CFMutationQueryGen.EQUALS).append(CFMutationQueryGen.LAST_BIND_MARKER);
                        if (!iter.hasNext()) continue;
                        sb.append(CFMutationQueryGen.AND);
                    }
                    iter = CFMutationQueryGen.this.cfDef.getClusteringKeyColumnDefinitionList().iterator();
                    if (iter.hasNext()) {
                        sb.append(CFMutationQueryGen.AND);
                        while (iter.hasNext()) {
                            sb.append(iter.next().getName()).append(CFMutationQueryGen.EQUALS).append(CFMutationQueryGen.LAST_BIND_MARKER);
                            if (!iter.hasNext()) continue;
                            sb.append(CFMutationQueryGen.AND);
                        }
                    }
                    return sb.toString();
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnMutationImpl<?, ?> mutation) {
            boolean isCompositeColumn;
            int size = 1 + CFMutationQueryGen.this.cfDef.getPartitionKeyColumnDefinitionList().size() + CFMutationQueryGen.this.cfDef.getClusteringKeyColumnDefinitionList().size();
            Object[] arr = new Object[size];
            int index = 0;
            arr[index++] = mutation.columnValue;
            arr[index++] = mutation.getRowKey();
            ColumnFamily cf = mutation.cfContext.getColumnFamily();
            boolean bl = isCompositeColumn = cf.getColumnSerializer().getComparatorType() == ComparatorType.COMPOSITETYPE;
            if (isCompositeColumn) {
                AnnotatedCompositeSerializer compSerializer = (AnnotatedCompositeSerializer)cf.getColumnSerializer();
                for (AnnotatedCompositeSerializer.ComponentSerializer component : compSerializer.getComponents()) {
                    try {
                        arr[index++] = component.getFieldValueDirectly(mutation.columnName);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                arr[index++] = mutation.columnName;
            }
            return pStatement.bind(arr);
        }
    };
    private MutationQueryCache<CqlColumnListMutationImpl<?, ?>> InsertOrDeleteWithClusteringKey = new MutationQueryCache<CqlColumnListMutationImpl<?, ?>>(){

        @Override
        public void addToBatch(BatchStatement batch, CqlColumnListMutationImpl<?, ?> colListMutation, boolean useCaching) {
            block5: for (CqlColumnMutationImpl<?, ?> colMutation : colListMutation.getMutationList()) {
                switch (colMutation.getType()) {
                    case UpdateColumn: {
                        CFMutationQueryGen.this.InsertColumnWithClusteringKey.addToBatch(batch, colMutation, useCaching);
                        continue block5;
                    }
                    case DeleteColumn: {
                        CFMutationQueryGen.this.DeleteColumnWithClusteringKey.addToBatch(batch, colMutation, useCaching);
                        continue block5;
                    }
                    case CounterColumn: {
                        throw new RuntimeException("Counter column update not allowed with other updates");
                    }
                }
                throw new RuntimeException("Unsupported type: " + (Object)((Object)colMutation.getType()));
            }
        }

        @Override
        public Callable<String> getQueryGen(CqlColumnListMutationImpl<?, ?> colListMutation) {
            throw new RuntimeException("Not Supported");
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnListMutationImpl<?, ?> colListMutation) {
            throw new RuntimeException("Not Supported");
        }
    };
    private MutationQueryCache<CqlColumnListMutationImpl<?, ?>> InsertOrDeleteColumnListWithClusteringKey = new MutationQueryCache<CqlColumnListMutationImpl<?, ?>>(){

        @Override
        public void addToBatch(BatchStatement batch, CqlColumnListMutationImpl<?, ?> colListMutation, boolean useCaching) {
            for (CqlColumnMutationImpl<?, ?> colMutation : colListMutation.getMutationList()) {
                CFMutationQueryGen.this.InsertOrDeleteColumnWithClusteringKey.addToBatch(batch, colMutation, useCaching);
            }
        }

        @Override
        public Callable<String> getQueryGen(CqlColumnListMutationImpl<?, ?> colListMutation) {
            throw new RuntimeException("Not Supported");
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnListMutationImpl<?, ?> colListMutation) {
            throw new RuntimeException("Not Supported");
        }
    };
    private MutationQueryCache<CqlColumnMutationImpl<?, ?>> InsertOrDeleteColumnWithClusteringKey = new MutationQueryCache<CqlColumnMutationImpl<?, ?>>(){

        @Override
        public BoundStatement getBoundStatement(CqlColumnMutationImpl<?, ?> mutation, boolean useCaching) {
            switch (mutation.getType()) {
                case UpdateColumn: {
                    return CFMutationQueryGen.this.InsertColumnWithClusteringKey.getBoundStatement(mutation, useCaching);
                }
                case DeleteColumn: {
                    return CFMutationQueryGen.this.DeleteColumnWithClusteringKey.getBoundStatement(mutation, useCaching);
                }
                case CounterColumn: {
                    return CFMutationQueryGen.this.CounterColumnUpdate.getBoundStatement(mutation, useCaching);
                }
            }
            throw new RuntimeException("Unsupported type: " + (Object)((Object)mutation.getType()));
        }

        @Override
        public Callable<String> getQueryGen(CqlColumnMutationImpl<?, ?> colMutation) {
            throw new RuntimeException("Not Supported");
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnMutationImpl<?, ?> colMutation) {
            throw new RuntimeException("Not Supported");
        }
    };
    private MutationQueryCache<CqlColumnListMutationImpl<?, ?>> CounterColumnList = new MutationQueryCache<CqlColumnListMutationImpl<?, ?>>(){

        @Override
        public void addToBatch(BatchStatement batch, CqlColumnListMutationImpl<?, ?> colListMutation, boolean useCaching) {
            for (CqlColumnMutationImpl<?, ?> colMutation : colListMutation.getMutationList()) {
                CFMutationQueryGen.this.CounterColumnUpdate.addToBatch(batch, colMutation, useCaching);
            }
        }

        @Override
        public Callable<String> getQueryGen(CqlColumnListMutationImpl<?, ?> colListMutation) {
            throw new RuntimeException("Not Supported");
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnListMutationImpl<?, ?> colListMutation) {
            throw new RuntimeException("Not Supported");
        }
    };
    private MutationQueryCache<CqlColumnListMutationImpl<?, ?>> FlatTableInsertQuery = new MutationQueryCache<CqlColumnListMutationImpl<?, ?>>(){

        @Override
        public void addToBatch(BatchStatement batch, CqlColumnListMutationImpl<?, ?> colListMutation, boolean useCaching) {
            StringBuilder sb = new StringBuilder();
            sb.append(CFMutationQueryGen.INSERT_INTO).append(CFMutationQueryGen.this.keyspace + "." + CFMutationQueryGen.this.cfDef.getName());
            sb.append(CFMutationQueryGen.OPEN_PARA);
            int size = colListMutation.getMutationList().size() + 1;
            Object[] values = new Object[size];
            int index = 0;
            sb.append(CFMutationQueryGen.this.cfDef.getPartitionKeyColumnDefinition().getName()).append(CFMutationQueryGen.COMMA);
            values[index++] = colListMutation.getRowKey();
            for (CqlColumnMutationImpl<?, ?> colMutation : colListMutation.getMutationList()) {
                sb.append(colMutation.columnName);
                values[index++] = colMutation.columnValue;
                if (index >= size) continue;
                sb.append(CFMutationQueryGen.COMMA);
            }
            sb.append(CFMutationQueryGen.VALUES);
            for (int i = 0; i < size; ++i) {
                if (i < size - 1) {
                    sb.append(CFMutationQueryGen.BIND_MARKER);
                    continue;
                }
                sb.append(CFMutationQueryGen.LAST_BIND_MARKER);
            }
            sb.append(CFMutationQueryGen.CLOSE_PARA);
            CFMutationQueryGen.appendWriteOptions(sb, colListMutation.getDefaultTtl(), colListMutation.getTimestamp());
            String query = sb.toString();
            if (Logger.isDebugEnabled()) {
                Logger.debug("Query: " + query);
            }
            try {
                PreparedStatement pStatement = CFMutationQueryGen.this.session.prepare(query);
                batch.add((Statement)pStatement.bind(values));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Callable<String> getQueryGen(CqlColumnListMutationImpl<?, ?> mutation) {
            throw new RuntimeException("Not Supported");
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnListMutationImpl<?, ?> mutation) {
            throw new RuntimeException("Not Supported");
        }
    };
    private MutationQueryCache<CqlColumnMutationImpl<?, ?>> FlatTableInsertQueryForColumn = new MutationQueryCache<CqlColumnMutationImpl<?, ?>>(){

        @Override
        public Callable<String> getQueryGen(CqlColumnMutationImpl<?, ?> mutation) {
            throw new RuntimeException("Not Supported");
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnMutationImpl<?, ?> mutation) {
            throw new RuntimeException("Not Supported");
        }

        @Override
        public void addToBatch(BatchStatement batch, CqlColumnMutationImpl<?, ?> mutation, boolean useCaching) {
            throw new RuntimeException("Not Supported");
        }

        @Override
        public BoundStatement getBoundStatement(CqlColumnMutationImpl<?, ?> mutation, boolean useCaching) {
            StringBuilder sb = new StringBuilder();
            sb.append(CFMutationQueryGen.INSERT_INTO).append(CFMutationQueryGen.this.keyspace + "." + CFMutationQueryGen.this.cfDef.getName());
            sb.append(CFMutationQueryGen.OPEN_PARA);
            sb.append(CFMutationQueryGen.this.cfDef.getPartitionKeyColumnDefinition().getName());
            sb.append(CFMutationQueryGen.COMMA);
            sb.append(mutation.columnName);
            sb.append(CFMutationQueryGen.VALUES);
            sb.append(CFMutationQueryGen.BIND_MARKER);
            sb.append(CFMutationQueryGen.LAST_BIND_MARKER);
            sb.append(CFMutationQueryGen.CLOSE_PARA);
            CFMutationQueryGen.appendWriteOptions(sb, mutation.getTTL(), mutation.getTimestamp());
            String query = sb.toString();
            if (Logger.isDebugEnabled()) {
                Logger.debug("Query: " + query);
            }
            Object[] values = new Object[]{mutation.getRowKey(), mutation.columnValue};
            try {
                PreparedStatement pStatement = CFMutationQueryGen.this.session.prepare(query);
                return pStatement.bind(values);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    public CFMutationQueryGen(Session session, String keyspaceName, CqlColumnFamilyDefinitionImpl cfDefinition) {
        this.keyspace = keyspaceName;
        this.cfDef = cfDefinition;
        this.session = session;
    }

    private static void appendWriteOptions(StringBuilder sb, Integer ttl, Long timestamp) {
        if (ttl != null || timestamp != null) {
            sb.append(USING);
        }
        if (ttl != null) {
            sb.append(TTL + ttl);
        }
        if (timestamp != null) {
            if (ttl != null) {
                sb.append(AND);
            }
            sb.append(TIMESTAMP + timestamp);
        }
    }

    public void addColumnListMutationToBatch(BatchStatement batch, CqlColumnListMutationImpl<?, ?> colListMutation, boolean useCaching) {
        switch (colListMutation.getType()) {
            case RowDelete: {
                this.DeleteRowQuery.addToBatch(batch, colListMutation, useCaching);
                break;
            }
            case ColumnsUpdate: {
                if (this.cfDef.getClusteringKeyColumnDefinitionList().size() == 0) {
                    this.FlatTableInsertQuery.addToBatch(batch, colListMutation, useCaching);
                    break;
                }
                this.InsertOrDeleteWithClusteringKey.addToBatch(batch, colListMutation, useCaching);
                break;
            }
            case CounterColumnsUpdate: {
                this.CounterColumnList.addToBatch(batch, colListMutation, useCaching);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized ColumnListMutation Type");
            }
        }
    }

    public BoundStatement getColumnMutationStatement(CqlColumnMutationImpl<?, ?> mutation, boolean useCaching) {
        if (this.cfDef.getClusteringKeyColumnDefinitionList().size() == 0) {
            return this.FlatTableInsertQueryForColumn.getBoundStatement(mutation, useCaching);
        }
        return this.InsertOrDeleteColumnWithClusteringKey.getBoundStatement(mutation, useCaching);
    }

    abstract class BaseClusteringKeyMutation
    extends MutationQueryCache<CqlColumnMutationImpl<?, ?>> {
        BaseClusteringKeyMutation() {
        }

        public abstract boolean isDeleteQuery();

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlColumnMutationImpl<?, ?> colMutation) {
            boolean isCompositeColumn;
            int size = CFMutationQueryGen.this.cfDef.getPartitionKeyColumnDefinitionList().size() + CFMutationQueryGen.this.cfDef.getClusteringKeyColumnDefinitionList().size();
            if (!this.isDeleteQuery()) {
                size += CFMutationQueryGen.this.cfDef.getRegularColumnDefinitionList().size();
            }
            Object[] arr = new Object[size];
            int index = 0;
            arr[index++] = colMutation.getRowKey();
            ColumnFamily cf = colMutation.cfContext.getColumnFamily();
            boolean bl = isCompositeColumn = cf.getColumnSerializer().getComparatorType() == ComparatorType.COMPOSITETYPE;
            if (isCompositeColumn) {
                AnnotatedCompositeSerializer compSerializer = (AnnotatedCompositeSerializer)cf.getColumnSerializer();
                for (AnnotatedCompositeSerializer.ComponentSerializer component : compSerializer.getComponents()) {
                    try {
                        arr[index++] = component.getFieldValueDirectly(colMutation.columnName);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                arr[index++] = colMutation.columnName;
            }
            if (!this.isDeleteQuery()) {
                arr[index++] = colMutation.columnValue;
            }
            return pStatement.bind(arr);
        }
    }

    abstract class MutationQueryCache<M> {
        private final AtomicReference<PreparedStatement> cachedStatement = new AtomicReference<Object>(null);

        MutationQueryCache() {
        }

        public abstract Callable<String> getQueryGen(M var1);

        public void addToBatch(BatchStatement batch, M mutation, boolean useCaching) {
            batch.add((Statement)this.getBoundStatement(mutation, useCaching));
        }

        public BoundStatement getBoundStatement(M mutation, boolean useCaching) {
            PreparedStatement pStatement = this.getPreparedStatement(mutation, useCaching);
            return this.bindValues(pStatement, mutation);
        }

        public abstract BoundStatement bindValues(PreparedStatement var1, M var2);

        public PreparedStatement getPreparedStatement(M mutation, boolean useCaching) {
            PreparedStatement pStatement = null;
            if (useCaching) {
                pStatement = this.cachedStatement.get();
            }
            if (pStatement == null) {
                try {
                    String query = this.getQueryGen(mutation).call();
                    pStatement = CFMutationQueryGen.this.session.prepare(query);
                    if (Logger.isDebugEnabled()) {
                        Logger.debug("Query: " + pStatement.getQueryString());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (useCaching && this.cachedStatement.get() == null) {
                this.cachedStatement.set(pStatement);
            }
            return pStatement;
        }
    }

    public static enum MutationType {
        ColumnUpdate,
        ColumnDelete,
        RowDelete,
        CounterColumnUpdate;

    }
}

