/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.writes;

import com.google.common.base.Preconditions;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.cql.writes.AbstractColumnListMutationImpl;
import com.netflix.astyanax.cql.writes.CFMutationQueryGen;
import com.netflix.astyanax.cql.writes.CqlColumnMutationImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnPath;
import com.netflix.astyanax.model.ConsistencyLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class CqlColumnListMutationImpl<K, C>
extends AbstractColumnListMutationImpl<C> {
    private ColListMutationType type = ColListMutationType.ColumnsUpdate;
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;
    private final CFQueryContext<K, C> cfContext;
    private final CqlColumnFamilyDefinitionImpl cfDef;
    private final List<CqlColumnMutationImpl<K, C>> mutationList = new ArrayList<CqlColumnMutationImpl<K, C>>();
    private AtomicReference<Boolean> deleteRow = new AtomicReference<Boolean>(false);

    public CqlColumnListMutationImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, ColumnFamily<K, C> cf, K rowKey, ConsistencyLevel level, Long timestamp) {
        super(timestamp);
        this.ksContext = ksCtx;
        this.cfContext = new CFQueryContext<K, C>(cf, rowKey, null, level);
        this.cfDef = (CqlColumnFamilyDefinitionImpl)cf.getColumnFamilyDefinition();
    }

    public <V> ColumnListMutation<C> putColumn(C columnName, V value, Serializer<V> valueSerializer, Integer ttl) {
        this.checkColumnName(columnName);
        CqlColumnMutationImpl<K, C> mutation = new CqlColumnMutationImpl<K, C>(this.ksContext, this.cfContext, columnName);
        mutation.putValue(value, valueSerializer, this.getActualTTL(ttl));
        if (this.getTimestamp() != null) {
            mutation.withTimestamp(this.getTimestamp());
        }
        this.mutationList.add(mutation);
        return this;
    }

    public <SC> ColumnListMutation<SC> withSuperColumn(ColumnPath<SC> superColumnPath) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ColumnListMutation<C> putEmptyColumn(C columnName, Integer ttl) {
        this.checkColumnName(columnName);
        Integer theTTL = this.defaultTTL.get();
        if (ttl != null) {
            theTTL = ttl;
        }
        CqlColumnMutationImpl<K, C> mutation = new CqlColumnMutationImpl<K, C>(this.ksContext, this.cfContext, columnName);
        mutation.putEmptyColumn(theTTL);
        if (this.getTimestamp() != null) {
            mutation.withTimestamp(this.getTimestamp());
        }
        this.mutationList.add(mutation);
        return this;
    }

    public ColumnListMutation<C> incrementCounterColumn(C columnName, long amount) {
        this.checkColumnName(columnName);
        this.type = ColListMutationType.CounterColumnsUpdate;
        CqlColumnMutationImpl<K, C> mutation = new CqlColumnMutationImpl<K, C>(this.ksContext, this.cfContext, columnName);
        mutation.incrementCounterColumn(amount);
        this.mutationList.add(mutation);
        return this;
    }

    public ColumnListMutation<C> deleteColumn(C columnName) {
        this.checkColumnName(columnName);
        CqlColumnMutationImpl<K, C> mutation = new CqlColumnMutationImpl<K, C>(this.ksContext, this.cfContext, columnName);
        mutation.deleteColumn();
        if (this.getTimestamp() != null) {
            mutation.withTimestamp(this.getTimestamp());
        }
        this.mutationList.add(mutation);
        return this;
    }

    public ColumnListMutation<C> delete() {
        this.deleteRow.set(true);
        this.type = ColListMutationType.RowDelete;
        return this;
    }

    public ColumnListMutation<C> setDefaultTtl(Integer newTTL) {
        if (this.defaultTTL.get() == null) {
            this.defaultTTL.set(newTTL);
            return this;
        }
        if (!this.defaultTTL.equals(newTTL)) {
            throw new RuntimeException("Default TTL has already been set, cannot reset");
        }
        return this;
    }

    public void mergeColumnListMutation(CqlColumnListMutationImpl<?, ?> colListMutation) {
        for (CqlColumnMutationImpl<?, ?> colMutation : colListMutation.getMutationList()) {
            this.mutationList.add(colMutation);
        }
    }

    public List<CqlColumnMutationImpl<K, C>> getMutationList() {
        return this.mutationList;
    }

    public ColumnListMutation<C> putColumnWithGenericValue(C columnName, Object value, Integer ttl) {
        Preconditions.checkArgument((columnName != null ? 1 : 0) != 0, (Object)"Column Name must not be null");
        CqlColumnMutationImpl<K, C> mutation = new CqlColumnMutationImpl<K, C>(this.ksContext, this.cfContext, columnName);
        mutation.putGenericValue(value, this.getActualTTL(ttl));
        this.mutationList.add(mutation);
        return this;
    }

    private Integer getActualTTL(Integer overrideTTL) {
        Integer theTTL = this.defaultTTL.get();
        if (overrideTTL != null) {
            theTTL = overrideTTL;
        }
        return theTTL;
    }

    private void checkColumnName(C columnName) {
        Preconditions.checkArgument((columnName != null ? 1 : 0) != 0, (Object)"Column Name must not be null");
        if (columnName instanceof String) {
            Preconditions.checkArgument((!((String)columnName).isEmpty() ? 1 : 0) != 0, (Object)"Column Name must not be null");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cfContext.toString());
        sb.append(" MutationList: ").append(this.mutationList.toString());
        return sb.toString();
    }

    public CFMutationQueryGen getMutationQueryGen() {
        return this.cfDef.getMutationQueryGenerator();
    }

    public ColListMutationType getType() {
        return this.type;
    }

    public Object getRowKey() {
        return this.cfContext.getRowKey();
    }

    public static enum ColListMutationType {
        RowDelete,
        ColumnsUpdate,
        CounterColumnsUpdate;

    }
}

