/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.reads.model.CqlRangeBuilder;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.query.RowQuery;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class LongColumnPaginationTests
extends KeyspaceTests {
    public static ColumnFamily<String, Long> CF_LONGCOLUMN = ColumnFamily.newColumnFamily((String)"LongColumn1", (Serializer)StringSerializer.get(), (Serializer)LongSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        LongColumnPaginationTests.initContext();
        keyspace.createColumnFamily(CF_LONGCOLUMN, null);
        CF_LONGCOLUMN.describe(keyspace);
    }

    @AfterClass
    public static void teardown() throws Exception {
        keyspace.dropColumnFamily(CF_LONGCOLUMN);
    }

    @Test
    public void paginateLongColumns() throws Exception {
        ColumnList columns;
        String rowKey = "A";
        MutationBatch m = keyspace.prepareMutationBatch();
        ColumnListMutation cfmLong = m.withRow(CF_LONGCOLUMN, (Object)rowKey);
        Long l = -10L;
        while (l < 10L) {
            cfmLong.putEmptyColumn((Object)l, null);
            Long l2 = l;
            Long l3 = l = Long.valueOf(l + 1L);
        }
        cfmLong.putEmptyColumn((Object)Long.MAX_VALUE, null);
        m.execute();
        Long column = Long.MIN_VALUE;
        int pageSize = 10;
        RowQuery query = keyspace.prepareQuery(CF_LONGCOLUMN).getKey((Object)"A").autoPaginate(true).withColumnRange((ByteBufferRange)new CqlRangeBuilder().setStart((Object)column).setFetchSize(pageSize).build());
        int pageCount = 0;
        int colCount = 0;
        while (!(columns = (ColumnList)query.execute().getResult()).isEmpty()) {
            for (Column c : columns) {
                ++colCount;
            }
            ++pageCount;
        }
        Assert.assertTrue((String)("PageCount: " + pageCount), (pageCount == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)("colCount = " + colCount), (colCount == 21 ? 1 : 0) != 0);
        query = keyspace.prepareQuery(CF_LONGCOLUMN).getKey((Object)"A").autoPaginate(true).withColumnRange((ByteBufferRange)new CqlRangeBuilder().setStart((Object)-5L).setEnd((Object)11L).setFetchSize(pageSize).build());
        pageCount = 0;
        colCount = 0;
        while (!(columns = (ColumnList)query.execute().getResult()).isEmpty()) {
            for (Column c : columns) {
                ++colCount;
            }
            ++pageCount;
        }
        Assert.assertTrue((pageCount == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("colCount = " + colCount), (colCount == 15 ? 1 : 0) != 0);
    }
}

