/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.cql.reads.model.CqlRangeBuilder;
import com.netflix.astyanax.cql.reads.model.CqlRangeImpl;
import com.netflix.astyanax.cql.test.utils.ReadTests;
import com.netflix.astyanax.cql.test.utils.TestUtils;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class RowSliceRowRangeQueryTests
extends ReadTests {
    private static ColumnFamily<String, String> CF_COLUMN_RANGE_TEST = TestUtils.CF_COLUMN_RANGE_TEST;

    @BeforeClass
    public static void init() throws Exception {
        RowSliceRowRangeQueryTests.initContext();
        keyspace.createColumnFamily(CF_COLUMN_RANGE_TEST, null);
        CF_COLUMN_RANGE_TEST.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_COLUMN_RANGE_TEST);
    }

    @Test
    public void runAllTests() throws Exception {
        boolean rowDeleted = false;
        TestUtils.populateRowsForColumnRange(keyspace);
        Thread.sleep(1000L);
        this.testRowKeysWithAllColumns(rowDeleted);
        this.testRowKeysWithColumnSet(rowDeleted);
        this.testRowKeysWithColumnRange(rowDeleted);
        this.testRowRangeWithAllColumns(rowDeleted);
        this.testRowRangeWithColumnSet(rowDeleted);
        this.testRowRangeWithColumnRange(rowDeleted);
        TestUtils.deleteRowsForColumnRange(keyspace);
        Thread.sleep(1000L);
        rowDeleted = true;
        this.testRowKeysWithAllColumns(rowDeleted);
        this.testRowKeysWithColumnSet(rowDeleted);
        this.testRowKeysWithColumnRange(rowDeleted);
        this.testRowRangeWithAllColumns(rowDeleted);
        this.testRowRangeWithColumnSet(rowDeleted);
        this.testRowRangeWithColumnRange(rowDeleted);
    }

    private void testRowKeysWithAllColumns(boolean rowDeleted) throws Exception {
        Set<String> rowKeys = this.getRandomRowKeys();
        Rows rows = (Rows)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowSlice(rowKeys).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)rows.isEmpty());
            return;
        }
        Assert.assertFalse((boolean)rows.isEmpty());
        int rowKeysSize = rowKeys.size();
        for (Row row : rows) {
            boolean isPresent = rowKeys.remove(row.getKey());
            Assert.assertTrue((String)("Extraneous row: " + (String)row.getKey()), (boolean)isPresent);
            ColumnList colList = row.getColumns();
            Assert.assertEquals((int)26, (int)colList.size());
            for (int index = 0; index < 26; ++index) {
                Column col = colList.getColumnByIndex(index);
                Assert.assertTrue((boolean)String.valueOf((char)(97 + index)).equals(col.getName()));
                Assert.assertEquals((int)(index + 1), (int)col.getIntegerValue());
            }
        }
        Assert.assertEquals((int)rowKeysSize, (int)rows.size());
    }

    private void testRowKeysWithColumnSet(boolean rowDeleted) throws Exception {
        Set<String> rowKeys = this.getRandomRowKeys();
        Set<String> columns = this.getRandomColumns();
        Rows rows = (Rows)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowSlice(rowKeys).withColumnSlice(columns).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)rows.isEmpty());
            return;
        }
        Assert.assertFalse((boolean)rows.isEmpty());
        ArrayList<String> expected = new ArrayList<String>(columns);
        Collections.sort(expected);
        int rowKeysSize = rowKeys.size();
        for (Row row : rows) {
            boolean isPresent = rowKeys.remove(row.getKey());
            Assert.assertTrue((String)("Extraneous row: " + (String)row.getKey()), (boolean)isPresent);
            ArrayList<Object> result = new ArrayList<Object>();
            ColumnList colList = row.getColumns();
            for (Column col : colList) {
                result.add(col.getName());
            }
            Collections.sort(result);
            Assert.assertEquals(expected, result);
        }
        Assert.assertEquals((int)rowKeysSize, (int)rows.size());
    }

    private void testRowKeysWithColumnRange(boolean rowDeleted) throws Exception {
        Set<String> rowKeys = this.getRandomRowKeys();
        CqlRangeImpl columns = (CqlRangeImpl)this.getRandomColumnRange();
        Rows rows = (Rows)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowSlice(rowKeys).withColumnRange((ByteBufferRange)columns).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)rows.isEmpty());
            return;
        }
        Assert.assertFalse((boolean)rows.isEmpty());
        int rowKeysSize = rowKeys.size();
        for (Row row : rows) {
            boolean isPresent = rowKeys.remove(row.getKey());
            Assert.assertTrue((String)("Extraneous row: " + (String)row.getKey()), (boolean)isPresent);
            int numExpectedCols = ((String)columns.getCqlEnd()).charAt(0) - ((String)columns.getCqlStart()).charAt(0) + 1;
            ColumnList colList = row.getColumns();
            Assert.assertEquals((int)numExpectedCols, (int)colList.size());
            for (Column col : colList) {
                Assert.assertTrue((((String)col.getName()).compareTo((String)columns.getCqlStart()) >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((((String)col.getName()).compareTo((String)columns.getCqlEnd()) <= 0 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((int)rowKeysSize, (int)rows.size());
    }

    private void testRowRangeWithAllColumns(boolean rowDeleted) throws Exception {
        ArrayList<String> expectedColumns = new ArrayList<String>();
        for (char ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            expectedColumns.add(String.valueOf(ch));
        }
        for (TestUtils.TestTokenRange testRange : this.getTestTokenRanges()) {
            Rows rows = (Rows)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowRange(null, null, testRange.startToken, testRange.endToken, -1).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)rows.isEmpty());
                continue;
            }
            Assert.assertFalse((boolean)rows.isEmpty());
            ArrayList<String> list = new ArrayList<String>();
            for (Row row : rows) {
                String key = (String)row.getKey();
                list.add(key);
                ColumnList columns = row.getColumns();
                this.testRangeColumnsForRow((ColumnList<String>)columns, expectedColumns);
            }
            Assert.assertEquals(testRange.expectedRowKeys, list);
        }
    }

    private void testRowRangeWithColumnSet(boolean rowDeleted) throws Exception {
        Set<String> randomColumns = this.getRandomColumns();
        ArrayList<String> expectedColumns = new ArrayList<String>(randomColumns);
        Collections.sort(expectedColumns);
        for (TestUtils.TestTokenRange testRange : this.getTestTokenRanges()) {
            Rows rows = (Rows)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowRange(null, null, testRange.startToken, testRange.endToken, -1).withColumnSlice(randomColumns).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)rows.isEmpty());
                continue;
            }
            Assert.assertFalse((boolean)rows.isEmpty());
            ArrayList<String> list = new ArrayList<String>();
            for (Row row : rows) {
                String key = (String)row.getKey();
                list.add(key);
                ColumnList columns = row.getColumns();
                this.testRangeColumnsForRow((ColumnList<String>)columns, expectedColumns);
            }
            Assert.assertEquals(testRange.expectedRowKeys, list);
        }
    }

    private void testRowRangeWithColumnRange(boolean rowDeleted) throws Exception {
        CqlRangeImpl columnRange = (CqlRangeImpl)this.getRandomColumnRange();
        for (TestUtils.TestTokenRange testRange : this.getTestTokenRanges()) {
            Rows rows = (Rows)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowRange(null, null, testRange.startToken, testRange.endToken, -1).withColumnRange((ByteBufferRange)columnRange).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)rows.isEmpty());
                continue;
            }
            Assert.assertFalse((boolean)rows.isEmpty());
            int numExpectedCols = ((String)columnRange.getCqlEnd()).charAt(0) - ((String)columnRange.getCqlStart()).charAt(0) + 1;
            ArrayList<String> list = new ArrayList<String>();
            for (Row row : rows) {
                String key = (String)row.getKey();
                list.add(key);
                ColumnList colList = row.getColumns();
                Assert.assertEquals((int)numExpectedCols, (int)colList.size());
                for (Column col : colList) {
                    Assert.assertTrue((((String)col.getName()).compareTo((String)columnRange.getCqlStart()) >= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((((String)col.getName()).compareTo((String)columnRange.getCqlEnd()) <= 0 ? 1 : 0) != 0);
                }
            }
            Assert.assertEquals(testRange.expectedRowKeys, list);
        }
    }

    private Set<String> getRandomRowKeys() {
        Random random = new Random();
        int numRowKeys = random.nextInt(26) + 1;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numRowKeys; ++i) {
            int no = random.nextInt(26);
            char ch = (char)(65 + no);
            set.add(String.valueOf(ch));
        }
        System.out.println("Set: " + set);
        return set;
    }

    private Set<String> getRandomColumns() {
        Random random = new Random();
        int numRowKeys = random.nextInt(26) + 1;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < numRowKeys; ++i) {
            int no = random.nextInt(26);
            char ch = (char)(97 + no);
            set.add(String.valueOf(ch));
        }
        return set;
    }

    private ByteBufferRange getRandomColumnRange() {
        Random random = new Random();
        Integer n1 = random.nextInt(26);
        Integer n2 = random.nextInt(26);
        String c1 = String.valueOf((char)(97 + n1));
        String c2 = String.valueOf((char)(97 + n2));
        if (n1 < n2) {
            return new CqlRangeBuilder().setStart((Object)c1).setEnd((Object)c2).build();
        }
        return new CqlRangeBuilder().setStart((Object)c2).setEnd((Object)c1).build();
    }

    private List<TestUtils.TestTokenRange> getTestTokenRanges() {
        return TestUtils.getTestTokenRanges();
    }

    private void testRangeColumnsForRow(ColumnList<String> columns, List<String> expected) {
        Iterator iter1 = columns.iterator();
        Iterator<String> iter2 = expected.iterator();
        while (iter2.hasNext()) {
            Column column = (Column)iter1.next();
            String expectedName = iter2.next();
            Assert.assertEquals((String)expectedName, (String)((String)column.getName()));
            int expectedValue = expectedName.charAt(0) - 97 + 1;
            Assert.assertEquals((int)expectedValue, (int)column.getIntegerValue());
        }
    }
}

