/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.cql.reads.model.CqlRangeBuilder;
import com.netflix.astyanax.cql.test.utils.ReadTests;
import com.netflix.astyanax.cql.test.utils.TestUtils;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.query.RowQuery;
import java.util.Random;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SingleRowColumnPaginationTests
extends ReadTests {
    private static ColumnFamily<String, String> CF_COLUMN_RANGE_TEST = TestUtils.CF_COLUMN_RANGE_TEST;

    @BeforeClass
    public static void init() throws Exception {
        SingleRowColumnPaginationTests.initContext();
        keyspace.createColumnFamily(CF_COLUMN_RANGE_TEST, null);
        CF_COLUMN_RANGE_TEST.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_COLUMN_RANGE_TEST);
    }

    @Test
    public void runAllTests() throws Exception {
        boolean rowDeleted = false;
        TestUtils.populateRowsForColumnRange(keyspace);
        Thread.sleep(1000L);
        this.paginateColumnsForAllRows(rowDeleted);
        TestUtils.deleteRowsForColumnRange(keyspace);
        Thread.sleep(1000L);
        rowDeleted = true;
        this.paginateColumnsForAllRows(rowDeleted);
    }

    private void paginateColumnsForAllRows(boolean rowDeleted) throws Exception {
        Random random = new Random();
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            int pageSize = random.nextInt(26) % 10;
            if (pageSize <= 0) {
                pageSize = 10;
            }
            this.paginateColumnsForRowKey(String.valueOf(ch), rowDeleted, pageSize);
        }
    }

    private void paginateColumnsForRowKey(String rowKey, boolean rowDeleted, int pageSize) throws Exception {
        ColumnList columns;
        RowQuery query = keyspace.prepareQuery(TestUtils.CF_COLUMN_RANGE_TEST).getKey((Object)rowKey).autoPaginate(true).withColumnRange((ByteBufferRange)new CqlRangeBuilder().setStart((Object)"a").setFetchSize(pageSize).build());
        int count = 1;
        while (!(columns = (ColumnList)query.execute().getResult()).isEmpty()) {
            Assert.assertTrue((columns.size() <= pageSize ? 1 : 0) != 0);
            for (Column col : columns) {
                int value = ((String)col.getName()).charAt(0) - 97 + 1;
                Assert.assertEquals((int)count, (int)value);
                ++count;
            }
        }
        if (rowDeleted) {
            Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        }
    }
}

