/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test.recipes;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.recipes.storage.CassandraChunkedStorageProvider;
import com.netflix.astyanax.recipes.storage.ChunkedStorage;
import com.netflix.astyanax.recipes.storage.ChunkedStorageProvider;
import com.netflix.astyanax.recipes.storage.ObjectMetadata;
import com.netflix.astyanax.serializers.StringSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ChunkedObjectStoreTest
extends KeyspaceTests {
    public static ColumnFamily<String, String> CF_CHUNK = ColumnFamily.newColumnFamily((String)"cfchunk", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        ChunkedObjectStoreTest.initContext();
        keyspace.createColumnFamily(CF_CHUNK, null);
        CF_CHUNK.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_CHUNK);
    }

    @Test
    public void testAll() throws Exception {
        CassandraChunkedStorageProvider provider = new CassandraChunkedStorageProvider(keyspace, CF_CHUNK);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            sb.append("abcdefghijklmnopqrstuvwxyz_");
        }
        String input = sb.toString();
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes());
        ObjectMetadata meta = ChunkedStorage.newWriter((ChunkedStorageProvider)provider, (String)"MyObject", (InputStream)in).withChunkSize(100).call();
        meta = ChunkedStorage.newInfoReader((ChunkedStorageProvider)provider, (String)"MyObject").call();
        System.out.println(meta.getObjectSize().intValue());
        System.out.println(meta.getChunkCount());
        ByteArrayOutputStream os = new ByteArrayOutputStream(meta.getObjectSize().intValue());
        meta = ChunkedStorage.newReader((ChunkedStorageProvider)provider, (String)"MyObject", (OutputStream)os).withBatchSize(11).withConcurrencyLevel(3).call();
        String output = os.toString();
        Assert.assertEquals((String)input, (String)output);
        ChunkedStorage.newDeleter((ChunkedStorageProvider)provider, (String)"MyObject").call();
        for (int i = 0; i < meta.getChunkCount(); ++i) {
            ColumnList result = (ColumnList)keyspace.prepareQuery(CF_CHUNK).getKey((Object)("MyObject$" + i)).execute().getResult();
            Assert.assertTrue((boolean)result.isEmpty());
        }
    }
}

