/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.ExceptionCallback;
import com.netflix.astyanax.RowCallback;
import com.netflix.astyanax.connectionpool.ConnectionContext;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.impl.OperationResultImpl;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.query.AllRowsQuery;
import com.netflix.astyanax.query.CheckpointManager;
import com.netflix.astyanax.shallows.EmptyCheckpointManager;
import com.netflix.astyanax.thrift.AbstractKeyspaceOperationImpl;
import com.netflix.astyanax.thrift.ThriftAllRowsImpl;
import com.netflix.astyanax.thrift.ThriftColumnFamilyQueryImpl;
import com.netflix.astyanax.thrift.ThriftConverter;
import com.netflix.astyanax.thrift.ThriftKeyspaceImpl;
import com.netflix.astyanax.thrift.ThriftUtils;
import com.netflix.astyanax.thrift.model.ThriftRowsSliceImpl;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftAllRowsQueryImpl<K, C>
implements AllRowsQuery<K, C> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftAllRowsQueryImpl.class);
    private final ThriftColumnFamilyQueryImpl<K, C> query;
    protected SlicePredicate predicate = new SlicePredicate().setSlice_range(ThriftUtils.createAllInclusiveSliceRange());
    protected CheckpointManager checkpointManager = new EmptyCheckpointManager();
    protected ColumnFamily<K, C> columnFamily;
    private ExceptionCallback exceptionCallback;
    private int blockSize = 100;
    private boolean repeatLastToken = true;
    private Integer nThreads;
    private String startToken;
    private String endToken;
    private Boolean includeEmptyRows;

    public ThriftAllRowsQueryImpl(ThriftColumnFamilyQueryImpl<K, C> query) {
        this.columnFamily = query.columnFamily;
        this.query = query;
    }

    protected List<KeySlice> getNextBlock(final KeyRange range) {
        ThriftKeyspaceImpl keyspace = this.query.keyspace;
        while (true) {
            try {
                return (List)keyspace.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<List<KeySlice>>(keyspace.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_RANGE, this.columnFamily), this.query.pinnedHost, keyspace.getKeyspaceName()){

                    @Override
                    public List<KeySlice> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                        List slice = client.get_range_slices(new ColumnParent().setColumn_family(ThriftAllRowsQueryImpl.this.columnFamily.getName()), ThriftAllRowsQueryImpl.this.predicate, range, ThriftConverter.ToThriftConsistencyLevel(((ThriftAllRowsQueryImpl)ThriftAllRowsQueryImpl.this).query.consistencyLevel));
                        return slice;
                    }

                    @Override
                    public ByteBuffer getRowKey() {
                        if (range.getStart_key() != null) {
                            return range.start_key;
                        }
                        return null;
                    }
                }, this.query.retry).getResult();
            }
            catch (ConnectionException e) {
                if (this.getExceptionCallback() != null) continue;
                throw new RuntimeException(e);
                if (this.getExceptionCallback().onException(e)) continue;
                return new ArrayList<KeySlice>();
            }
            break;
        }
    }

    public OperationResult<Rows<K, C>> execute() throws ConnectionException {
        return new OperationResultImpl(Host.NO_HOST, new ThriftAllRowsImpl<K, C>(this.query.keyspace.getPartitioner(), this, this.columnFamily), 0L);
    }

    public ListenableFuture<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
        throw new UnsupportedOperationException("executeAsync not supported here.  Use execute()");
    }

    private boolean shouldIgnoreEmptyRows() {
        if (this.getIncludeEmptyRows() == null) {
            return !this.getPredicate().isSetSlice_range() || this.getPredicate().getSlice_range().getCount() != 0;
        }
        return this.getIncludeEmptyRows() == false;
    }

    public void executeWithCallback(RowCallback<K, C> callback) throws ConnectionException {
        List<Pair> ranges;
        final ThriftKeyspaceImpl keyspace = this.query.keyspace;
        Partitioner partitioner = keyspace.getPartitioner();
        final AtomicReference error = new AtomicReference();
        boolean bIgnoreTombstones = this.shouldIgnoreEmptyRows();
        if (this.getConcurrencyLevel() != null) {
            ranges = Lists.newArrayList();
            int nThreads = this.getConcurrencyLevel();
            List tokens = partitioner.splitTokenRange(this.startToken == null ? partitioner.getMinToken() : this.startToken, this.endToken == null ? partitioner.getMaxToken() : this.endToken, nThreads);
            for (TokenRange range : tokens) {
                try {
                    String currentToken = this.checkpointManager.getCheckpoint(range.getStartToken());
                    if (currentToken == null) {
                        currentToken = range.getStartToken();
                    } else if (currentToken.equals(range.getEndToken())) continue;
                    ranges.add(Pair.create((Object)currentToken, (Object)range.getEndToken()));
                }
                catch (Exception e) {
                    throw ThriftConverter.ToConnectionPoolException(e);
                }
            }
        } else {
            ranges = Lists.transform(keyspace.describeRing(true), (Function)new Function<TokenRange, Pair<String, String>>(){

                public Pair<String, String> apply(TokenRange input) {
                    return Pair.create((Object)input.getStartToken(), (Object)input.getEndToken());
                }
            });
        }
        final CountDownLatch doneSignal = new CountDownLatch(ranges.size());
        for (Pair tokenPair : ranges) {
            TokenRange range;
            range = new KeyRange().setCount(this.getBlockSize()).setStart_token((String)tokenPair.left).setEnd_token((String)tokenPair.right);
            this.query.executor.submit((Callable)new Callable<Void>((KeyRange)range, bIgnoreTombstones, callback, partitioner, tokenPair){
                private boolean firstBlock = true;
                final /* synthetic */ KeyRange val$range;
                final /* synthetic */ boolean val$bIgnoreTombstones;
                final /* synthetic */ RowCallback val$callback;
                final /* synthetic */ Partitioner val$partitioner;
                final /* synthetic */ Pair val$tokenPair;
                {
                    this.val$range = keyRange;
                    this.val$bIgnoreTombstones = bl;
                    this.val$callback = rowCallback;
                    this.val$partitioner = partitioner;
                    this.val$tokenPair = pair;
                }

                @Override
                public Void call() throws Exception {
                    if (error.get() == null && this.internalRun()) {
                        ((ThriftAllRowsQueryImpl)ThriftAllRowsQueryImpl.this).query.executor.submit((Callable)this);
                    } else {
                        doneSignal.countDown();
                    }
                    return null;
                }

                private boolean internalRun() throws Exception {
                    block13: {
                        try {
                            List ks = (List)keyspace.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<List<KeySlice>>(keyspace.tracerFactory.newTracer(CassandraOperationType.GET_ROWS_RANGE, ThriftAllRowsQueryImpl.this.columnFamily), ((ThriftAllRowsQueryImpl)ThriftAllRowsQueryImpl.this).query.pinnedHost, keyspace.getKeyspaceName()){

                                @Override
                                public List<KeySlice> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                                    return client.get_range_slices(new ColumnParent().setColumn_family(ThriftAllRowsQueryImpl.this.columnFamily.getName()), ThriftAllRowsQueryImpl.this.predicate, val$range, ThriftConverter.ToThriftConsistencyLevel(((ThriftAllRowsQueryImpl)ThriftAllRowsQueryImpl.this).query.consistencyLevel));
                                }

                                @Override
                                public ByteBuffer getRowKey() {
                                    if (val$range.getStart_key() != null) {
                                        return ByteBuffer.wrap(val$range.getStart_key());
                                    }
                                    return null;
                                }
                            }, ((ThriftAllRowsQueryImpl)ThriftAllRowsQueryImpl.this).query.retry.duplicate()).getResult();
                            if (!ks.isEmpty()) {
                                boolean bContinue;
                                KeySlice lastRow = (KeySlice)Iterables.getLast((Iterable)ks);
                                boolean bl = bContinue = ks.size() == ThriftAllRowsQueryImpl.this.getBlockSize();
                                if (ThriftAllRowsQueryImpl.this.getRepeatLastToken()) {
                                    if (this.firstBlock) {
                                        this.firstBlock = false;
                                    } else {
                                        ks.remove(0);
                                    }
                                }
                                if (this.val$bIgnoreTombstones) {
                                    Iterator iter = ks.iterator();
                                    while (iter.hasNext()) {
                                        if (((KeySlice)iter.next()).getColumnsSize() != 0) continue;
                                        iter.remove();
                                    }
                                }
                                ThriftRowsSliceImpl rows = new ThriftRowsSliceImpl(ks, ThriftAllRowsQueryImpl.this.columnFamily.getKeySerializer(), ThriftAllRowsQueryImpl.this.columnFamily.getColumnSerializer());
                                try {
                                    this.val$callback.success(rows);
                                }
                                catch (Throwable t) {
                                    ConnectionException ce = ThriftConverter.ToConnectionPoolException(t);
                                    error.set(ce);
                                    return false;
                                }
                                if (bContinue) {
                                    String token = this.val$partitioner.getTokenForKey(lastRow.bufferForKey()).toString();
                                    ThriftAllRowsQueryImpl.this.checkpointManager.trackCheckpoint((String)this.val$tokenPair.left, token);
                                    if (ThriftAllRowsQueryImpl.this.getRepeatLastToken()) {
                                        this.val$range.setStart_token(this.val$partitioner.getTokenMinusOne(token));
                                    } else {
                                        this.val$range.setStart_token(token);
                                    }
                                    break block13;
                                }
                                ThriftAllRowsQueryImpl.this.checkpointManager.trackCheckpoint((String)this.val$tokenPair.left, (String)this.val$tokenPair.right);
                                return false;
                            }
                            ThriftAllRowsQueryImpl.this.checkpointManager.trackCheckpoint((String)this.val$tokenPair.left, (String)this.val$tokenPair.right);
                            return false;
                        }
                        catch (Exception e) {
                            ConnectionException ce = ThriftConverter.ToConnectionPoolException(e);
                            if (this.val$callback.failure(ce)) break block13;
                            error.set(ce);
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        try {
            doneSignal.await();
        }
        catch (InterruptedException e) {
            LOG.debug("Execution interrupted on get all rows for keyspace " + keyspace.getKeyspaceName());
        }
        if (error.get() != null) {
            throw (ConnectionException)((Object)error.get());
        }
    }

    public AllRowsQuery<K, C> setExceptionCallback(ExceptionCallback cb) {
        this.exceptionCallback = cb;
        return this;
    }

    protected ExceptionCallback getExceptionCallback() {
        return this.exceptionCallback;
    }

    public AllRowsQuery<K, C> setThreadCount(int numberOfThreads) {
        this.setConcurrencyLevel(numberOfThreads);
        return this;
    }

    public AllRowsQuery<K, C> setConcurrencyLevel(int numberOfThreads) {
        this.nThreads = numberOfThreads;
        return this;
    }

    public AllRowsQuery<K, C> setCheckpointManager(CheckpointManager manager) {
        this.checkpointManager = manager;
        return this;
    }

    public AllRowsQuery<K, C> withColumnSlice(C ... columns) {
        if (columns != null) {
            this.predicate.setColumn_names(this.columnFamily.getColumnSerializer().toBytesList(Arrays.asList(columns))).setSlice_rangeIsSet(false);
        }
        return this;
    }

    public AllRowsQuery<K, C> withColumnSlice(Collection<C> columns) {
        if (columns != null) {
            this.predicate.setColumn_names(this.columnFamily.getColumnSerializer().toBytesList(columns)).setSlice_rangeIsSet(false);
        }
        return this;
    }

    public AllRowsQuery<K, C> withColumnRange(C startColumn, C endColumn, boolean reversed, int count) {
        this.predicate.setSlice_range(ThriftUtils.createSliceRange(this.columnFamily.getColumnSerializer(), startColumn, endColumn, reversed, count));
        return this;
    }

    public AllRowsQuery<K, C> withColumnRange(ByteBuffer startColumn, ByteBuffer endColumn, boolean reversed, int count) {
        this.predicate.setSlice_range(new SliceRange(startColumn, endColumn, reversed, count));
        return this;
    }

    public AllRowsQuery<K, C> withColumnSlice(ColumnSlice<C> slice) {
        if (slice.getColumns() != null) {
            this.predicate.setColumn_names(this.columnFamily.getColumnSerializer().toBytesList(slice.getColumns())).setSlice_rangeIsSet(false);
        } else {
            this.predicate.setSlice_range(ThriftUtils.createSliceRange(this.columnFamily.getColumnSerializer(), slice.getStartColumn(), slice.getEndColumn(), slice.getReversed(), slice.getLimit()));
        }
        return this;
    }

    public AllRowsQuery<K, C> withColumnRange(ByteBufferRange range) {
        this.predicate.setSlice_range(new SliceRange().setStart(range.getStart()).setFinish(range.getEnd()).setCount(range.getLimit()).setReversed(range.isReversed()));
        return this;
    }

    public AllRowsQuery<K, C> setBlockSize(int blockSize) {
        return this.setRowLimit(blockSize);
    }

    public AllRowsQuery<K, C> setRowLimit(int rowLimit) {
        this.blockSize = rowLimit;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public AllRowsQuery<K, C> setRepeatLastToken(boolean repeatLastToken) {
        this.repeatLastToken = repeatLastToken;
        return this;
    }

    public boolean getRepeatLastToken() {
        return this.repeatLastToken;
    }

    protected Integer getConcurrencyLevel() {
        return this.nThreads;
    }

    public AllRowsQuery<K, C> setIncludeEmptyRows(boolean flag) {
        this.includeEmptyRows = flag;
        return this;
    }

    public String getStartToken() {
        return this.startToken;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public AllRowsQuery<K, C> forTokenRange(BigInteger startToken, BigInteger endToken) {
        return this.forTokenRange(startToken.toString(), endToken.toString());
    }

    public AllRowsQuery<K, C> forTokenRange(String startToken, String endToken) {
        this.startToken = startToken;
        this.endToken = endToken;
        return this;
    }

    SlicePredicate getPredicate() {
        return this.predicate;
    }

    Boolean getIncludeEmptyRows() {
        return this.includeEmptyRows;
    }
}

