/*
 * Decompiled with CFR 0.152.
 */
package com.nicta.scoobi.application;

import com.nicta.scoobi.application.LibJars;
import com.nicta.scoobi.application.LibJars$;
import com.nicta.scoobi.application.ScoobiConfiguration;
import com.nicta.scoobi.application.ScoobiConfiguration$;
import com.nicta.scoobi.impl.control.SystemProperties;
import com.nicta.scoobi.impl.control.SystemProperties$;
import com.nicta.scoobi.impl.monitor.Loggable$;
import com.nicta.scoobi.io.FileSystems;
import com.nicta.scoobi.io.FileSystems$;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class LibJars$class {
    public static final Log com$nicta$scoobi$application$LibJars$$logger(LibJars $this) {
        return LogFactory.getLog((String)"scoobi.LibJars");
    }

    public static FileSystems fss(LibJars $this) {
        return FileSystems$.MODULE$;
    }

    public static SystemProperties sysProps(LibJars $this) {
        return SystemProperties$.MODULE$;
    }

    public static String libjarsDirectory(LibJars $this) {
        return $this.fss().dirPath((String)$this.sysProps().get("scoobi.libjarsdir").getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "libjars";
            }
        }));
    }

    public static boolean upload(LibJars $this) {
        return true;
    }

    public static Seq jars(LibJars $this) {
        return (Seq)$this.classLoaderJars().$plus$plus($this.hadoopClasspathJars(), Seq$.MODULE$.canBuildFrom());
    }

    public static Seq classLoaderJars(LibJars $this) {
        return Predef$.MODULE$.wrapRefArray((Object[])Loggable$.MODULE$.asLoggable(new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final URL[] apply() {
                return (URL[])Predef$.MODULE$.refArrayOps((Object[])((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(URL url) {
                        return !url.getFile().contains("hadoop-core");
                    }
                });
            }
        }, $this.com$nicta$scoobi$application$LibJars$$logger()).debugNot(new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(URL[] uRLArray) {
                return Predef$.MODULE$.refArrayOps((Object[])uRLArray).isEmpty();
            }
        }, new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(URL[] jars) {
                return new StringBuilder().append((Object)"jars found with the classloader\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])jars).mkString("\n")).toString();
            }
        }));
    }

    public static Seq hadoopClasspathJars(LibJars $this) {
        return (Seq)Loggable$.MODULE$.asLoggable(new Serializable($this){
            public static final long serialVersionUID;
            private final LibJars $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<URL> apply() {
                return (Seq)this.$outer.hadoopClasspaths().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final LibJars$.anonfun.hadoopClasspathJars.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Seq<URL> apply(String string) {
                        return this.$outer.com$nicta$scoobi$application$LibJars$$anonfun$$$outer().jarsOnPath(string);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public LibJars com$nicta$scoobi$application$LibJars$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, $this.com$nicta$scoobi$application$LibJars$$logger()).debugNot(new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Seq<URL> seq) {
                return seq.isEmpty();
            }
        }, new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Seq<URL> jars) {
                return new StringBuilder().append((Object)"the jars found with the $HADOOP_CLASSPATH variable are\n").append((Object)jars.mkString("\n")).toString();
            }
        });
    }

    public static Seq hadoopClasspaths(LibJars $this) {
        return (Seq)$this.sysProps().getEnv("HADOOP_CLASSPATH").orElse((Function0)new Serializable($this){
            public static final long serialVersionUID;
            private final LibJars $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final None$ apply() {
                return (None$)Loggable$.MODULE$.asLoggable(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final None$ apply() {
                        return None$.MODULE$;
                    }
                }, this.$outer.com$nicta$scoobi$application$LibJars$$logger()).debug(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(None$ x$3) {
                        return true;
                    }
                }, new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply(None$ x$4) {
                        return "HADOOP_CLASSPATH variable is not set";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<String> apply(String string) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(string).split(File.pathSeparatorChar)).toSeq();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
    }

    public static Seq jarsOnPath(LibJars $this, String path) {
        return path.endsWith(".jar") ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URL[]{new File(path).toURI().toURL()})) : (path.endsWith("/*") ? (Seq)$this.fss().listFilePaths(path.replace("/*", "")).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID;
            private final LibJars $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<URL> apply(String string) {
                return this.$outer.jarsOnPath(string);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public static Seq uploadedJars(LibJars $this, ScoobiConfiguration configuration2) {
        return $this.fss().listPaths($this.libjarsDirectory(), configuration2);
    }

    public static void deleteJars(LibJars $this, ScoobiConfiguration configuration2) {
        $this.fss().deleteFiles($this.libjarsDirectory(), configuration2);
    }

    public static Object uploadLibJarsFiles(LibJars $this, boolean deleteLibJarsFirst, ScoobiConfiguration configuration2) {
        Object object;
        if (deleteLibJarsFirst) {
            $this.com$nicta$scoobi$application$LibJars$$logger().debug((Object)"delete existing lib jars on the cluster");
            $this.deleteJars(configuration2);
        }
        if ($this.upload()) {
            Loggable$.MODULE$.asLoggable(new Serializable($this){
                public static final long serialVersionUID;
                private final LibJars $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Log apply() {
                    return this.$outer.com$nicta$scoobi$application$LibJars$$logger();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, $this.com$nicta$scoobi$application$LibJars$$logger()).debugNot($this.fss().exists($this.libjarsDirectory(), configuration2), new StringBuilder().append((Object)"creating a libjars directory at ").append((Object)$this.libjarsDirectory()).append((Object)" (file system is remote: ").append((Object)BoxesRunTime.boxToBoolean((!$this.fss().isLocal(configuration2) ? 1 : 0) != 0)).append((Object)")").toString());
            $this.fss().mkdir($this.libjarsDirectory(), configuration2);
            Seq jarFiles = (Seq)((TraversableLike)$this.jars().map((Function1)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final File apply(URL url) {
                    return new File(url.getFile());
                }
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File f) {
                    return f.exists() && !f.isDirectory();
                }
            });
            $this.fss().uploadNewJars((Seq<File>)jarFiles, $this.libjarsDirectory(), configuration2);
            object = $this.configureJars(configuration2);
        } else {
            $this.com$nicta$scoobi$application$LibJars$$logger().debug((Object)"no jars are uploaded because upload=false");
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public static boolean uploadLibJarsFiles$default$1(LibJars $this) {
        return false;
    }

    public static Object configureJars(LibJars $this, ScoobiConfiguration configuration$1) {
        BoxedUnit boxedUnit;
        if ($this.upload()) {
            $this.com$nicta$scoobi$application$LibJars$$logger().debug((Object)"adding the jars paths to the distributed cache");
            $this.uploadedJars(configuration$1).foreach((Function1)new Serializable($this, configuration$1){
                public static final long serialVersionUID;
                private final ScoobiConfiguration configuration$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Path path) {
                    DistributedCache.addFileToClassPath((Path)path, (Configuration)ScoobiConfiguration$.MODULE$.toConfiguration(this.configuration$1));
                }
                {
                    this.configuration$1 = scoobiConfiguration;
                }
            });
            $this.com$nicta$scoobi$application$LibJars$$logger().debug((Object)"adding the jars classpaths to the mapred.classpath variable");
            boxedUnit = ScoobiConfiguration$.MODULE$.toExtendedConfiguration(configuration$1).addValues("mapred.classpath", (Seq<String>)((Seq)$this.jars().map((Function1)new Serializable($this){
                public static final long serialVersionUID;
                private final LibJars $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(URL j) {
                    return new StringBuilder().append((Object)this.$outer.libjarsDirectory()).append((Object)new File(j.getFile()).getName()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())), ":");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static void $init$(LibJars $this) {
    }
}

