/*
 * Decompiled with CFR 0.152.
 */
package com.nicta.scoobi.core;

import com.nicta.scoobi.core.WireFormat;
import com.nicta.scoobi.core.WireFormat$;
import com.nicta.scoobi.core.WireFormatImplicits;
import com.nicta.scoobi.io.avro.AvroSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.hadoop.io.Writable;
import scala.Function0;
import scala.Function1;
import scala.Left;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Right;
import scala.Some;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

public abstract class WireFormatImplicits$class {
    public static WireFormat mkObjectWireFormat(WireFormatImplicits $this, Object x2) {
        return new WireFormatImplicits.ObjectWireFormat<Object>($this, x2);
    }

    public static WireFormat mkCaseWireFormat(WireFormatImplicits $this, Function0 apply2, Function1 unapply) {
        return new WireFormatImplicits.Case0WireFormat($this, apply2, unapply);
    }

    public static WireFormat mkCaseWireFormat(WireFormatImplicits $this, Function1 apply2, Function1 unapply, WireFormat evidence$2) {
        return new WireFormatImplicits.Case1WireFormat($this, apply2, unapply, evidence$2);
    }

    public static WireFormat AnythingFmt(WireFormatImplicits $this) {
        return new WireFormat<T>($this){

            public void toWire(T x2, DataOutput out) {
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                ObjectOutputStream bOut = new ObjectOutputStream(bytesOut);
                bOut.writeObject(x2);
                bOut.close();
                byte[] arr = bytesOut.toByteArray();
                out.writeInt(Predef$.MODULE$.byteArrayOps(arr).size());
                out.write(arr);
            }

            public T fromWire(DataInput in) {
                int size = in.readInt();
                byte[] barr = new byte[size];
                in.readFully(barr);
                ObjectInputStream bIn = new ObjectInputStream(new ByteArrayInputStream(barr));
                return (T)((Serializable)bIn.readObject());
            }
        };
    }

    public static WireFormat WritableFmt(WireFormatImplicits $this, Manifest evidence$3$1) {
        return new WireFormat<T>($this, evidence$3$1){
            private final Manifest evidence$3$1;

            public void toWire(T x2, DataOutput out) {
                x2.write(out);
            }

            /*
             * WARNING - void declaration
             */
            public T fromWire(DataInput in) {
                void var2_3;
                Writable x2;
                Writable exceptionResult1 = null;
                try {
                    x2 = exceptionResult1 = (Writable)((ClassManifest)Predef$.MODULE$.implicitly((Object)this.evidence$3$1)).erasure().newInstance();
                }
                catch (Throwable throwable) {
                    throw package$.MODULE$.error(new StringBuilder().append((Object)"Hadoop does not support using a Writable type (").append((Object)((ClassManifest)Predef$.MODULE$.implicitly((Object)this.evidence$3$1)).erasure().getCanonicalName()).append((Object)") unless it can be constructed with an empty-argument constructor. One simple way to get around this,").append((Object)" is by creating a new type by inheriting from, and making sure that subclass has a (working) no-argument constructor").toString());
                }
                x2.readFields(in);
                return var2_3;
            }
            {
                this.evidence$3$1 = manifest;
            }
        };
    }

    public static WireFormatImplicits.AvroWireFormat AvroFmt(WireFormatImplicits $this, Manifest evidence$4, AvroSchema evidence$5) {
        return new WireFormatImplicits.AvroWireFormat($this, evidence$4, evidence$5);
    }

    public static WireFormat UnitFmt(WireFormatImplicits $this) {
        return new WireFormat<BoxedUnit>($this){

            public void toWire(BoxedUnit x2, DataOutput out) {
            }

            public void fromWire(DataInput in) {
            }
        };
    }

    public static WireFormat IntFmt(WireFormatImplicits $this) {
        return new WireFormat<Object>($this){

            public void toWire(int x2, DataOutput out) {
                out.writeInt(x2);
            }

            public int fromWire(DataInput in) {
                return in.readInt();
            }
        };
    }

    public static WireFormat IntegerFmt(WireFormatImplicits $this) {
        return new WireFormat<Integer>($this){

            public void toWire(Integer x2, DataOutput out) {
                out.writeInt(Predef$.MODULE$.Integer2int(x2));
            }

            public Integer fromWire(DataInput in) {
                return Predef$.MODULE$.int2Integer(in.readInt());
            }
        };
    }

    public static WireFormat BooleanFmt(WireFormatImplicits $this) {
        return new WireFormat<Object>($this){

            public void toWire(boolean x2, DataOutput out) {
                out.writeBoolean(x2);
            }

            public boolean fromWire(DataInput in) {
                return in.readBoolean();
            }
        };
    }

    public static WireFormat LongFmt(WireFormatImplicits $this) {
        return new WireFormat<Object>($this){

            public void toWire(long x2, DataOutput out) {
                out.writeLong(x2);
            }

            public long fromWire(DataInput in) {
                return in.readLong();
            }
        };
    }

    public static WireFormat DoubleFmt(WireFormatImplicits $this) {
        return new WireFormat<Object>($this){

            public void toWire(double x2, DataOutput out) {
                out.writeDouble(x2);
            }

            public double fromWire(DataInput in) {
                return in.readDouble();
            }
        };
    }

    public static WireFormat FloatFmt(WireFormatImplicits $this) {
        return new WireFormat<Object>($this){

            public void toWire(float x2, DataOutput out) {
                out.writeFloat(x2);
            }

            public float fromWire(DataInput in) {
                return in.readFloat();
            }
        };
    }

    public static WireFormat CharFmt(WireFormatImplicits $this) {
        return new WireFormat<Object>($this){

            public void toWire(char x2, DataOutput out) {
                out.writeChar(x2);
            }

            public char fromWire(DataInput in) {
                return in.readChar();
            }
        };
    }

    public static WireFormat ByteFmt(WireFormatImplicits $this) {
        return new WireFormat<Object>($this){

            public void toWire(byte x2, DataOutput out) {
                out.writeByte(x2);
            }

            public byte fromWire(DataInput in) {
                return in.readByte();
            }
        };
    }

    public static WireFormat StringFmt(WireFormatImplicits $this) {
        return new WireFormat<String>($this){

            public void toWire(String x2, DataOutput out) {
                if (x2 == null) {
                    out.writeInt(-1);
                } else {
                    byte[] b = x2.getBytes("utf-8");
                    out.writeInt(b.length);
                    out.write(b);
                }
            }

            public String fromWire(DataInput in) {
                String string;
                int l = in.readInt();
                if (l == -1) {
                    string = null;
                } else {
                    byte[] b = new byte[l];
                    in.readFully(b, 0, l);
                    string = new String(b, "utf-8");
                }
                return string;
            }
        };
    }

    public static WireFormat TraversableFmt(WireFormatImplicits $this, WireFormat wt, CanBuildFrom bf) {
        return new WireFormatImplicits.TraversableWireFormat($this, bf.apply(), wt);
    }

    public static WireFormat MapFmt(WireFormatImplicits $this, WireFormat wtK, WireFormat wtV, CanBuildFrom bf) {
        return new WireFormatImplicits.TraversableWireFormat($this, bf.apply(), $this.Tuple2Fmt(wtK, wtV));
    }

    public static WireFormat ArrayFmt(WireFormatImplicits $this, Manifest m$1, WireFormat wt) {
        return WireFormat$.MODULE$.wireFormat(new WireFormatImplicits.TraversableWireFormat($this, new ListBuffer(), wt)).adapt(new scala.Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<T> apply(Object a) {
                return Predef$.MODULE$.genericArrayOps(a).toList();
            }
        }, new scala.Serializable($this, m$1){
            public static final long serialVersionUID;
            private final Manifest m$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(List<T> s) {
                return s.toArray((ClassManifest)this.m$1);
            }
            {
                this.m$1 = manifest;
            }
        });
    }

    public static WireFormat OptionFmt(WireFormatImplicits $this, WireFormat wt$1) {
        return new WireFormat<Option<T>>($this, wt$1){
            private final WireFormat wt$1;

            public void toWire(Option<T> x2, DataOutput out) {
                Option<T> option;
                block4: {
                    block3: {
                        block2: {
                            option = x2;
                            if (!(option instanceof Some)) break block2;
                            out.writeBoolean(true);
                            this.wt$1.toWire(((Some)option).x(), out);
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<T> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        out.writeBoolean(false);
                    }
                    return;
                }
                throw new MatchError(option);
            }

            public Option<T> fromWire(DataInput in) {
                None$ none$;
                boolean isSome = in.readBoolean();
                if (isSome) {
                    A x2 = this.wt$1.fromWire(in);
                    none$ = new Some(x2);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
            {
                this.wt$1 = wireFormat;
            }
        };
    }

    public static WireFormatImplicits.EitherWireFormat EitherFmt(WireFormatImplicits $this, WireFormat wt1, WireFormat wt2) {
        return new WireFormatImplicits.EitherWireFormat($this, wt1, wt2);
    }

    public static WireFormat LeftFmt(WireFormatImplicits $this, WireFormat wt1$2) {
        return new WireFormat<Left<T1, T2>>($this, wt1$2){
            private final WireFormat wt1$2;

            public void toWire(Left<T1, T2> x2, DataOutput out) {
                this.wt1$2.toWire(x2.a(), out);
            }

            public Left<T1, T2> fromWire(DataInput in) {
                return new Left(this.wt1$2.fromWire(in));
            }
            {
                this.wt1$2 = wireFormat;
            }
        };
    }

    public static WireFormat RightFmt(WireFormatImplicits $this, WireFormat wt1$1) {
        return new WireFormat<Right<T1, T2>>($this, wt1$1){
            private final WireFormat wt1$1;

            public void toWire(Right<T1, T2> x2, DataOutput out) {
                this.wt1$1.toWire(x2.b(), out);
            }

            public Right<T1, T2> fromWire(DataInput in) {
                return new Right(this.wt1$1.fromWire(in));
            }
            {
                this.wt1$1 = wireFormat;
            }
        };
    }

    public static WireFormat DateFmt(WireFormatImplicits $this) {
        return new WireFormat<Date>($this){

            public void toWire(Date x2, DataOutput out) {
                out.writeLong(x2.getTime());
            }

            public Date fromWire(DataInput in) {
                return new Date(in.readLong());
            }
        };
    }

    public static WireFormat taggedTypeWireFormat(WireFormatImplicits $this, WireFormat evidence$9) {
        return (WireFormat)Predef$.MODULE$.implicitly((Object)evidence$9);
    }

    public static void $init$(WireFormatImplicits $this) {
    }
}

