/*
 * Decompiled with CFR 0.152.
 */
package com.nicta.scoobi.io;

import com.nicta.scoobi.application.ScoobiConfiguration;
import com.nicta.scoobi.application.ScoobiConfiguration$;
import com.nicta.scoobi.impl.monitor.Loggable$;
import com.nicta.scoobi.io.FileSystems;
import com.nicta.scoobi.io.FileSystems$;
import java.io.File;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public abstract class FileSystems$class {
    public static Seq uploadNewJars(FileSystems $this, Seq sourceFiles, String dest, ScoobiConfiguration configuration$1) {
        DistributedCache.createSymlink((Configuration)ScoobiConfiguration$.MODULE$.toConfiguration(configuration$1));
        return $this.uploadNewFiles((Seq<File>)sourceFiles, dest, (Function1<Path, Path>)new Serializable($this, configuration$1){
            public static final long serialVersionUID;
            private final ScoobiConfiguration configuration$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Path apply(Path path) {
                DistributedCache.addFileToClassPath((Path)path, (Configuration)ScoobiConfiguration$.MODULE$.toConfiguration(this.configuration$1));
                return path;
            }
            {
                this.configuration$1 = scoobiConfiguration;
            }
        }, configuration$1);
    }

    public static Seq uploadNewFiles(FileSystems $this, Seq sourceFiles, String dest$1, Function1 onRemoteFiles, ScoobiConfiguration configuration$2) {
        Seq<Path> uploaded = $this.listPaths(dest$1, configuration$2);
        Seq newFiles = (Seq)((TraversableLike)sourceFiles.filter((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file) {
                return file.exists();
            }
        })).filterNot($this.isOldFile(uploaded, configuration$2));
        Loggable$.MODULE$.asLoggable(new Serializable($this){
            public static final long serialVersionUID;
            private final FileSystems $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Log apply() {
                return this.$outer.com$nicta$scoobi$io$FileSystems$$logger();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, $this.com$nicta$scoobi$io$FileSystems$$logger()).debugNot(newFiles.isEmpty(), new StringBuilder().append((Object)"uploading files\n").append((Object)newFiles.mkString("\n")).toString());
        newFiles.map((Function1)new Serializable($this, dest$1, configuration$2){
            public static final long serialVersionUID;
            private final FileSystems $outer;
            private final String dest$1;
            private final ScoobiConfiguration configuration$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File file) {
                this.$outer.fileSystem(this.configuration$2).copyFromLocalFile(new Path(file.getPath()), new Path(this.dest$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dest$1 = string;
                this.configuration$2 = scoobiConfiguration;
            }
        }, Seq$.MODULE$.canBuildFrom());
        uploaded.foreach(onRemoteFiles);
        return sourceFiles;
    }

    public static Function1 uploadNewFiles$default$3(FileSystems $this, Seq sourceFiles, String dest) {
        return new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Path apply(Path path) {
                return (Path)Predef$.MODULE$.identity((Object)path);
            }
        };
    }

    public static Function1 isOldFile(FileSystems $this, Seq existingFiles$1, ScoobiConfiguration configuration$3) {
        return new Serializable($this, existingFiles$1, configuration$3){
            public static final long serialVersionUID;
            private final FileSystems $outer;
            private final Seq existingFiles$1;
            public final ScoobiConfiguration configuration$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file$1) {
                return Loggable$.MODULE$.asBooleanLoggable(this.existingFiles$1.exists((Function1)new Serializable(this, file$1){
                    public static final long serialVersionUID;
                    private final FileSystems$.anonfun.isOldFile.1 $outer;
                    private final File file$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Path path) {
                        return path.getName().contains(this.file$1.getName()) && this.$outer.com$nicta$scoobi$io$FileSystems$$anonfun$$$outer().fileStatus(path, this.$outer.configuration$3).getLen() == this.file$1.length();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.file$1 = file;
                    }
                }), this.$outer.com$nicta$scoobi$io$FileSystems$$logger()).debugNot(new StringBuilder().append((Object)"the file ").append((Object)file$1.getName()).append((Object)" was not found on the cluster or has changed").toString());
            }

            public FileSystems com$nicta$scoobi$io$FileSystems$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.existingFiles$1 = seq;
                this.configuration$3 = scoobiConfiguration;
            }
        };
    }

    public static Seq listFiles(FileSystems $this, String path) {
        return (Seq)Option$.MODULE$.apply((Object)new File(path).listFiles()).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<File> apply(File[] fileArray) {
                return Predef$.MODULE$.refArrayOps((Object[])fileArray).toSeq();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
    }

    public static Seq listFilePaths(FileSystems $this, String path) {
        return (Seq)$this.listFiles(path).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(File file) {
                return file.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq listPaths(FileSystems $this, String dest, ScoobiConfiguration configuration2) {
        return $this.listPaths(new Path(dest), configuration2);
    }

    public static Seq listPaths(FileSystems $this, Path dest, ScoobiConfiguration configuration2) {
        return $this.fileSystem(configuration2).exists(dest) ? (Seq)Predef$.MODULE$.refArrayOps((Object[])$this.fileSystem(configuration2).listStatus(dest)).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Path apply(FileStatus fileStatus) {
                return fileStatus.getPath();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())) : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public static void mkdir(FileSystems $this, String dest, ScoobiConfiguration configuration2) {
        if (!$this.exists(dest, configuration2)) {
            $this.fileSystem(configuration2).mkdirs(new Path(dest));
        }
    }

    public static boolean exists(FileSystems $this, String path, ScoobiConfiguration configuration2) {
        return $this.fileSystem(configuration2).exists(new Path(path));
    }

    public static void deleteFiles(FileSystems $this, String dest, ScoobiConfiguration configuration2) {
        Path destPath = new Path(dest);
        if ($this.fileSystem(configuration2).exists(destPath)) {
            $this.fileSystem(configuration2).delete(destPath, true);
        }
    }

    public static FileSystem fileSystem(FileSystems $this, ScoobiConfiguration configuration2) {
        return FileSystem.get((Configuration)ScoobiConfiguration$.MODULE$.toConfiguration(configuration2));
    }

    public static boolean isLocal(FileSystems $this, ScoobiConfiguration configuration2) {
        return $this.fileSystem(configuration2) instanceof LocalFileSystem;
    }

    public static Function1 moveTo(FileSystems $this, String dir, ScoobiConfiguration sc) {
        return $this.moveTo(new Path(dir), sc);
    }

    public static Function1 moveTo(FileSystems $this, Path dir$1, ScoobiConfiguration sc$1) {
        return new Serializable($this, dir$1, sc$1){
            public static final long serialVersionUID;
            private final FileSystems $outer;
            private final Path dir$1;
            private final ScoobiConfiguration sc$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Path f) {
                FileSystem to;
                FileSystem from;
                return !this.$outer.fileSystem(this.sc$1).exists(f) || (this.$outer.sameFileSystem(from = this.$outer.fileSystem(this.sc$1), to = FileSystem.get((URI)this.dir$1.toUri(), (Configuration)this.sc$1.configuration())) ? this.$outer.fileSystem(this.sc$1).rename(f, new Path(this.dir$1, f.getName())) : FileUtil.copy((FileSystem)from, (Path)f, (FileSystem)to, (Path)new Path(this.dir$1, f.getName()), (boolean)true, (boolean)false, (Configuration)this.sc$1.configuration()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dir$1 = path;
                this.sc$1 = scoobiConfiguration;
            }
        };
    }

    public static Function1 copyTo(FileSystems $this, String dir, ScoobiConfiguration sc) {
        return $this.copyTo(new Path(dir), sc);
    }

    public static Function1 copyTo(FileSystems $this, Path dir$2, ScoobiConfiguration sc$2) {
        return new Serializable($this, dir$2, sc$2){
            public static final long serialVersionUID;
            private final FileSystems $outer;
            private final Path dir$2;
            private final ScoobiConfiguration sc$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Path f) {
                return FileUtil.copy((FileSystem)this.$outer.fileSystem(this.sc$2), (Path)f, (FileSystem)this.$outer.fileSystem(this.sc$2), (Path)this.dir$2, (boolean)false, (Configuration)ScoobiConfiguration$.MODULE$.toConfiguration(this.sc$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dir$2 = path;
                this.sc$2 = scoobiConfiguration;
            }
        };
    }

    public static String dirPath(FileSystems $this, String s) {
        return s.endsWith("/") ? s : new StringBuilder().append((Object)s).append((Object)"/").toString();
    }

    public static FileStatus fileStatus(FileSystems $this, Path path, ScoobiConfiguration sc) {
        return $this.fileSystem(sc).getFileStatus(path);
    }

    public static boolean sameFileSystem(FileSystems $this, FileSystem from, FileSystem to) {
        return $this.sameFileSystem(from.getUri(), to.getUri());
    }

    public static boolean sameFileSystem(FileSystems $this, URI from, URI to) {
        return FileSystems$class.equalIgnoreCase$1($this, from.getHost(), to.getHost()) && FileSystems$class.equalIgnoreCase$1($this, from.getScheme(), to.getScheme());
    }

    private static final boolean equalIgnoreCase$1(FileSystems $this, String from, String to) {
        return from == null && to == null || from.equalsIgnoreCase(to);
    }

    public static void $init$(FileSystems $this) {
        $this.com$nicta$scoobi$io$FileSystems$_setter_$com$nicta$scoobi$io$FileSystems$$logger_$eq(LogFactory.getLog((String)"scoobi.FileSystems"));
    }
}

