/*
 * Decompiled with CFR 0.152.
 */
package com.nicta.scoobi.io.avro;

import com.nicta.scoobi.application.ScoobiConfiguration;
import com.nicta.scoobi.application.ScoobiConfiguration$;
import com.nicta.scoobi.core.DList;
import com.nicta.scoobi.core.DList$;
import com.nicta.scoobi.core.WireFormat;
import com.nicta.scoobi.io.DataSource;
import com.nicta.scoobi.io.Helper$;
import com.nicta.scoobi.io.InputConverter;
import com.nicta.scoobi.io.avro.AvroInput$;
import com.nicta.scoobi.io.avro.AvroInput$$anon$2$;
import com.nicta.scoobi.io.avro.AvroParsingImplicits;
import com.nicta.scoobi.io.avro.AvroParsingImplicits$class;
import com.nicta.scoobi.io.avro.AvroSchema;
import com.nicta.scoobi.io.avro.EnhancedSymbol;
import java.io.IOException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.io.parsing.Symbol;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.Manifest;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AvroInput$
implements AvroParsingImplicits {
    public static final AvroInput$ MODULE$;
    private Log logger;
    public volatile int bitmap$0;

    static {
        new AvroInput$();
    }

    @Override
    public EnhancedSymbol pimpSymbol(Symbol sym) {
        return AvroParsingImplicits$class.pimpSymbol(this, sym);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Log logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        AvroInput$ avroInput$ = this;
        synchronized (avroInput$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = LogFactory.getLog((String)"scoobi.AvroInput");
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public <A> DList<A> fromAvroFile(Seq<String> paths, Manifest<A> evidence$1, WireFormat<A> evidence$2, AvroSchema<A> evidence$3) {
        return this.fromAvroFile((List<String>)List$.MODULE$.apply(paths), this.fromAvroFile$default$2(), evidence$1, evidence$2, evidence$3);
    }

    public <A> DList<A> fromAvroFile(List<String> paths$1, boolean checkSchemas$1, Manifest<A> evidence$4, WireFormat<A> evidence$5, AvroSchema<A> evidence$6) {
        AvroSchema sch$1 = (AvroSchema)Predef$.MODULE$.implicitly(evidence$6);
        InputConverter converter$1 = new InputConverter<AvroKey<Object>, NullWritable, A>(sch$1){
            private final AvroSchema sch$1;

            public A fromKeyValue(MapContext<AvroKey<Object>, NullWritable, ?, ?> context, AvroKey<Object> k, NullWritable v) {
                return this.sch$1.fromAvro(k.datum());
            }
            {
                this.sch$1 = avroSchema;
            }
        };
        DataSource source = new DataSource<AvroKey<Object>, NullWritable, A>(paths$1, checkSchemas$1, sch$1, converter$1){
            private final List<Path> inputPaths;
            private final Class<AvroKeyInputFormat<Object>> inputFormat;
            private InputConverter inputConverter;
            public final boolean checkSchemas$1;
            public final AvroSchema sch$1;
            private final InputConverter converter$1;
            public volatile int bitmap$0;

            private List<Path> inputPaths() {
                return this.inputPaths;
            }

            public Class<AvroKeyInputFormat<Object>> inputFormat() {
                return this.inputFormat;
            }

            public void inputCheck(ScoobiConfiguration sc$1) {
                this.inputPaths().foreach((Function1)new Serializable(this, sc$1){
                    public static final long serialVersionUID;
                    private final anon.2 $outer;
                    public final ScoobiConfiguration sc$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Path p) {
                        Seq<FileStatus> fileStats = Helper$.MODULE$.getFileStatus(p, Helper$.MODULE$.getFileStatus$default$2(), ScoobiConfiguration$.MODULE$.toConfiguration(this.sc$1));
                        if (fileStats.size() > 0) {
                            AvroInput$.MODULE$.logger().info((Object)new StringBuilder().append((Object)"Input path: ").append((Object)p.toUri().toASCIIString()).append((Object)" (").append((Object)Helper$.MODULE$.sizeString(Helper$.MODULE$.pathSize(p, ScoobiConfiguration$.MODULE$.toConfiguration(this.sc$1)))).append((Object)")").toString());
                            AvroInput$.MODULE$.logger().debug((Object)new StringBuilder().append((Object)"Input schema: ").append((Object)this.$outer.sch$1.schema()).toString());
                            if (this.$outer.checkSchemas$1) {
                                Helper$.MODULE$.getSingleFilePerDir(fileStats, ScoobiConfiguration$.MODULE$.toConfiguration(this.sc$1)).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID;
                                    private final anon$2$$anonfun$inputCheck$1 $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final void apply(Path filePath) {
                                        FsInput avroFile = new FsInput(filePath, ScoobiConfiguration$.MODULE$.toConfiguration(this.$outer.sc$1));
                                        try {
                                            Schema writerSchema = DataFileReader.openReader((SeekableInput)avroFile, (DatumReader)new GenericDatumReader()).getSchema();
                                            Schema readerSchema = this.$outer.com$nicta$scoobi$io$avro$AvroInput$$anon$$anonfun$$$outer().sch$1.schema();
                                            Object object = ResolvingDecoder.resolve((Schema)writerSchema, (Schema)readerSchema);
                                            if (object instanceof Symbol) {
                                                Symbol symbol = (Symbol)object;
                                                String errors = ((TraversableOnce)AvroInput$.MODULE$.pimpSymbol(symbol).getErrors().map((Function1)new Serializable(this){
                                                    public static final long serialVersionUID;

                                                    static {
                                                        long l = serialVersionUID = 0L;
                                                    }

                                                    public final String apply(Symbol.ErrorAction errorAction) {
                                                        return errorAction.msg;
                                                    }
                                                }, List$.MODULE$.canBuildFrom())).mkString("", "\n", "");
                                                if (errors.length() > 0) {
                                                    throw new AvroTypeException(new StringBuilder().append((Object)"Incompatible reader and writer schemas. Reader schema '").append((Object)readerSchema).append((Object)"'. Writer schema '").append((Object)writerSchema).append((Object)"'. Errors:\n").append((Object)errors).toString());
                                                }
                                                return;
                                            }
                                            throw new ClassCastException("Avro ResolvingDecoder api has changed. Expecting a Symbol class to be returned from ResolvingDecoder.resolve(writerSchema, readerSchema)");
                                        }
                                        finally {
                                            avroFile.close();
                                        }
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            return;
                        }
                        throw new IOException(new StringBuilder().append((Object)"Input path ").append((Object)p).append((Object)" does not exist.").toString());
                    }

                    public anon.2 com$nicta$scoobi$io$avro$AvroInput$$anon$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.sc$1 = scoobiConfiguration;
                    }
                });
            }

            public void inputConfigure(Job job$1, ScoobiConfiguration sc) {
                this.inputPaths().foreach((Function1)new Serializable(this, job$1){
                    public static final long serialVersionUID;
                    private final Job job$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Path p) {
                        FileInputFormat.addInputPath((Job)this.job$1, (Path)p);
                    }
                    {
                        this.job$1 = job;
                    }
                });
                job$1.getConfiguration().set("avro.schema.input.key", this.sch$1.schema().toString());
            }

            public long inputSize(ScoobiConfiguration sc$2) {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.inputPaths().map((Function1)new Serializable(this, sc$2){
                    public static final long serialVersionUID;
                    private final ScoobiConfiguration sc$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final long apply(Path p) {
                        return Helper$.MODULE$.pathSize(p, ScoobiConfiguration$.MODULE$.toConfiguration(this.sc$2));
                    }
                    {
                        this.sc$2 = scoobiConfiguration;
                    }
                }, List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public InputConverter inputConverter() {
                if ((this.bitmap$0 & 1) == 0) {
                    anon.2 var1_1 = this;
                    synchronized (var1_1) {
                        if ((this.bitmap$0 & 1) == 0) {
                            this.inputConverter = this.converter$1;
                            this.bitmap$0 |= 1;
                        }
                    }
                    this.converter$1 = null;
                }
                return this.inputConverter;
            }
            {
                this.checkSchemas$1 = bl;
                this.sch$1 = avroSchema;
                this.converter$1 = inputConverter;
                this.inputPaths = (List)list.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Path apply(String p) {
                        return new Path(p);
                    }
                }, List$.MODULE$.canBuildFrom());
                this.inputFormat = AvroKeyInputFormat.class;
            }
        };
        return DList$.MODULE$.fromSource(source, evidence$4, evidence$5);
    }

    public boolean fromAvroFile$default$2() {
        return true;
    }

    private AvroInput$() {
        MODULE$ = this;
        AvroParsingImplicits$class.$init$(this);
    }
}

