/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.stresstest;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.graph.stresstest.OBaseGraphWorkload;
import com.orientechnologies.orient.stresstest.ODatabaseIdentifier;
import com.orientechnologies.orient.stresstest.OStressTesterSettings;
import com.orientechnologies.orient.stresstest.workload.OBaseWorkload;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.List;
import java.util.Random;

public class OGraphInsertWorkload
extends OBaseGraphWorkload {
    static final String INVALID_FORM_MESSAGE = "GRAPH INSERT workload must be in form of <vertices>F<connection-factor>.";
    private int factor = 80;
    private OBaseWorkload.OWorkLoadResult resultVertices = new OBaseWorkload.OWorkLoadResult((OBaseWorkload)this);
    private OBaseWorkload.OWorkLoadResult resultEdges = new OBaseWorkload.OWorkLoadResult((OBaseWorkload)this);
    private STRATEGIES strategy = STRATEGIES.LAST;

    public OGraphInsertWorkload() {
        this.connectionStrategy = OStorageRemote.CONNECTION_STRATEGY.ROUND_ROBIN_REQUEST;
    }

    public String getName() {
        return "GINSERT";
    }

    public void parseParameters(String args) {
        String ops = args.toUpperCase();
        char state = ' ';
        StringBuilder value = new StringBuilder();
        boolean strategy = false;
        for (int pos = 0; pos < ops.length(); ++pos) {
            char c = ops.charAt(pos);
            if (c == ' ' || c == 'V' || c == 'F' || c == 'S' && !strategy) {
                if (c == 'S') {
                    strategy = true;
                }
                state = this.assignState(state, value, c);
                continue;
            }
            value.append(c);
        }
        this.assignState(state, value, ' ');
        if (this.resultVertices.total == 0) {
            throw new IllegalArgumentException(INVALID_FORM_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OStressTesterSettings settings, ODatabaseIdentifier databaseIdentifier) {
        this.connectionStrategy = settings.loadBalancing;
        List contexts = this.executeOperation(databaseIdentifier, this.resultVertices, settings.concurrencyLevel, settings.operationsPerTransaction, (OCallable)new OCallable<Void, OBaseWorkload.OBaseWorkLoadContext>(){

            public Void call(OBaseWorkload.OBaseWorkLoadContext context) {
                OBaseGraphWorkload.OWorkLoadContext graphContext = (OBaseGraphWorkload.OWorkLoadContext)context;
                OrientBaseGraph graph = graphContext.graph;
                OrientVertex v = graph.addVertex(null, "_id", ((OGraphInsertWorkload)OGraphInsertWorkload.this).resultVertices.current.get());
                if (graphContext.lastVertexToConnect != null) {
                    v.addEdge("E", graphContext.lastVertexToConnect);
                    ((OGraphInsertWorkload)OGraphInsertWorkload.this).resultEdges.current.incrementAndGet();
                    ++graphContext.lastVertexEdges;
                    if (graphContext.lastVertexEdges > OGraphInsertWorkload.this.factor) {
                        graphContext.lastVertexEdges = 0;
                        if (OGraphInsertWorkload.this.strategy == STRATEGIES.LAST) {
                            graphContext.lastVertexToConnect = v;
                        } else if (OGraphInsertWorkload.this.strategy == STRATEGIES.RANDOM) {
                            int randomCluster;
                            long totClusterRecords;
                            do {
                                int[] totalClusters = graph.getVertexBaseType().getClusterIds();
                                randomCluster = totalClusters[new Random().nextInt(totalClusters.length)];
                            } while ((totClusterRecords = graph.getRawGraph().countClusterElements(randomCluster)) <= 0L);
                            ORecordId randomRid = new ORecordId(randomCluster, (long)new Random().nextInt((int)totClusterRecords));
                            graphContext.lastVertexToConnect = graph.getVertex(randomRid);
                        } else if (OGraphInsertWorkload.this.strategy == STRATEGIES.SUPERNODE) {
                            int[] totalClusters = graph.getVertexBaseType().getClusterIds();
                            int firstCluster = totalClusters[0];
                            long totClusterRecords = graph.getRawGraph().countClusterElements(firstCluster);
                            if (totClusterRecords > 0L) {
                                ORecordId randomRid = new ORecordId(firstCluster, 0L);
                                graphContext.lastVertexToConnect = graph.getVertex(randomRid);
                            }
                        }
                    }
                } else {
                    graphContext.lastVertexToConnect = v;
                }
                ((OGraphInsertWorkload)OGraphInsertWorkload.this).resultVertices.current.incrementAndGet();
                return null;
            }
        });
        OrientBaseGraph graph = settings.operationsPerTransaction > 0 ? this.getGraph(databaseIdentifier) : this.getGraphNoTx(databaseIdentifier);
        try {
            OrientElement lastVertex = null;
            for (OBaseWorkload.OBaseWorkLoadContext context : contexts) {
                for (int retry = 0; retry < 100; ++retry) {
                    try {
                        if (lastVertex != null) {
                            ((OrientVertex)lastVertex).addEdge("E", ((OBaseGraphWorkload.OWorkLoadContext)context).lastVertexToConnect);
                        }
                        lastVertex = ((OBaseGraphWorkload.OWorkLoadContext)context).lastVertexToConnect;
                        continue;
                    }
                    catch (ONeedRetryException e) {
                        if (lastVertex.getIdentity().isPersistent()) {
                            lastVertex.reload();
                        }
                        if (!((OBaseGraphWorkload.OWorkLoadContext)context).lastVertexToConnect.getIdentity().isPersistent()) continue;
                        ((OBaseGraphWorkload.OWorkLoadContext)context).lastVertexToConnect.reload();
                    }
                }
            }
        }
        finally {
            graph.shutdown();
        }
    }

    protected void manageNeedRetryException(OBaseWorkload.OBaseWorkLoadContext context, ONeedRetryException e) {
        if (((OBaseGraphWorkload.OWorkLoadContext)context).lastVertexToConnect.getIdentity().isPersistent()) {
            ((OBaseGraphWorkload.OWorkLoadContext)context).lastVertexToConnect.reload();
        }
    }

    public String getPartialResult() {
        return String.format("%d%% [Vertices: %d - Edges: %d (conflicts=%d)]", 100 * this.resultVertices.current.get() / this.resultVertices.total, this.resultVertices.current.get(), this.resultEdges.current.get(), this.resultVertices.conflicts.get());
    }

    public String getFinalResult() {
        StringBuilder buffer = new StringBuilder(this.getErrors());
        buffer.append(String.format("- Created %d vertices and %d edges in %.3f secs", this.resultVertices.current.get(), this.resultEdges.current.get(), Float.valueOf((float)this.resultVertices.totalTime / 1000.0f)));
        buffer.append(this.resultVertices.toOutput(1));
        return buffer.toString();
    }

    public String getFinalResultAsJson() {
        ODocument json = new ODocument();
        json.field("type", (Object)this.getName());
        json.field("vertices", (Object)this.resultVertices.toJSON(), new OType[]{OType.EMBEDDED});
        json.field("edges", (Object)this.resultEdges.toJSON(), new OType[]{OType.EMBEDDED});
        return json.toJSON("");
    }

    private char assignState(char state, StringBuilder number, char c) {
        if (number.length() == 0) {
            number.append("0");
        }
        if (state == 'V') {
            this.resultVertices.total = Integer.parseInt(number.toString());
        } else if (state == 'F') {
            this.factor = Integer.parseInt(number.toString());
        } else if (state == 'S') {
            this.strategy = STRATEGIES.valueOf(number.toString().toUpperCase());
        }
        number.setLength(0);
        return c;
    }

    @Override
    protected OBaseWorkload.OBaseWorkLoadContext getContext() {
        return new OBaseGraphWorkload.OWorkLoadContext(this);
    }

    public int getVertices() {
        return this.resultVertices.total;
    }

    public int getFactor() {
        return this.factor;
    }

    private static enum STRATEGIES {
        LAST,
        RANDOM,
        SUPERNODE;

    }
}

