/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.server.command;

import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;

public class OServerCommandGetGephi
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|gephi/*"};

    public OServerCommandGetGephi() {
    }

    public OServerCommandGetGephi(OServerCommandConfiguration iConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: gephi/<database>/<language>/<query-text>[/<limit>][/<fetchPlan>].<br>Limit is optional and is setted to 20 by default. Set expressely to 0 to have no limits.");
        String language = urlParts[2];
        String text = urlParts[3];
        int limit = urlParts.length > 4 ? Integer.parseInt(urlParts[4]) : 20;
        String fetchPlan = urlParts.length > 5 ? urlParts[5] : null;
        iRequest.data.commandInfo = "Gephi";
        iRequest.data.commandDetail = text;
        ODatabaseDocumentInternal db = this.getProfiledDatabaseInstance(iRequest);
        OModifiableBoolean shutdownFlag = new OModifiableBoolean();
        OrientBaseGraph graph = OGraphCommandExecutorSQLFactory.getAnyGraph(shutdownFlag);
        try {
            ArrayList<OrientVertex> vertices;
            if (language.equals("sql")) {
                vertices = (ArrayList<OrientVertex>)graph.command((OCommandRequest)new OSQLSynchQuery(text, limit).setFetchPlan(fetchPlan)).execute(new Object[0]);
            } else if (language.equals("gremlin")) {
                ArrayList<Object> result = new ArrayList<Object>();
                OGremlinHelper.execute(graph, text, null, null, result, null, null);
                vertices = new ArrayList<OrientVertex>(result.size());
                for (Object e : result) {
                    vertices.add(graph.getVertex(e));
                }
            } else {
                throw new IllegalArgumentException("Language '" + language + "' is not supported. Use 'sql' or 'gremlin'");
            }
            this.sendRecordsContent(iRequest, iResponse, (Iterable<OrientElement>)vertices, fetchPlan);
        }
        finally {
            if (graph != null && shutdownFlag.getValue()) {
                graph.shutdown(false, false);
            }
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    protected void sendRecordsContent(OHttpRequest iRequest, OHttpResponse iResponse, Iterable<OrientElement> iRecords, String iFetchPlan) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer, "type,indent:-1,rid,version,attribSameRow,class,keepTypes,alwaysFetchEmbeddedDocuments");
        json.setPrettyPrint(true);
        this.generateGraphDbOutput(iRecords, json);
        iResponse.send(200, "OK", "application/json", (Object)buffer.toString(), null);
    }

    protected void generateGraphDbOutput(Iterable<OrientElement> iVertices, OJSONWriter json) throws IOException {
        if (iVertices == null) {
            return;
        }
        HashSet<OrientVertex> vertexes = new HashSet<OrientVertex>();
        HashSet<OrientEdge> edges = new HashSet<OrientEdge>();
        for (OrientElement id : iVertices) {
            if (id instanceof OrientVertex) {
                vertexes.add((OrientVertex)id);
                continue;
            }
            edges.add((OrientEdge)id);
        }
        for (OrientVertex vertex : vertexes) {
            json.resetAttributes();
            json.beginObject(0, false, null);
            json.beginObject(1, false, (Object)"an");
            json.beginObject(2, false, (Object)vertex.getIdentity());
            for (Edge e : vertex.getEdges(Direction.BOTH, new String[0])) {
                edges.add((OrientEdge)e);
            }
            for (String field : vertex.getPropertyKeys()) {
                Object v = vertex.getProperty(field);
                if (v == null) continue;
                json.writeAttribute(3, false, field, v);
            }
            json.endObject(2, false);
            json.endObject(1, false);
            json.endObject(0, false);
            json.newline();
        }
        for (OrientEdge edge : edges) {
            ORID sourceVertex = (ORID)edge.getVertex(Direction.OUT).getId();
            ORID targetVertex = (ORID)edge.getVertex(Direction.IN).getId();
            if (!vertexes.contains(sourceVertex) || !vertexes.contains(targetVertex)) continue;
            json.resetAttributes();
            json.beginObject();
            json.beginObject(1, false, (Object)"ae");
            json.beginObject(2, false, edge.getId());
            json.writeAttribute(3, false, "directed", (Object)false);
            json.writeAttribute(3, false, "source", (Object)sourceVertex);
            json.writeAttribute(3, false, "target", (Object)targetVertex);
            for (String field : edge.getPropertyKeys()) {
                Object v = edge.getProperty(field);
                if (v == null) continue;
                json.writeAttribute(3, false, field, v);
            }
            json.endObject(2, false);
            json.endObject(1, false);
            json.endObject(0, false);
            json.newline();
        }
    }

    public String[] getNames() {
        return NAMES;
    }
}

