/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.orientechnologies.orient.graph.sql.functions.HeuristicFormula;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionHeuristicPathFinderAbstract;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class OSQLFunctionAstar
extends OSQLFunctionHeuristicPathFinderAbstract {
    public static final String NAME = "astar";
    private String paramWeightFieldName = "weight";
    private long currentDepth = 0L;
    protected Set<OrientVertex> closedSet = new HashSet<OrientVertex>();
    protected Map<OrientVertex, OrientVertex> cameFrom = new HashMap<OrientVertex, OrientVertex>();
    protected Map<OrientVertex, Double> gScore = new HashMap<OrientVertex, Double>();
    protected Map<OrientVertex, Double> fScore = new HashMap<OrientVertex, Double>();
    protected PriorityQueue<OrientVertex> open = new PriorityQueue<OrientVertex>(1, new Comparator<OrientVertex>(){

        @Override
        public int compare(OrientVertex nodeA, OrientVertex nodeB) {
            return Double.compare(OSQLFunctionAstar.this.fScore.get(nodeA), OSQLFunctionAstar.this.fScore.get(nodeB));
        }
    });

    public OSQLFunctionAstar() {
        super(NAME, 3, 4);
    }

    public LinkedList<OrientVertex> execute(Object iThis, final OIdentifiable iCurrentRecord, Object iCurrentResult, final Object[] iParams, final OCommandContext iContext) {
        this.context = iContext;
        final OSQLFunctionAstar context = this;
        return OGraphCommandExecutorSQLFactory.runWithAnyGraph(new OGraphCommandExecutorSQLFactory.GraphCallBack<LinkedList<OrientVertex>>(){

            @Override
            public LinkedList<OrientVertex> call(OrientBaseGraph graph) {
                ORecord record = iCurrentRecord != null ? iCurrentRecord.getRecord() : null;
                Object source = iParams[0];
                if (OMultiValue.isMultiValue((Object)source)) {
                    if (OMultiValue.getSize((Object)source) > 1) {
                        throw new IllegalArgumentException("Only one sourceVertex is allowed");
                    }
                    source = OMultiValue.getFirstValue((Object)source);
                }
                OSQLFunctionAstar.this.paramSourceVertex = graph.getVertex(OSQLHelper.getValue((Object)source, (ORecord)record, (OCommandContext)iContext));
                Object dest = iParams[1];
                if (OMultiValue.isMultiValue((Object)dest)) {
                    if (OMultiValue.getSize((Object)dest) > 1) {
                        throw new IllegalArgumentException("Only one destinationVertex is allowed");
                    }
                    dest = OMultiValue.getFirstValue((Object)dest);
                }
                OSQLFunctionAstar.this.paramDestinationVertex = graph.getVertex(OSQLHelper.getValue((Object)dest, (ORecord)record, (OCommandContext)iContext));
                OSQLFunctionAstar.this.paramWeightFieldName = OIOUtils.getStringContent((Object)iParams[2]);
                if (iParams.length > 3) {
                    OSQLFunctionAstar.this.bindAdditionalParams(iParams[3], context);
                }
                iContext.setVariable("getNeighbors", (Object)0);
                return OSQLFunctionAstar.this.internalExecute(iContext, graph);
            }
        });
    }

    private LinkedList<OrientVertex> internalExecute(OCommandContext iContext, OrientBaseGraph graph) {
        OrientVertex start = this.paramSourceVertex;
        OrientVertex goal = this.paramDestinationVertex;
        this.open.add(start);
        this.gScore.put(start, 0.0);
        this.fScore.put(start, this.getHeuristicCost(start, null, goal));
        while (!this.open.isEmpty()) {
            OrientVertex current = this.open.poll();
            if (this.paramEmptyIfMaxDepth.booleanValue() && this.currentDepth >= this.paramMaxDepth) {
                this.route.clear();
                return this.getPath();
            }
            if (current.getIdentity().equals(goal.getIdentity()) || this.currentDepth >= this.paramMaxDepth) {
                while (current != null) {
                    this.route.add(0, current);
                    current = this.cameFrom.get(current);
                }
                return this.getPath();
            }
            this.closedSet.add(current);
            for (OrientEdge neighborEdge : this.getNeighborEdges(current)) {
                OrientVertex neighbor = this.getNeighbor(current, neighborEdge, graph);
                if (this.closedSet.contains(neighbor)) continue;
                double tentative_gScore = this.gScore.get(current) + this.getDistance(neighborEdge);
                boolean contains = this.open.contains(neighbor);
                if (contains && !(tentative_gScore < this.gScore.get(neighbor))) continue;
                this.gScore.put(neighbor, tentative_gScore);
                this.fScore.put(neighbor, tentative_gScore + this.getHeuristicCost(neighbor, current, goal));
                if (contains) {
                    this.open.remove(neighbor);
                }
                this.open.offer(neighbor);
                this.cameFrom.put(neighbor, current);
            }
            ++this.currentDepth;
        }
        return this.getPath();
    }

    private OrientVertex getNeighbor(OrientVertex current, OrientEdge neighborEdge, OrientBaseGraph graph) {
        if (neighborEdge.getOutVertex().equals(current)) {
            return this.toVertex(neighborEdge.getInVertex(), graph);
        }
        return this.toVertex(neighborEdge.getOutVertex(), graph);
    }

    private OrientVertex toVertex(OIdentifiable outVertex, OrientBaseGraph graph) {
        if (outVertex == null) {
            return null;
        }
        if (outVertex instanceof OrientVertex) {
            return (OrientVertex)outVertex;
        }
        return graph.getVertex(outVertex);
    }

    protected Set<OrientEdge> getNeighborEdges(OrientVertex node) {
        this.context.incrementVariable("getNeighbors");
        HashSet<OrientEdge> neighbors = new HashSet<OrientEdge>();
        if (node != null) {
            for (Edge v : node.getEdges(this.paramDirection, this.paramEdgeTypeNames)) {
                OrientEdge ov = (OrientEdge)v;
                if (ov == null) continue;
                neighbors.add(ov);
            }
        }
        return neighbors;
    }

    private void bindAdditionalParams(Object additionalParams, OSQLFunctionAstar ctx) {
        if (additionalParams == null) {
            return;
        }
        Map mapParams = null;
        if (additionalParams instanceof Map) {
            mapParams = (Map)additionalParams;
        } else if (additionalParams instanceof OIdentifiable) {
            mapParams = ((ODocument)((OIdentifiable)additionalParams).getRecord()).toMap();
        }
        if (mapParams != null) {
            ctx.paramEdgeTypeNames = this.stringArray(mapParams.get("edgeTypeNames"));
            ctx.paramVertexAxisNames = this.stringArray(mapParams.get("vertexAxisNames"));
            if (mapParams.get("direction") != null) {
                ctx.paramDirection = mapParams.get("direction") instanceof String ? Direction.valueOf((String)this.stringOrDefault(mapParams.get("direction"), "OUT").toUpperCase(Locale.ENGLISH)) : (Direction)mapParams.get("direction");
            }
            ctx.paramParallel = this.booleanOrDefault(mapParams.get("parallel"), false);
            ctx.paramMaxDepth = this.longOrDefault(mapParams.get("maxDepth"), ctx.paramMaxDepth);
            ctx.paramEmptyIfMaxDepth = this.booleanOrDefault(mapParams.get("emptyIfMaxDepth"), ctx.paramEmptyIfMaxDepth);
            ctx.paramTieBreaker = this.booleanOrDefault(mapParams.get("tieBreaker"), ctx.paramTieBreaker);
            ctx.paramDFactor = this.doubleOrDefault(mapParams.get("dFactor"), ctx.paramDFactor);
            if (mapParams.get("heuristicFormula") != null) {
                ctx.paramHeuristicFormula = mapParams.get("heuristicFormula") instanceof String ? HeuristicFormula.valueOf(this.stringOrDefault(mapParams.get("heuristicFormula"), "MANHATAN").toUpperCase(Locale.ENGLISH)) : (HeuristicFormula)((Object)mapParams.get("heuristicFormula"));
            }
            ctx.paramCustomHeuristicFormula = this.stringOrDefault(mapParams.get("customHeuristicFormula"), "");
        }
    }

    public String getSyntax() {
        return "astar(<sourceVertex>, <destinationVertex>, <weightEdgeFieldName>, [<options>]) \n // options  : {direction:\"OUT\",edgeTypeNames:[] , vertexAxisNames:[] , parallel : false , tieBreaker:true,maxDepth:99999,dFactor:1.0,customHeuristicFormula:'custom_Function_Name_here'  }";
    }

    public Object getResult() {
        return this.getPath();
    }

    @Override
    protected double getDistance(OrientVertex node, OrientVertex parent, OrientVertex target) {
        Object fieldValue;
        Edge e;
        Iterator<Edge> edges = node.getEdges(target, this.paramDirection, new String[0]).iterator();
        if (edges.hasNext() && (e = edges.next()) != null && (fieldValue = e.getProperty(this.paramWeightFieldName)) != null) {
            if (fieldValue instanceof Float) {
                return ((Float)fieldValue).floatValue();
            }
            if (fieldValue instanceof Number) {
                return ((Number)fieldValue).doubleValue();
            }
        }
        return 0.0;
    }

    protected double getDistance(OrientEdge edge) {
        Object fieldValue;
        if (edge != null && (fieldValue = edge.getProperty(this.paramWeightFieldName)) != null) {
            if (fieldValue instanceof Float) {
                return ((Float)fieldValue).floatValue();
            }
            if (fieldValue instanceof Number) {
                return ((Number)fieldValue).doubleValue();
            }
        }
        return 0.0;
    }

    public boolean aggregateResults() {
        return false;
    }

    @Override
    protected double getHeuristicCost(OrientVertex node, OrientVertex parent, OrientVertex target) {
        double hresult = 0.0;
        if (this.paramVertexAxisNames.length == 0) {
            return hresult;
        }
        if (this.paramVertexAxisNames.length == 1) {
            double n = this.doubleOrDefault(node.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double g = this.doubleOrDefault(target.getProperty(this.paramVertexAxisNames[0]), 0.0);
            hresult = this.getSimpleHeuristicCost(n, g, this.paramDFactor);
        } else if (this.paramVertexAxisNames.length == 2) {
            if (parent == null) {
                parent = node;
            }
            double sx = this.doubleOrDefault(this.paramSourceVertex.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double sy = this.doubleOrDefault(this.paramSourceVertex.getProperty(this.paramVertexAxisNames[1]), 0.0);
            double nx = this.doubleOrDefault(node.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double ny = this.doubleOrDefault(node.getProperty(this.paramVertexAxisNames[1]), 0.0);
            double px = this.doubleOrDefault(parent.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double py = this.doubleOrDefault(parent.getProperty(this.paramVertexAxisNames[1]), 0.0);
            double gx = this.doubleOrDefault(target.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double gy = this.doubleOrDefault(target.getProperty(this.paramVertexAxisNames[1]), 0.0);
            switch (this.paramHeuristicFormula) {
                case MANHATAN: {
                    hresult = this.getManhatanHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case MAXAXIS: {
                    hresult = this.getMaxAxisHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case DIAGONAL: {
                    hresult = this.getDiagonalHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case EUCLIDEAN: {
                    hresult = this.getEuclideanHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case EUCLIDEANNOSQR: {
                    hresult = this.getEuclideanNoSQRHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case CUSTOM: {
                    hresult = this.getCustomHeuristicCost(this.paramCustomHeuristicFormula, this.paramVertexAxisNames, this.paramSourceVertex, this.paramDestinationVertex, node, parent, this.currentDepth, this.paramDFactor);
                }
            }
            if (this.paramTieBreaker.booleanValue()) {
                hresult = this.getTieBreakingHeuristicCost(px, py, sx, sy, gx, gy, hresult);
            }
        } else {
            HashMap<String, Double> sList = new HashMap<String, Double>();
            HashMap<String, Double> cList = new HashMap<String, Double>();
            HashMap<String, Double> pList = new HashMap<String, Double>();
            HashMap<String, Double> gList = new HashMap<String, Double>();
            parent = parent == null ? node : parent;
            for (int i = 0; i < this.paramVertexAxisNames.length; ++i) {
                Double s = this.doubleOrDefault(this.paramSourceVertex.getProperty(this.paramVertexAxisNames[i]), 0.0);
                Double c = this.doubleOrDefault(node.getProperty(this.paramVertexAxisNames[i]), 0.0);
                Double g = this.doubleOrDefault(target.getProperty(this.paramVertexAxisNames[i]), 0.0);
                Double p = this.doubleOrDefault(parent.getProperty(this.paramVertexAxisNames[i]), 0.0);
                if (s != null) {
                    sList.put(this.paramVertexAxisNames[i], s);
                }
                if (c != null) {
                    cList.put(this.paramVertexAxisNames[i], s);
                }
                if (g != null) {
                    gList.put(this.paramVertexAxisNames[i], g);
                }
                if (p == null) continue;
                pList.put(this.paramVertexAxisNames[i], p);
            }
            switch (this.paramHeuristicFormula) {
                case MANHATAN: {
                    hresult = this.getManhatanHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case MAXAXIS: {
                    hresult = this.getMaxAxisHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case DIAGONAL: {
                    hresult = this.getDiagonalHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case EUCLIDEAN: {
                    hresult = this.getEuclideanHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case EUCLIDEANNOSQR: {
                    hresult = this.getEuclideanNoSQRHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case CUSTOM: {
                    hresult = this.getCustomHeuristicCost(this.paramCustomHeuristicFormula, this.paramVertexAxisNames, this.paramSourceVertex, this.paramDestinationVertex, node, parent, this.currentDepth, this.paramDFactor);
                }
            }
            if (this.paramTieBreaker.booleanValue()) {
                hresult = this.getTieBreakingHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, hresult);
            }
        }
        return hresult;
    }

    @Override
    protected boolean isVariableEdgeWeight() {
        return true;
    }
}

