/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class OHttpGraphResponse
extends OHttpResponse {
    public OHttpGraphResponse(OHttpResponse iWrapped) {
        super(iWrapped.getOutputStream(), iWrapped.httpVersion, iWrapped.additionalHeaders, iWrapped.characterSet, iWrapped.serverInfo, iWrapped.sessionId, iWrapped.callbackFunction, iWrapped.keepAlive, iWrapped.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept, Map<String, Object> iAdditionalProperties, String mode) throws IOException {
        if (iRecords == null) {
            this.send(204, "", "text/plain", null, null);
            return;
        }
        if (!mode.equalsIgnoreCase("graph")) {
            super.writeRecords(iRecords, iFetchPlan, iFormat, accept, iAdditionalProperties, mode);
            return;
        }
        if (accept != null && accept.contains("text/csv")) {
            throw new IllegalArgumentException("Graph mode cannot accept '" + accept + "'");
        }
        OrientGraphNoTx graph = (OrientGraphNoTx)OrientGraphFactory.getNoTxGraphImplFactory().getGraph((ODatabaseDocumentTx)ODatabaseRecordThreadLocal.INSTANCE.get());
        try {
            HashSet<Object> rsEdges = new HashSet<Object>();
            HashSet<OrientVertex> vertices = new HashSet<OrientVertex>();
            Iterator iIterator = OMultiValue.getMultiValueIterator((Object)iRecords);
            while (iIterator.hasNext()) {
                Object entry = iIterator.next();
                if (entry == null || !(entry instanceof OIdentifiable) || (entry = ((OIdentifiable)entry).getRecord()) == null || !(entry instanceof OIdentifiable) || !(entry instanceof ODocument)) continue;
                OClass schemaClass = ((ODocument)entry).getSchemaClass();
                if (schemaClass != null && schemaClass.isVertexType()) {
                    vertices.add(graph.getVertex(entry));
                    continue;
                }
                if (schemaClass == null || !schemaClass.isEdgeType()) continue;
                OrientEdge edge = graph.getEdge(entry);
                rsEdges.add(edge);
                vertices.add(graph.getVertex(edge.getVertex(Direction.IN)));
                vertices.add(graph.getVertex(edge.getVertex(Direction.OUT)));
            }
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter((Writer)buffer, "");
            json.beginObject();
            json.beginObject((Object)"graph");
            json.beginCollection("vertices");
            for (OrientVertex orientVertex : vertices) {
                json.beginObject();
                json.writeAttribute("@rid", (Object)orientVertex.getIdentity());
                json.writeAttribute("@class", (Object)orientVertex.getRecord().getClassName());
                for (String field : orientVertex.getPropertyKeys()) {
                    Object v = orientVertex.getProperty(field);
                    if (v == null) continue;
                    json.writeAttribute(field, v);
                }
                json.endObject();
            }
            json.endCollection();
            json.beginCollection("edges");
            if (rsEdges.isEmpty()) {
                HashSet<ORID> edgeRids = new HashSet<ORID>();
                for (OrientVertex vertex : vertices) {
                    for (Edge e : vertex.getEdges(Direction.BOTH, new String[0])) {
                        OrientEdge edge = (OrientEdge)e;
                        if (edgeRids.contains(((OrientEdge)e).getIdentity()) || !vertices.contains(edge.getVertex(Direction.OUT)) || !vertices.contains(edge.getVertex(Direction.IN))) continue;
                        edgeRids.add(edge.getIdentity());
                        this.writeEdge(edge, json);
                    }
                }
            } else {
                for (OrientEdge orientEdge : rsEdges) {
                    if (!vertices.contains(orientEdge.getVertex(Direction.OUT)) || !vertices.contains(orientEdge.getVertex(Direction.IN))) continue;
                    this.writeEdge(orientEdge, json);
                }
            }
            json.endCollection();
            if (iAdditionalProperties != null) {
                for (Map.Entry entry : iAdditionalProperties.entrySet()) {
                    Object v = entry.getValue();
                    if (OMultiValue.isMultiValue(v)) {
                        json.beginCollection(-1, true, (String)entry.getKey());
                        this.formatMultiValue(OMultiValue.getMultiValueIterator(v), buffer, null);
                        json.endCollection(-1, true);
                    } else {
                        json.writeAttribute((String)entry.getKey(), v);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
            }
            json.endObject();
            json.endObject();
            this.send(200, "OK", "application/json", buffer.toString(), null);
        }
        finally {
            graph.shutdown();
        }
    }

    private void writeEdge(OrientEdge edge, OJSONWriter json) throws IOException {
        json.beginObject();
        json.writeAttribute("@rid", (Object)edge.getIdentity());
        json.writeAttribute("@class", (Object)edge.getRecord().getClassName());
        json.writeAttribute("out", edge.getVertex(Direction.OUT).getId());
        json.writeAttribute("in", edge.getVertex(Direction.IN).getId());
        for (String field : edge.getPropertyKeys()) {
            Object v = edge.getProperty(field);
            if (v == null) continue;
            json.writeAttribute(field, v);
        }
        json.endObject();
    }
}

