/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.outputmanager;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public class OOutputStreamManager {
    public PrintStream outputStream;
    private int level;
    public static final int BLANK_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARNING_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;

    public OOutputStreamManager(int level) {
        this.outputStream = System.out;
        this.level = level;
    }

    public OOutputStreamManager(PrintStream outputStream, int level) {
        this.outputStream = outputStream;
        this.level = level;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void debug(String message) {
        if (this.level != 0 && message != null && this.level <= 1) {
            this.outputStream.print(message);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.level != 0 && format != null && this.level <= 1) {
            this.outputStream.printf(format, args);
        }
    }

    public void info(String message) {
        if (this.level != 0 && message != null && this.level <= 2) {
            this.outputStream.print(message);
        }
    }

    public void info(String format, Object ... args) {
        if (this.level != 0 && format != null && this.level <= 2) {
            this.outputStream.printf(format, args);
        }
    }

    public void warn(String message) {
        if (this.level != 0 && message != null && this.level <= 3) {
            this.outputStream.print(message);
        }
    }

    public void warn(String format, Object ... args) {
        if (this.level != 0 && format != null && this.level <= 3) {
            this.outputStream.printf(format, args);
        }
    }

    public void error(String message) {
        if (this.level != 0 && message != null && this.level <= 4) {
            this.outputStream.print("\nERROR: " + message);
        }
    }

    public void error(String format, Object ... args) {
        if (this.level != 0 && format != null && this.level <= 4) {
            this.outputStream.printf(format, "\nERROR: ", Arrays.toString(args));
        }
    }
}

