/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.stresstest.workload;

import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.orient.stresstest.workload.OCRUDWorkload;
import com.orientechnologies.orient.stresstest.workload.OWorkload;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OWorkloadFactory {
    private Map<String, OWorkload> registered = new HashMap<String, OWorkload>();

    public OWorkloadFactory() {
        this.register(new OCRUDWorkload());
        ClassLoader orientClassLoader = OWorkloadFactory.class.getClassLoader();
        Iterator ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OWorkload.class, (ClassLoader)orientClassLoader);
        while (ite.hasNext()) {
            OWorkload strategy = (OWorkload)ite.next();
            this.register(strategy);
        }
    }

    public OWorkload get(String name) {
        return this.registered.get(name.toUpperCase(Locale.ENGLISH));
    }

    public void register(OWorkload workload) {
        this.registered.put(workload.getName().toUpperCase(Locale.ENGLISH), workload);
    }

    public Set<String> getRegistered() {
        return this.registered.keySet();
    }
}

