/**
 * Sencha GXT 3.1.1 - Sencha for GWT
 * Copyright(c) 2007-2014, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://www.sencha.com/products/gxt/license/
 */
package com.sencha.gxt.chart.client.draw;

/**
 * Represents a gradient stop.
 */
public class Stop {

  private final int offset;
  private final Color color;
  private final double opacity;

  /**
   * Creates a stop with the default values.
   */
  public Stop() {
    this(10, new Color("#fff"));
  }

  /**
   * Creates a stop using the given offset and color.
   * 
   * @param offset the offset of the stop
   * @param color the color of the stop
   */
  public Stop(int offset, Color color) {
    this(offset, color, 1);
  }

  /**
   * Creates a stop using the given offset, color and opacity.
   * 
   * @param offset the offset of the stop
   * @param color the color of the stop
   * @param opacity the opacity of the stop
   */
  public Stop(int offset, Color color, double opacity) {
    assert offset >= 0 && offset <= 100 : "Gradient stop offset must be within [0,100]: " + offset;
    this.offset = offset;
    this.color = color;
    this.opacity = opacity;
  }

  /**
   * Returns the color of the stop.
   * 
   * @return the color of the stop
   */
  public Color getColor() {
    return color;
  }

  /**
   * Returns the offset of the stop.
   * 
   * @return the offset of the stop
   */
  public int getOffset() {
    return offset;
  }

  /**
   * Returns the opacity of the stop.
   * 
   * @return the opacity of the stop
   */
  public double getOpacity() {
    return opacity;
  }
}
