/**
 * Sencha GXT 3.1.1 - Sencha for GWT
 * Copyright(c) 2007-2014, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://www.sencha.com/products/gxt/license/
 */
package com.sencha.gxt.chart.client.draw.sprite;

import com.google.gwt.event.shared.HandlerRegistration;
import com.sencha.gxt.chart.client.draw.sprite.SpriteOutEvent.SpriteOutHandler;
import com.sencha.gxt.chart.client.draw.sprite.SpriteOverEvent.SpriteOverHandler;
import com.sencha.gxt.chart.client.draw.sprite.SpriteSelectionEvent.SpriteSelectionHandler;
import com.sencha.gxt.chart.client.draw.sprite.SpriteUpEvent.SpriteUpHandler;

/**
 * Aggregating handler interface for:
 * 
 * <dl>
 * <dd>{@link SpriteSelectionEvent}</b></dd>
 * <dd>{@link SpriteOutEvent}</b></dd>
 * <dd>{@link SpriteOverEvent}</b></dd>
 * <dd>{@link SpriteUpEvent}</b></dd>
 * </dl>
 */
public interface SpriteHandler extends SpriteSelectionHandler, SpriteOutHandler, SpriteOverHandler, SpriteUpHandler {

  /**
   * A widget that implements this interface is a public source of
   * {@link SpriteSelectionEvent}, {@link SpriteOutEvent},
   * {@link SpriteOverEvent} and {@link SpriteUpEvent} events.
   */
  public interface HasSpriteHandlers {

    /**
     * Adds a {@link SpriteHandler} handler for {@link SpriteSelectionEvent},
     * {@link SpriteOutEvent}, {@link SpriteOverEvent} and {@link SpriteUpEvent}
     * events.
     * 
     * @param handler the handler
     * @return the registration for the event
     */
    public HandlerRegistration addSpriteHandler(SpriteHandler handler);

  }
}
