/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javawriter;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;

public class JavaWriter
implements Closeable {
    private static final Pattern TYPE_PATTERN = Pattern.compile("(?:[\\w$]+\\.)*([\\w\\.*$]+)");
    private static final int MAX_SINGLE_LINE_ATTRIBUTES = 3;
    private static final String INDENT = "  ";
    private final Map<String, String> importedTypes = new LinkedHashMap<String, String>();
    private String packagePrefix;
    private final Deque<Scope> scopes = new ArrayDeque<Scope>();
    private final Deque<String> types = new ArrayDeque<String>();
    private final Writer out;
    private boolean isCompressingTypes = true;
    private String indent = "  ";
    private static final EnumSet<Scope> METHOD_SCOPES = EnumSet.of(Scope.NON_ABSTRACT_METHOD, Scope.CONSTRUCTOR, Scope.CONTROL_FLOW, Scope.INITIALIZER);

    public JavaWriter(Writer out) {
        this.out = out;
    }

    public void setCompressingTypes(boolean isCompressingTypes) {
        this.isCompressingTypes = isCompressingTypes;
    }

    public boolean isCompressingTypes() {
        return this.isCompressingTypes;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getIndent() {
        return this.indent;
    }

    public JavaWriter emitPackage(String packageName) throws IOException {
        if (this.packagePrefix != null) {
            throw new IllegalStateException();
        }
        if (packageName.isEmpty()) {
            this.packagePrefix = "";
        } else {
            this.out.write("package ");
            this.out.write(packageName);
            this.out.write(";\n\n");
            this.packagePrefix = packageName + ".";
        }
        return this;
    }

    public JavaWriter emitImports(String ... types) throws IOException {
        return this.emitImports(Arrays.asList(types));
    }

    public JavaWriter emitImports(Class<?> ... types) throws IOException {
        ArrayList<String> classNames = new ArrayList<String>(types.length);
        for (Class<?> classToImport : types) {
            classNames.add(classToImport.getName());
        }
        return this.emitImports(classNames);
    }

    public JavaWriter emitImports(Collection<String> types) throws IOException {
        for (String type : new TreeSet<String>(types)) {
            Matcher matcher = TYPE_PATTERN.matcher(type);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(type);
            }
            if (this.importedTypes.put(type, matcher.group(1)) != null) {
                throw new IllegalArgumentException(type);
            }
            this.out.write("import ");
            this.out.write(type);
            this.out.write(";\n");
        }
        return this;
    }

    public JavaWriter emitStaticImports(String ... types) throws IOException {
        return this.emitStaticImports(Arrays.asList(types));
    }

    public JavaWriter emitStaticImports(Collection<String> types) throws IOException {
        for (String type : new TreeSet<String>(types)) {
            Matcher matcher = TYPE_PATTERN.matcher(type);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(type);
            }
            if (this.importedTypes.put(type, matcher.group(1)) != null) {
                throw new IllegalArgumentException(type);
            }
            this.out.write("import static ");
            this.out.write(type);
            this.out.write(";\n");
        }
        return this;
    }

    private JavaWriter emitCompressedType(String type) throws IOException {
        if (this.isCompressingTypes) {
            this.out.write(this.compressType(type));
        } else {
            this.out.write(type);
        }
        return this;
    }

    public String compressType(String type) {
        StringBuilder sb = new StringBuilder();
        if (this.packagePrefix == null) {
            throw new IllegalStateException();
        }
        Matcher m = TYPE_PATTERN.matcher(type);
        int pos = 0;
        while (true) {
            boolean found;
            int typeStart = (found = m.find(pos)) ? m.start() : type.length();
            sb.append(type, pos, typeStart);
            if (!found) break;
            String name = m.group(0);
            String imported = this.importedTypes.get(name);
            if (imported != null) {
                sb.append(imported);
            } else if (this.isClassInPackage(name)) {
                String compressed = name.substring(this.packagePrefix.length());
                if (this.isAmbiguous(compressed)) {
                    sb.append(name);
                } else {
                    sb.append(compressed);
                }
            } else if (name.startsWith("java.lang.")) {
                sb.append(name.substring("java.lang.".length()));
            } else {
                sb.append(name);
            }
            pos = m.end();
        }
        return sb.toString();
    }

    private boolean isClassInPackage(String name) {
        if (name.startsWith(this.packagePrefix)) {
            if (name.indexOf(46, this.packagePrefix.length()) == -1) {
                return true;
            }
            if (Character.isUpperCase(name.charAt(this.packagePrefix.length()))) {
                return true;
            }
        }
        return false;
    }

    private boolean isAmbiguous(String compressed) {
        return this.importedTypes.values().contains(compressed);
    }

    public JavaWriter beginInitializer(boolean isStatic) throws IOException {
        this.indent();
        if (isStatic) {
            this.out.write("static");
            this.out.write(" {\n");
        } else {
            this.out.write("{\n");
        }
        this.scopes.push(Scope.INITIALIZER);
        return this;
    }

    public JavaWriter endInitializer() throws IOException {
        this.popScope(Scope.INITIALIZER);
        this.indent();
        this.out.write("}\n");
        return this;
    }

    public JavaWriter beginType(String type, String kind) throws IOException {
        return this.beginType(type, kind, EnumSet.noneOf(Modifier.class), null, new String[0]);
    }

    public JavaWriter beginType(String type, String kind, Set<Modifier> modifiers) throws IOException {
        return this.beginType(type, kind, modifiers, null, new String[0]);
    }

    public JavaWriter beginType(String type, String kind, Set<Modifier> modifiers, String extendsType, String ... implementsTypes) throws IOException {
        this.indent();
        this.emitModifiers(modifiers);
        this.out.write(kind);
        this.out.write(" ");
        this.emitCompressedType(type);
        if (extendsType != null) {
            this.out.write(" extends ");
            this.emitCompressedType(extendsType);
        }
        if (implementsTypes.length > 0) {
            this.out.write("\n");
            this.indent();
            this.out.write("    implements ");
            for (int i = 0; i < implementsTypes.length; ++i) {
                if (i != 0) {
                    this.out.write(", ");
                }
                this.emitCompressedType(implementsTypes[i]);
            }
        }
        this.out.write(" {\n");
        this.scopes.push(Scope.TYPE_DECLARATION);
        this.types.push(type);
        return this;
    }

    public JavaWriter endType() throws IOException {
        this.popScope(Scope.TYPE_DECLARATION);
        this.types.pop();
        this.indent();
        this.out.write("}\n");
        return this;
    }

    public JavaWriter emitField(String type, String name) throws IOException {
        return this.emitField(type, name, EnumSet.noneOf(Modifier.class), null);
    }

    public JavaWriter emitField(String type, String name, Set<Modifier> modifiers) throws IOException {
        return this.emitField(type, name, modifiers, null);
    }

    public JavaWriter emitField(String type, String name, Set<Modifier> modifiers, String initialValue) throws IOException {
        this.indent();
        this.emitModifiers(modifiers);
        this.emitCompressedType(type);
        this.out.write(" ");
        this.out.write(name);
        if (initialValue != null) {
            this.out.write(" = ");
            this.out.write(initialValue);
        }
        this.out.write(";\n");
        return this;
    }

    public JavaWriter beginMethod(String returnType, String name, Set<Modifier> modifiers, String ... parameters) throws IOException {
        return this.beginMethod(returnType, name, modifiers, Arrays.asList(parameters), null);
    }

    public JavaWriter beginMethod(String returnType, String name, Set<Modifier> modifiers, List<String> parameters, List<String> throwsTypes) throws IOException {
        this.indent();
        this.emitModifiers(modifiers);
        if (returnType != null) {
            this.emitCompressedType(returnType);
            this.out.write(" ");
            this.out.write(name);
        } else {
            this.emitCompressedType(name);
        }
        this.out.write("(");
        if (parameters != null) {
            int p = 0;
            while (p < parameters.size()) {
                if (p != 0) {
                    this.out.write(", ");
                }
                this.emitCompressedType(parameters.get(p++));
                this.out.write(" ");
                this.emitCompressedType(parameters.get(p++));
            }
        }
        this.out.write(")");
        if (throwsTypes != null && throwsTypes.size() > 0) {
            this.out.write("\n");
            this.indent();
            this.out.write("    throws ");
            for (int i = 0; i < throwsTypes.size(); ++i) {
                if (i != 0) {
                    this.out.write(", ");
                }
                this.emitCompressedType(throwsTypes.get(i));
            }
        }
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            this.out.write(";\n");
            this.scopes.push(Scope.ABSTRACT_METHOD);
        } else {
            this.out.write(" {\n");
            this.scopes.push(returnType == null ? Scope.CONSTRUCTOR : Scope.NON_ABSTRACT_METHOD);
        }
        return this;
    }

    public JavaWriter beginConstructor(Set<Modifier> modifiers, String ... parameters) throws IOException {
        this.beginMethod(null, this.types.peekFirst(), modifiers, parameters);
        return this;
    }

    public JavaWriter beginConstructor(Set<Modifier> modifiers, List<String> parameters, List<String> throwsTypes) throws IOException {
        this.beginMethod(null, this.types.peekFirst(), modifiers, parameters, throwsTypes);
        return this;
    }

    public JavaWriter emitJavadoc(String javadoc, Object ... params) throws IOException {
        String formatted = String.format(javadoc, params);
        this.indent();
        this.out.write("/**\n");
        for (String line : formatted.split("\n")) {
            this.indent();
            this.out.write(" *");
            if (!line.isEmpty()) {
                this.out.write(" ");
                this.out.write(line);
            }
            this.out.write("\n");
        }
        this.indent();
        this.out.write(" */\n");
        return this;
    }

    public JavaWriter emitSingleLineComment(String comment, Object ... args) throws IOException {
        this.indent();
        this.out.write("// ");
        this.out.write(String.format(comment, args));
        this.out.write("\n");
        return this;
    }

    public JavaWriter emitEmptyLine() throws IOException {
        this.out.write("\n");
        return this;
    }

    public JavaWriter emitEnumValue(String name) throws IOException {
        this.indent();
        this.out.write(name);
        this.out.write(",\n");
        return this;
    }

    private JavaWriter emitLastEnumValue(String name) throws IOException {
        this.indent();
        this.out.write(name);
        this.out.write(";\n");
        return this;
    }

    public JavaWriter emitEnumValues(Iterable<String> names) throws IOException {
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            if (iterator.hasNext()) {
                this.emitEnumValue(name);
                continue;
            }
            this.emitLastEnumValue(name);
        }
        return this;
    }

    public JavaWriter emitAnnotation(String annotation) throws IOException {
        return this.emitAnnotation(annotation, Collections.emptyMap());
    }

    public JavaWriter emitAnnotation(Class<? extends Annotation> annotationType) throws IOException {
        return this.emitAnnotation(JavaWriter.type(annotationType, new String[0]), Collections.emptyMap());
    }

    public JavaWriter emitAnnotation(Class<? extends Annotation> annotationType, Object value) throws IOException {
        return this.emitAnnotation(JavaWriter.type(annotationType, new String[0]), value);
    }

    public JavaWriter emitAnnotation(String annotation, Object value) throws IOException {
        this.indent();
        this.out.write("@");
        this.emitCompressedType(annotation);
        this.out.write("(");
        this.emitAnnotationValue(value);
        this.out.write(")");
        this.out.write("\n");
        return this;
    }

    public JavaWriter emitAnnotation(Class<? extends Annotation> annotationType, Map<String, ?> attributes) throws IOException {
        return this.emitAnnotation(JavaWriter.type(annotationType, new String[0]), attributes);
    }

    public JavaWriter emitAnnotation(String annotation, Map<String, ?> attributes) throws IOException {
        this.indent();
        this.out.write("@");
        this.emitCompressedType(annotation);
        switch (attributes.size()) {
            case 0: {
                break;
            }
            case 1: {
                Map.Entry<String, ?> onlyEntry = attributes.entrySet().iterator().next();
                this.out.write("(");
                if (!"value".equals(onlyEntry.getKey())) {
                    this.out.write(onlyEntry.getKey());
                    this.out.write(" = ");
                }
                this.emitAnnotationValue(onlyEntry.getValue());
                this.out.write(")");
                break;
            }
            default: {
                boolean split = attributes.size() > 3 || this.containsArray(attributes.values());
                this.out.write("(");
                this.scopes.push(Scope.ANNOTATION_ATTRIBUTE);
                String separator = split ? "\n" : "";
                for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                    this.out.write(separator);
                    String string = separator = split ? ",\n" : ", ";
                    if (split) {
                        this.indent();
                    }
                    this.out.write(entry.getKey());
                    this.out.write(" = ");
                    Object value = entry.getValue();
                    this.emitAnnotationValue(value);
                }
                this.popScope(Scope.ANNOTATION_ATTRIBUTE);
                if (split) {
                    this.out.write("\n");
                    this.indent();
                }
                this.out.write(")");
            }
        }
        this.out.write("\n");
        return this;
    }

    private boolean containsArray(Collection<?> values) {
        for (Object value : values) {
            if (!(value instanceof Object[])) continue;
            return true;
        }
        return false;
    }

    private JavaWriter emitAnnotationValue(Object value) throws IOException {
        if (value instanceof Object[]) {
            this.out.write("{");
            boolean firstValue = true;
            this.scopes.push(Scope.ANNOTATION_ARRAY_VALUE);
            for (Object o : (Object[])value) {
                if (firstValue) {
                    firstValue = false;
                    this.out.write("\n");
                } else {
                    this.out.write(",\n");
                }
                this.indent();
                this.out.write(o.toString());
            }
            this.popScope(Scope.ANNOTATION_ARRAY_VALUE);
            this.out.write("\n");
            this.indent();
            this.out.write("}");
        } else {
            this.out.write(value.toString());
        }
        return this;
    }

    public JavaWriter emitStatement(String pattern, Object ... args) throws IOException {
        this.checkInMethod();
        String[] lines = String.format(pattern, args).split("\n", -1);
        this.indent();
        this.out.write(lines[0]);
        for (int i = 1; i < lines.length; ++i) {
            this.out.write("\n");
            this.hangingIndent();
            this.out.write(lines[i]);
        }
        this.out.write(";\n");
        return this;
    }

    public JavaWriter beginControlFlow(String controlFlow) throws IOException {
        this.checkInMethod();
        this.indent();
        this.out.write(controlFlow);
        this.out.write(" {\n");
        this.scopes.push(Scope.CONTROL_FLOW);
        return this;
    }

    public JavaWriter nextControlFlow(String controlFlow) throws IOException {
        this.popScope(Scope.CONTROL_FLOW);
        this.indent();
        this.scopes.push(Scope.CONTROL_FLOW);
        this.out.write("} ");
        this.out.write(controlFlow);
        this.out.write(" {\n");
        return this;
    }

    public JavaWriter endControlFlow() throws IOException {
        return this.endControlFlow(null);
    }

    public JavaWriter endControlFlow(String controlFlow) throws IOException {
        this.popScope(Scope.CONTROL_FLOW);
        this.indent();
        if (controlFlow != null) {
            this.out.write("} ");
            this.out.write(controlFlow);
            this.out.write(";\n");
        } else {
            this.out.write("}\n");
        }
        return this;
    }

    public JavaWriter endMethod() throws IOException {
        Scope popped = this.scopes.pop();
        if (popped == Scope.NON_ABSTRACT_METHOD || popped == Scope.CONSTRUCTOR) {
            this.indent();
            this.out.write("}\n");
        } else if (popped != Scope.ABSTRACT_METHOD) {
            throw new IllegalStateException();
        }
        return this;
    }

    public JavaWriter endConstructor() throws IOException {
        this.popScope(Scope.CONSTRUCTOR);
        this.indent();
        this.out.write("}\n");
        return this;
    }

    public static String stringLiteral(String data) {
        StringBuilder result = new StringBuilder();
        result.append('\"');
        block9: for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        result.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    result.append(c);
                }
            }
        }
        result.append('\"');
        return result.toString();
    }

    public static String type(Class<?> raw, String ... parameters) {
        if (parameters.length == 0) {
            return raw.getCanonicalName();
        }
        if (raw.getTypeParameters().length != parameters.length) {
            throw new IllegalArgumentException();
        }
        StringBuilder result = new StringBuilder();
        result.append(raw.getCanonicalName());
        result.append("<");
        result.append(parameters[0]);
        for (int i = 1; i < parameters.length; ++i) {
            result.append(", ");
            result.append(parameters[i]);
        }
        result.append(">");
        return result.toString();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private void emitModifiers(Set<Modifier> modifiers) throws IOException {
        if (!(modifiers instanceof EnumSet)) {
            modifiers = EnumSet.copyOf(modifiers);
        }
        for (Modifier modifier : modifiers) {
            this.out.append(modifier.toString()).append(' ');
        }
    }

    private void indent() throws IOException {
        int count = this.scopes.size();
        for (int i = 0; i < count; ++i) {
            this.out.write(this.indent);
        }
    }

    private void hangingIndent() throws IOException {
        int count = this.scopes.size() + 2;
        for (int i = 0; i < count; ++i) {
            this.out.write(this.indent);
        }
    }

    private void checkInMethod() {
        if (!METHOD_SCOPES.contains((Object)this.scopes.peekFirst())) {
            throw new IllegalArgumentException();
        }
    }

    private void popScope(Scope expected) {
        if (this.scopes.pop() != expected) {
            throw new IllegalStateException();
        }
    }

    private static enum Scope {
        TYPE_DECLARATION,
        ABSTRACT_METHOD,
        NON_ABSTRACT_METHOD,
        CONSTRUCTOR,
        CONTROL_FLOW,
        ANNOTATION_ATTRIBUTE,
        ANNOTATION_ARRAY_VALUE,
        INITIALIZER;

    }
}

