/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.FilterConfigImpl;
import com.sun.grizzly.http.servlet.ServletConfigImpl;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class FilterChainImpl
implements FilterChain {
    public static final int INCREMENT = 8;
    private FilterConfigImpl[] filters = new FilterConfigImpl[8];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private ServletConfigImpl wrapper;

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.pos < this.n) {
            FilterConfigImpl filterConfig = this.filters[this.pos++];
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                filter.doFilter(request, response, (FilterChain)this);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new ServletException("Throwable", e);
            }
            return;
        }
        try {
            if (this.servlet != null) {
                this.servlet.service(request, response);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException("Throwable", e);
        }
    }

    public void addFilter(FilterConfigImpl filterConfig) {
        if (this.n == this.filters.length) {
            FilterConfigImpl[] newFilters = new FilterConfigImpl[this.n + 8];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    public void recycle() {
        this.n = 0;
        this.pos = 0;
    }

    public void setServlet(ServletConfigImpl wrapper, Servlet servlet) {
        this.wrapper = wrapper;
        this.servlet = servlet;
    }

    public int getSize() {
        return this.n;
    }

    public FilterConfigImpl getFilter(int i) {
        return this.filters[i];
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfigImpl getServletConfig() {
        return this.wrapper;
    }

    public int getPos() {
        return this.pos;
    }
}

