/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.twitter.joauth.MalformedRequest;
import com.twitter.joauth.Normalizer;
import com.twitter.joauth.OAuth1Params;
import com.twitter.joauth.OAuth1Request;
import com.twitter.joauth.OAuthParams$;
import com.twitter.joauth.ParsedRequest;
import com.twitter.joauth.UrlDecoder$;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple9;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class OAuth1Request$
implements ScalaObject,
Serializable {
    public static final OAuth1Request$ MODULE$;
    private final String NO_VALUE_FOR;
    private final String SCHEME;
    private final String HOST;
    private final String PORT;
    private final String VERB;
    private final String PATH;
    private final String UNSUPPORTED_METHOD;
    private final String UNSUPPORTED_VERSION;
    private final String MALFORMED_TOKEN;
    private final int MaxTokenLength;

    static {
        new OAuth1Request$();
    }

    public String NO_VALUE_FOR() {
        return this.NO_VALUE_FOR;
    }

    public String SCHEME() {
        return this.SCHEME;
    }

    public String HOST() {
        return this.HOST;
    }

    public String PORT() {
        return this.PORT;
    }

    public String VERB() {
        return this.VERB;
    }

    public String PATH() {
        return this.PATH;
    }

    public String UNSUPPORTED_METHOD() {
        return this.UNSUPPORTED_METHOD;
    }

    public String UNSUPPORTED_VERSION() {
        return this.UNSUPPORTED_VERSION;
    }

    public String MALFORMED_TOKEN() {
        return this.MALFORMED_TOKEN;
    }

    public int MaxTokenLength() {
        return this.MaxTokenLength;
    }

    public MalformedRequest nullException(String name) {
        return new MalformedRequest(new StringBuilder().append((Object)this.NO_VALUE_FOR()).append((Object)name).toString());
    }

    public void verify(ParsedRequest parsedRequest, OAuth1Params oAuth1Params) throws MalformedRequest {
        block9: {
            block11: {
                block10: {
                    if (parsedRequest.scheme() == null) {
                        throw this.nullException(this.SCHEME());
                    }
                    if (parsedRequest.host() == null) {
                        throw this.nullException(this.HOST());
                    }
                    if (parsedRequest.port() < 0) {
                        throw this.nullException(this.PORT());
                    }
                    if (parsedRequest.verb() == null) {
                        throw this.nullException(this.VERB());
                    }
                    if (parsedRequest.path() == null) {
                        throw this.nullException(this.PATH());
                    }
                    String string = oAuth1Params.signatureMethod();
                    String string2 = OAuthParams$.MODULE$.HMAC_SHA1();
                    if (string != null ? !string.equals(string2) : string2 != null) break block9;
                    if (oAuth1Params.version() == null) break block10;
                    String string3 = oAuth1Params.version();
                    String string4 = OAuthParams$.MODULE$.ONE_DOT_OH();
                    if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block10;
                    String string5 = oAuth1Params.version().toLowerCase();
                    String string6 = OAuthParams$.MODULE$.ONE_DOT_OH_A();
                    if (string5 != null ? !string5.equals(string6) : string6 != null) break block11;
                }
                if (oAuth1Params.token() != null && (oAuth1Params.token().indexOf(32) > 0 || oAuth1Params.token().length() > this.MaxTokenLength())) {
                    throw new MalformedRequest(new StringBuilder().append((Object)this.MALFORMED_TOKEN()).append((Object)oAuth1Params.token()).toString());
                }
                return;
            }
            throw new MalformedRequest(new StringBuilder().append((Object)this.UNSUPPORTED_VERSION()).append((Object)oAuth1Params.version()).toString());
        }
        throw new MalformedRequest(new StringBuilder().append((Object)this.UNSUPPORTED_METHOD()).append((Object)oAuth1Params.signatureMethod()).toString());
    }

    public OAuth1Request apply(ParsedRequest parsedRequest, OAuth1Params oAuth1Params, Normalizer normalize) throws MalformedRequest {
        this.verify(parsedRequest, oAuth1Params);
        return new OAuth1Request(UrlDecoder$.MODULE$.apply(oAuth1Params.token()), UrlDecoder$.MODULE$.apply(oAuth1Params.consumerKey()), UrlDecoder$.MODULE$.apply(oAuth1Params.nonce()), oAuth1Params.timestampSecs(), oAuth1Params.signature(), oAuth1Params.signatureMethod(), oAuth1Params.version(), parsedRequest, normalize.apply(parsedRequest, oAuth1Params));
    }

    public Option unapply(OAuth1Request x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)x$0.token(), (Object)x$0.consumerKey(), (Object)x$0.nonce(), (Object)BoxesRunTime.boxToLong((long)x$0.timestampSecs()), (Object)x$0.signature(), (Object)x$0.signatureMethod(), (Object)x$0.version(), (Object)x$0.parsedRequest(), (Object)x$0.normalizedRequest()));
    }

    public OAuth1Request apply(String token, String consumerKey, String nonce, long timestampSecs, String signature, String signatureMethod, String version, ParsedRequest parsedRequest, String normalizedRequest) {
        return new OAuth1Request(token, consumerKey, nonce, timestampSecs, signature, signatureMethod, version, parsedRequest, normalizedRequest);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private OAuth1Request$() {
        MODULE$ = this;
        this.NO_VALUE_FOR = "no value for ";
        this.SCHEME = "scheme";
        this.HOST = "host";
        this.PORT = "port";
        this.VERB = "verb";
        this.PATH = "path";
        this.UNSUPPORTED_METHOD = "unsupported signature method: ";
        this.UNSUPPORTED_VERSION = "unsupported oauth version: ";
        this.MALFORMED_TOKEN = "malformed oauth token: ";
        this.MaxTokenLength = 50;
    }
}

