/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.twitter.joauth.Base64Util$;
import com.twitter.joauth.NonceValidator;
import com.twitter.joauth.OAuth1Request;
import com.twitter.joauth.Signer;
import com.twitter.joauth.UrlDecoder$;
import com.twitter.joauth.Verifier;
import com.twitter.joauth.VerifierResult;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u0013\t\u00012\u000b^1oI\u0006\u0014HMV3sS\u001aLWM\u001d\u0006\u0003\u0007\u0011\taA[8bkRD'BA\u0003\u0007\u0003\u001d!x/\u001b;uKJT\u0011aB\u0001\u0004G>l7\u0001A\n\u0005\u0001)\u0011b\u0003\u0005\u0002\f!5\tAB\u0003\u0002\u000e\u001d\u0005!A.\u00198h\u0015\u0005y\u0011\u0001\u00026bm\u0006L!!\u0005\u0007\u0003\r=\u0013'.Z2u!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u0005WKJLg-[3s!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011u\u0001!\u0011!Q\u0001\ny\taa]5h]\u0016\u0014\bCA\n \u0013\t\u0001#A\u0001\u0004TS\u001etWM\u001d\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u00051R.\u0019=DY>\u001c7N\u00127pCR\f\u0005.Z1e\u001b&t7\u000f\u0005\u0002\u0018I%\u0011Q\u0005\u0007\u0002\u0004\u0013:$\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002/5\f\u0007p\u00117pG.4En\\1u\u0005\u0016D\u0017N\u001c3NS:\u001c\b\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u001bY\fG.\u001b3bi\u0016tuN\\2f!\t\u00192&\u0003\u0002-\u0005\tqaj\u001c8dKZ\u000bG.\u001b3bi>\u0014\b\"\u0002\u0018\u0001\t\u0003y\u0013A\u0002\u001fj]&$h\bF\u00031cI\u001aD\u0007\u0005\u0002\u0014\u0001!)Q$\fa\u0001=!)!%\fa\u0001G!)q%\fa\u0001G!)\u0011&\fa\u0001U!9a\u0007\u0001b\u0001\n\u00039\u0014AF7bq\u000ecwnY6GY>\fG/\u00115fC\u0012\u001cVmY:\u0016\u0003a\u0002\"aF\u001d\n\u0005iB\"\u0001\u0002'p]\u001eDa\u0001\u0010\u0001!\u0002\u0013A\u0014aF7bq\u000ecwnY6GY>\fG/\u00115fC\u0012\u001cVmY:!\u0011\u001dq\u0004A1A\u0005\u0002]\nq#\\1y\u00072|7m\u001b$m_\u0006$()\u001a5j]\u0012\u001cVmY:\t\r\u0001\u0003\u0001\u0015!\u00039\u0003ai\u0017\r_\"m_\u000e\\g\t\\8bi\n+\u0007.\u001b8e'\u0016\u001c7\u000f\t\u0005\u0006\u0005\u0002!\teQ\u0001\u0006CB\u0004H.\u001f\u000b\u0005\t\u001ecU\u000b\u0005\u0002\u0014\u000b&\u0011aI\u0001\u0002\u000f-\u0016\u0014\u0018NZ5feJ+7/\u001e7u\u0011\u0015A\u0015\t1\u0001J\u0003\u001d\u0011X-];fgR\u0004\"a\u0005&\n\u0005-\u0013!!D(BkRD\u0017GU3rk\u0016\u001cH\u000fC\u0003N\u0003\u0002\u0007a*A\u0006u_.,gnU3de\u0016$\bCA(S\u001d\t9\u0002+\u0003\u0002R1\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\t\u0006\u0004C\u0003W\u0003\u0002\u0007a*\u0001\bd_:\u001cX/\\3s'\u0016\u001c'/\u001a;\t\u000ba\u0003A\u0011A-\u0002+Y\fG.\u001b3bi\u0016$\u0016.\\3ti\u0006l\u0007oU3dgR\u0011!,\u0018\t\u0003/mK!\u0001\u0018\r\u0003\u000f\t{w\u000e\\3b]\")al\u0016a\u0001q\u0005iA/[7fgR\fW\u000e]*fGNDQ\u0001\u0019\u0001\u0005\u0002\u0005\f\u0011C^1mS\u0012\fG/Z*jO:\fG/\u001e:f)\u0011Q&m\u00193\t\u000b!{\u0006\u0019A%\t\u000b5{\u0006\u0019\u0001(\t\u000bY{\u0006\u0019\u0001(")
public class StandardVerifier
implements Verifier,
ScalaObject {
    private final Signer signer;
    private final int maxClockFloatAheadMins;
    private final int maxClockFloatBehindMins;
    private final NonceValidator validateNonce;
    private final long maxClockFloatAheadSecs;
    private final long maxClockFloatBehindSecs;

    public long maxClockFloatAheadSecs() {
        return this.maxClockFloatAheadSecs;
    }

    public long maxClockFloatBehindSecs() {
        return this.maxClockFloatBehindSecs;
    }

    public VerifierResult apply(OAuth1Request request, String tokenSecret, String consumerSecret) {
        return BoxesRunTime.unboxToBoolean((Object)this.validateNonce.apply(request.nonce())) ? (this.validateTimestampSecs(request.timestampSecs()) ? (this.validateSignature(request, tokenSecret, consumerSecret) ? VerifierResult.OK : VerifierResult.BAD_SIGNATURE) : VerifierResult.BAD_TIMESTAMP) : VerifierResult.BAD_NONCE;
    }

    public boolean validateTimestampSecs(long timestampSecs) {
        long nowSecs = System.currentTimeMillis() / 1000L;
        return !(this.maxClockFloatBehindMins >= 0 && timestampSecs < nowSecs - this.maxClockFloatBehindSecs() || this.maxClockFloatAheadMins >= 0 && timestampSecs > nowSecs + this.maxClockFloatAheadSecs());
    }

    public boolean validateSignature(OAuth1Request request, String tokenSecret, String consumerSecret) {
        return Base64Util$.MODULE$.equals(UrlDecoder$.MODULE$.apply(request.signature()).trim(), this.signer.getBytes(request.normalizedRequest(), tokenSecret, consumerSecret));
    }

    public StandardVerifier(Signer signer, int maxClockFloatAheadMins, int maxClockFloatBehindMins, NonceValidator validateNonce) {
        this.signer = signer;
        this.maxClockFloatAheadMins = maxClockFloatAheadMins;
        this.maxClockFloatBehindMins = maxClockFloatBehindMins;
        this.validateNonce = validateNonce;
        this.maxClockFloatAheadSecs = (long)maxClockFloatAheadMins * 60L;
        this.maxClockFloatBehindSecs = (long)maxClockFloatBehindMins * 60L;
    }
}

