/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSTRtree {
    protected AbstractNode root;
    private boolean built = false;
    private ArrayList itemBoundables = new ArrayList();
    private int nodeCapacity;

    public AbstractSTRtree(int nodeCapacity) {
        Assert.isTrue(nodeCapacity > 1, "Node capacity must be greater than 1");
        this.nodeCapacity = nodeCapacity;
    }

    public void build() {
        Assert.isTrue(!this.built);
        this.root = this.itemBoundables.isEmpty() ? this.createNode(0) : this.createHigherLevels(this.itemBoundables, -1);
        this.built = true;
    }

    protected abstract AbstractNode createNode(int var1);

    protected List createParentBoundables(List childBoundables, int newLevel) {
        Assert.isTrue(!childBoundables.isEmpty());
        ArrayList<AbstractNode> parentBoundables = new ArrayList<AbstractNode>();
        parentBoundables.add(this.createNode(newLevel));
        ArrayList sortedChildBoundables = new ArrayList(childBoundables);
        Collections.sort(sortedChildBoundables, this.getComparator());
        Iterator i = sortedChildBoundables.iterator();
        while (i.hasNext()) {
            Boundable childBoundable = (Boundable)i.next();
            if (this.lastNode(parentBoundables).getChildBoundables().size() == this.getNodeCapacity()) {
                parentBoundables.add(this.createNode(newLevel));
            }
            this.lastNode(parentBoundables).addChildBoundable(childBoundable);
        }
        return parentBoundables;
    }

    protected AbstractNode lastNode(List nodes) {
        return (AbstractNode)nodes.get(nodes.size() - 1);
    }

    protected int compareDoubles(double a, double b) {
        return a > b ? 1 : (a < b ? -1 : 0);
    }

    private AbstractNode createHigherLevels(List boundablesOfALevel, int level) {
        Assert.isTrue(!boundablesOfALevel.isEmpty());
        List parentBoundables = this.createParentBoundables(boundablesOfALevel, level + 1);
        if (parentBoundables.size() == 1) {
            return (AbstractNode)parentBoundables.get(0);
        }
        return this.createHigherLevels(parentBoundables, level + 1);
    }

    protected AbstractNode getRoot() {
        return this.root;
    }

    public int getNodeCapacity() {
        return this.nodeCapacity;
    }

    protected int size() {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            return 0;
        }
        return this.size(this.root);
    }

    protected int size(AbstractNode node) {
        int size = 0;
        Iterator i = node.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable childBoundable = (Boundable)i.next();
            if (childBoundable instanceof AbstractNode) {
                size += this.size((AbstractNode)childBoundable);
                continue;
            }
            if (!(childBoundable instanceof ItemBoundable)) continue;
            ++size;
        }
        return size;
    }

    protected int depth() {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            return 0;
        }
        return this.depth(this.root);
    }

    protected int depth(AbstractNode node) {
        int maxChildDepth = 0;
        Iterator i = node.getChildBoundables().iterator();
        while (i.hasNext()) {
            int childDepth;
            Boundable childBoundable = (Boundable)i.next();
            if (!(childBoundable instanceof AbstractNode) || (childDepth = this.depth((AbstractNode)childBoundable)) <= maxChildDepth) continue;
            maxChildDepth = childDepth;
        }
        return maxChildDepth + 1;
    }

    protected void insert(Object bounds, Object item) {
        Assert.isTrue(!this.built, "Cannot insert items into an STR packed R-tree after it has been built.");
        this.itemBoundables.add(new ItemBoundable(bounds, item));
    }

    protected List query(Object searchBounds) {
        if (!this.built) {
            this.build();
        }
        ArrayList matches = new ArrayList();
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue(this.root.getBounds() == null);
            return matches;
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), searchBounds)) {
            this.query(searchBounds, this.root, matches);
        }
        return matches;
    }

    protected void query(Object searchBounds, ItemVisitor visitor) {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue(this.root.getBounds() == null);
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), searchBounds)) {
            this.query(searchBounds, this.root, visitor);
        }
    }

    protected abstract IntersectsOp getIntersectsOp();

    private void query(Object searchBounds, AbstractNode node, List matches) {
        Iterator i = node.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable childBoundable = (Boundable)i.next();
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) continue;
            if (childBoundable instanceof AbstractNode) {
                this.query(searchBounds, (AbstractNode)childBoundable, matches);
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                matches.add(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    private void query(Object searchBounds, AbstractNode node, ItemVisitor visitor) {
        Iterator i = node.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable childBoundable = (Boundable)i.next();
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) continue;
            if (childBoundable instanceof AbstractNode) {
                this.query(searchBounds, (AbstractNode)childBoundable, visitor);
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                visitor.visitItem(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    protected boolean remove(Object searchBounds, Object item) {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue(this.root.getBounds() == null);
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), searchBounds)) {
            return this.remove(searchBounds, this.root, item);
        }
        return false;
    }

    private boolean removeItem(AbstractNode node, Object item) {
        Boundable childToRemove = null;
        Iterator i = node.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable childBoundable = (Boundable)i.next();
            if (!(childBoundable instanceof ItemBoundable) || ((ItemBoundable)childBoundable).getItem() != item) continue;
            childToRemove = childBoundable;
        }
        if (childToRemove != null) {
            node.getChildBoundables().remove(childToRemove);
            return true;
        }
        return false;
    }

    private boolean remove(Object searchBounds, AbstractNode node, Object item) {
        boolean found = this.removeItem(node, item);
        if (found) {
            return true;
        }
        AbstractNode childToPrune = null;
        Iterator i = node.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable childBoundable = (Boundable)i.next();
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds) || !(childBoundable instanceof AbstractNode) || !(found = this.remove(searchBounds, (AbstractNode)childBoundable, item))) continue;
            childToPrune = (AbstractNode)childBoundable;
            break;
        }
        if (childToPrune != null && childToPrune.getChildBoundables().isEmpty()) {
            node.getChildBoundables().remove(childToPrune);
        }
        return found;
    }

    protected List boundablesAtLevel(int level) {
        ArrayList boundables = new ArrayList();
        this.boundablesAtLevel(level, this.root, boundables);
        return boundables;
    }

    private void boundablesAtLevel(int level, AbstractNode top, Collection boundables) {
        Assert.isTrue(level > -2);
        if (top.getLevel() == level) {
            boundables.add(top);
            return;
        }
        Iterator i = top.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable boundable = (Boundable)i.next();
            if (boundable instanceof AbstractNode) {
                this.boundablesAtLevel(level, (AbstractNode)boundable, boundables);
                continue;
            }
            Assert.isTrue(boundable instanceof ItemBoundable);
            if (level != -1) continue;
            boundables.add(boundable);
        }
    }

    protected abstract Comparator getComparator();

    protected static interface IntersectsOp {
        public boolean intersects(Object var1, Object var2);
    }
}

