/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.docs;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.api.Download;
import com.webcohesion.enunciate.api.DownloadFile;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.api.datatype.Namespace;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.ResourceApi;
import com.webcohesion.enunciate.api.services.ServiceApi;
import com.webcohesion.enunciate.api.services.ServiceGroup;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ClientLibraryArtifact;
import com.webcohesion.enunciate.artifacts.ClientLibraryJavaArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryAwareModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.DocumentationProviderModule;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.modules.docs.ExplicitDownloadConfig;
import com.webcohesion.enunciate.modules.docs.SpecifiedArtifact;
import com.webcohesion.enunciate.util.freemarker.FileDirective;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class DocsModule
extends BasicGeneratingModule
implements ApiRegistryAwareModule,
DocumentationProviderModule {
    private File defaultDocsDir;
    private String defaultDocsSubdir;
    private ApiRegistry apiRegistry;

    public String getName() {
        return "docs";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Arrays.asList(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                return module instanceof ApiFeatureProviderModule;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "all api feature provider modules";
            }
        });
    }

    public Collection<ExplicitDownloadConfig> getExplicitDownloads() {
        List downloads = this.config.configurationsAt("download");
        ArrayList<ExplicitDownloadConfig> downloadConfigs = new ArrayList<ExplicitDownloadConfig>(downloads.size());
        for (HierarchicalConfiguration download : downloads) {
            ExplicitDownloadConfig downloadConfig = new ExplicitDownloadConfig();
            downloadConfig.setArtifact(download.getString("[@artifact]"));
            downloadConfig.setDescription(download.getString("[@description]"));
            downloadConfig.setFile(download.getString("[@file]"));
            downloadConfig.setName(download.getString("[@name]"));
            downloadConfig.setShowLink(download.getString("[@showLink]"));
            downloadConfigs.add(downloadConfig);
        }
        return downloadConfigs;
    }

    public List<String> getAdditionalCss() {
        LinkedList<String> additionalCss = new LinkedList<String>();
        List additionalCsses = this.config.configurationsAt("additional-css");
        for (HierarchicalConfiguration additional : additionalCsses) {
            String file = additional.getString("[@file]");
            if (file == null) continue;
            additionalCss.add(file);
        }
        return additionalCss;
    }

    public File getFreemarkerTemplateFile() {
        String templatePath = this.config.getString("[@freemarkerTemplate]");
        return templatePath == null ? null : this.resolveFile(templatePath);
    }

    protected URL getDocsTemplateURL() throws MalformedURLException {
        File templateFile = this.getFreemarkerTemplateFile();
        if (templateFile != null && !templateFile.exists()) {
            this.warn("Unable to use freemarker template at %s: file doesn't exist!", new Object[]{templateFile});
            templateFile = null;
        }
        if (templateFile != null) {
            return templateFile.toURI().toURL();
        }
        return DocsModule.class.getResource("docs.fmt");
    }

    public String getCss() {
        return this.config.getString("[@css]");
    }

    public File getBase() {
        String base = this.config.getString("[@base]");
        return base == null ? null : this.resolveFile(base);
    }

    public File getDocsDir() {
        String docsDir = this.config.getString("[@docsDir]");
        return docsDir != null ? this.resolveFile(docsDir) : (this.defaultDocsDir != null ? this.defaultDocsDir : new File(this.enunciate.getBuildDir(), this.getName()));
    }

    public String getDocsSubdir() {
        return this.config.getString("[@docsSubdir]", this.defaultDocsSubdir);
    }

    public boolean isDisableResourceLinks() {
        return this.config.getBoolean("[@disableResourceLinks]", false);
    }

    public void setDefaultDocsDir(File docsDir) {
        this.defaultDocsDir = docsDir;
    }

    public void setDefaultDocsSubdir(String defaultDocsSubdir) {
        this.defaultDocsSubdir = defaultDocsSubdir;
    }

    public String getIndexPageName() {
        return this.config.getString("[@indexPageName]", "index.html");
    }

    public boolean isDisableRestMountpoint() {
        return this.config.getBoolean("[@disableRestMountpoint]", false);
    }

    public String getFavicon() {
        return this.config.getString("[@faviconUri]", null);
    }

    public void setApiRegistry(ApiRegistry registry) {
        this.apiRegistry = registry;
    }

    public void call(EnunciateContext context) {
        try {
            File docsDir = this.getDocsDir();
            String subDir = this.getDocsSubdir();
            if (subDir != null) {
                docsDir = new File(docsDir, subDir);
            }
            if (!this.isUpToDateWithSources(docsDir)) {
                String title;
                String copyright;
                List resourceApis = this.apiRegistry.getResourceApis();
                TreeSet<Artifact> documentationArtifacts = this.findDocumentationArtifacts();
                if (this.apiRegistry.getSyntaxes().isEmpty() && this.apiRegistry.getServiceApis().isEmpty() && resourceApis.isEmpty() && documentationArtifacts.isEmpty()) {
                    this.warn("No documentation generated: there are no data types, services, or resources to document.", new Object[0]);
                    return;
                }
                docsDir.mkdirs();
                HashMap<String, Object> model = new HashMap<String, Object>();
                String intro = this.enunciate.getConfiguration().readDescription(context);
                if (intro != null) {
                    model.put("apiDoc", intro);
                }
                if ((copyright = this.enunciate.getConfiguration().getCopyright()) != null) {
                    model.put("copyright", copyright);
                }
                model.put("title", (title = this.enunciate.getConfiguration().getTitle()) == null ? "Web Service API" : title);
                String cssPath = this.buildBase(docsDir);
                if (cssPath != null) {
                    model.put("cssFile", cssPath);
                }
                model.put("file", new FileDirective(docsDir, this.enunciate.getLogger()));
                model.put("apiRelativePath", this.getRelativePathToRootDir());
                model.put("includeApplicationPath", this.isIncludeApplicationPath());
                model.put("favicon", this.getFavicon());
                for (Syntax syntax : this.apiRegistry.getSyntaxes()) {
                    for (Namespace namespace : syntax.getNamespaces()) {
                        if (namespace.getSchemaFile() == null) continue;
                        namespace.getSchemaFile().writeTo(docsDir);
                    }
                }
                model.put("data", this.apiRegistry.getSyntaxes());
                for (ResourceApi resourceApi : resourceApis) {
                    if (resourceApi.getWadlFile() == null) continue;
                    resourceApi.getWadlFile().writeTo(docsDir);
                }
                model.put("resourceApis", resourceApis);
                InterfaceDescriptionFile swaggerUI = this.apiRegistry.getSwaggerUI();
                if (swaggerUI != null) {
                    swaggerUI.writeTo(docsDir);
                    model.put("swaggerUI", swaggerUI);
                }
                for (ServiceApi serviceApi : this.apiRegistry.getServiceApis()) {
                    for (ServiceGroup serviceGroup : serviceApi.getServiceGroups()) {
                        if (serviceGroup.getWsdlFile() == null) continue;
                        serviceGroup.getWsdlFile().writeTo(docsDir);
                    }
                }
                model.put("serviceApis", this.apiRegistry.getServiceApis());
                model.put("downloads", this.copyDocumentationArtifacts(documentationArtifacts, docsDir));
                model.put("indexPageName", this.getIndexPageName());
                model.put("disableMountpoint", this.isDisableRestMountpoint());
                model.put("additionalCssFiles", this.getAdditionalCss());
                model.put("disableResourceLinks", this.isDisableResourceLinks());
                this.processTemplate(this.getDocsTemplateURL(), model);
            } else {
                this.info("Skipping documentation source generation as everything appears up-to-date...", new Object[0]);
            }
            this.enunciate.addArtifact((Artifact)new FileArtifact(this.getName(), "docs", docsDir));
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    private boolean isIncludeApplicationPath() {
        return this.config.getBoolean("[@includeApplicationPath]", false);
    }

    public void processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.debug("Processing template %s.", new Object[]{templateURL});
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler(new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                throw templateException;
            }
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setURLEscapingCharset("UTF-8");
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter unhandledOutput = new StringWriter();
        template.process(model, (Writer)unhandledOutput);
        this.debug("Freemarker processing output:\n%s", new Object[]{unhandledOutput});
    }

    protected String buildBase(File outputDir) throws IOException {
        File baseFile = this.getBase();
        if (baseFile == null) {
            InputStream discoveredBase = DocsModule.class.getResourceAsStream("/META-INF/enunciate/docs-base.zip");
            if (discoveredBase == null) {
                this.debug("Default base to be used for documentation base.", new Object[0]);
                this.enunciate.unzip(this.loadDefaultBase(), outputDir);
                String configuredCss = this.getCss();
                URL discoveredCss = DocsModule.class.getResource("/META-INF/enunciate/css/style.css");
                if (discoveredCss != null) {
                    this.enunciate.copyResource(discoveredCss, new File(new File(outputDir, "css"), "style.css"));
                } else if (configuredCss != null) {
                    try {
                        if (URI.create(configuredCss).isAbsolute()) {
                            return configuredCss;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    this.enunciate.copyFile(this.resolveFile(configuredCss), new File(new File(outputDir, "css"), "style.css"));
                }
                return "css/style.css";
            }
            this.debug("Discovered documentation base at /META-INF/enunciate/docs-base.zip", new Object[0]);
            this.enunciate.unzip(discoveredBase, outputDir);
            return null;
        }
        if (baseFile.isDirectory()) {
            this.debug("Directory %s to be used as the documentation base.", new Object[]{baseFile});
            this.enunciate.copyDir(baseFile, outputDir, new File[0]);
            return null;
        }
        this.debug("Zip file %s to be extracted as the documentation base.", new Object[]{baseFile});
        this.enunciate.unzip((InputStream)new FileInputStream(baseFile), outputDir);
        return null;
    }

    protected List<Download> copyDocumentationArtifacts(Set<Artifact> artifacts, File outputDir) throws IOException {
        ArrayList<Download> downloads = new ArrayList<Download>();
        for (Artifact artifact : artifacts) {
            this.debug("Exporting %s to directory %s.", new Object[]{artifact.getId(), outputDir});
            artifact.exportTo(outputDir, this.enunciate);
            if (artifact instanceof SpecifiedArtifact && !((SpecifiedArtifact)artifact).isShowLink()) continue;
            Download download = new Download();
            download.setSlug("artifact_" + artifact.getId().replace('.', '_'));
            download.setName(artifact.getName());
            download.setDescription(artifact.getDescription());
            download.setCreated(artifact.getCreated());
            if (artifact instanceof ClientLibraryJavaArtifact) {
                download.setGroupId(((ClientLibraryJavaArtifact)artifact).getGroupId());
                download.setArtifactId(((ClientLibraryJavaArtifact)artifact).getArtifactId());
                download.setVersion(((ClientLibraryJavaArtifact)artifact).getVersion());
            }
            List<Artifact> childArtifacts = artifact instanceof ClientLibraryArtifact ? ((ClientLibraryArtifact)artifact).getArtifacts() : (artifact instanceof SpecifiedArtifact ? Arrays.asList(((SpecifiedArtifact)artifact).getFile()) : Arrays.asList(artifact));
            ArrayList<DownloadFile> downloadFiles = new ArrayList<DownloadFile>();
            for (Artifact childArtifact : childArtifacts) {
                DownloadFile downloadFile = new DownloadFile();
                downloadFile.setDescription(childArtifact.getDescription());
                downloadFile.setName(childArtifact.getName());
                downloadFile.setSize(this.getDisplaySize(childArtifact.getSize()));
                downloadFiles.add(downloadFile);
            }
            download.setFiles(downloadFiles);
            downloads.add(download);
        }
        return downloads;
    }

    private TreeSet<Artifact> findDocumentationArtifacts() {
        HashSet<String> explicitArtifacts = new HashSet<String>();
        TreeSet<Artifact> artifacts = new TreeSet<Artifact>();
        for (ExplicitDownloadConfig download : this.getExplicitDownloads()) {
            if (download.getArtifact() != null) {
                explicitArtifacts.add(download.getArtifact());
                continue;
            }
            if (download.getFile() == null) continue;
            File downloadFile = this.resolveFile(download.getFile());
            this.debug("File %s to be added as an extra download.", new Object[]{downloadFile.getAbsolutePath()});
            SpecifiedArtifact artifact = new SpecifiedArtifact(this.getName(), downloadFile.getName(), downloadFile);
            if (download.getName() != null) {
                artifact.setName(download.getName());
            }
            if (download.getDescription() != null) {
                artifact.setDescription(download.getDescription());
            }
            artifact.setShowLink(!"false".equals(download.getShowLink()));
            artifacts.add((Artifact)artifact);
        }
        for (Artifact artifact : this.enunciate.getArtifacts()) {
            if (!artifact.isPublic() && !explicitArtifacts.contains(artifact.getId())) continue;
            artifacts.add(artifact);
            this.debug("Artifact %s to be added as an extra download.", new Object[]{artifact.getId()});
            explicitArtifacts.remove(artifact.getId());
        }
        if (explicitArtifacts.size() > 0) {
            for (String artifactId : explicitArtifacts) {
                this.warn("WARNING: Unknown artifact '%s'.  Will not be available for download.", new Object[]{artifactId});
            }
        }
        return artifacts;
    }

    public String getDisplaySize(long sizeInBytes) {
        String units = "bytes";
        float unitSize = 1.0f;
        if (sizeInBytes / 1024L > 0L) {
            units = "K";
            unitSize = 1024.0f;
        }
        if (sizeInBytes / 0x100000L > 0L) {
            units = "M";
            unitSize = 1048576.0f;
        }
        if (sizeInBytes / 0x40000000L > 0L) {
            units = "G";
            unitSize = 1.0737418E9f;
        }
        return String.format("%.2f%s", Float.valueOf((float)sizeInBytes / unitSize), units);
    }

    protected String getRelativePathToRootDir() {
        String relativePath = "./";
        String docsSubdir = this.getDocsSubdir();
        if (docsSubdir != null) {
            StringBuilder builder = new StringBuilder();
            StringTokenizer pathTokens = new StringTokenizer(docsSubdir.replace(File.separatorChar, '/'), "/");
            if (pathTokens.hasMoreTokens()) {
                while (pathTokens.hasMoreTokens()) {
                    builder.append("../");
                    pathTokens.nextToken();
                }
                relativePath = builder.toString();
            }
        }
        return this.config.getString("[@apiRelativePath]", relativePath);
    }

    protected InputStream loadDefaultBase() {
        return DocsModule.class.getResourceAsStream("/docs.base.zip");
    }
}

