/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.gwt_json_overlay;

import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import com.webcohesion.enunciate.modules.gwt_json_overlay.MergedJsonContext;
import com.webcohesion.enunciate.util.HasClientConvertibleType;
import freemarker.template.TemplateModelException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class ClientClassnameForMethod
extends com.webcohesion.enunciate.util.freemarker.ClientClassnameForMethod {
    private final Map<String, String> classConversions = new HashMap<String, String>();
    private final MergedJsonContext jsonContext;

    public ClientClassnameForMethod(Map<String, String> conversions, MergedJsonContext context) {
        super(conversions, context.getContext());
        this.jsonContext = context;
        this.classConversions.put(BigDecimal.class.getName(), String.class.getName());
        this.classConversions.put(BigInteger.class.getName(), String.class.getName());
        this.classConversions.put(Date.class.getName(), Long.class.getName());
        this.classConversions.put(Timestamp.class.getName(), Long.class.getName());
        this.classConversions.put(Calendar.class.getName(), Long.class.getName());
        this.classConversions.put(DataHandler.class.getName(), String.class.getName());
        this.classConversions.put(QName.class.getName(), String.class.getName());
        this.classConversions.put(URI.class.getName(), String.class.getName());
        this.classConversions.put(UUID.class.getName(), String.class.getName());
        this.classConversions.put(XMLGregorianCalendar.class.getName(), "double");
        this.classConversions.put(JAXBElement.class.getName(), "com.google.gwt.core.client.JavaScriptObject");
    }

    public String convertUnwrappedObject(Object unwrapped) throws TemplateModelException {
        if (unwrapped instanceof Entity) {
            List mediaTypes = ((Entity)unwrapped).getMediaTypes();
            for (MediaTypeDescriptor mediaType : mediaTypes) {
                if (!this.jsonContext.getLabel().equals(mediaType.getSyntax())) continue;
                DataTypeReference dataType = mediaType.getDataType();
                return super.convertUnwrappedObject((Object)this.jsonContext.findType(dataType));
            }
            return "com.google.gwt.core.client.JavaScriptObject";
        }
        return super.convertUnwrappedObject(unwrapped);
    }

    public String convert(HasClientConvertibleType element) throws TemplateModelException {
        TypeMirror adaptingType = this.jsonContext.findAdaptingType(element);
        if (adaptingType != null) {
            return this.convert(adaptingType);
        }
        if (element instanceof Element && ((Element)element).getAnnotation(XmlQNameEnumRef.class) != null) {
            return "String";
        }
        return super.convert(element);
    }

    public String convert(TypeElement declaration) throws TemplateModelException {
        DecoratedTypeMirror superType;
        if (this.classConversions.containsKey(declaration.getQualifiedName().toString())) {
            return this.classConversions.get(declaration.getQualifiedName().toString());
        }
        if (ElementUtils.isCollection((TypeElement)declaration)) {
            return "com.google.gwt.core.client.JsArray";
        }
        TypeMirror adaptingType = this.jsonContext.findAdaptingType(declaration);
        if (adaptingType != null) {
            return this.convert(adaptingType);
        }
        if (declaration.getKind() == ElementKind.CLASS && (superType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)declaration.getSuperclass(), (ProcessingEnvironment)this.context.getProcessingEnvironment())) != null && superType.isInstanceOf(JAXBElement.class.getName())) {
            return this.convert((TypeMirror)superType);
        }
        String convertedPackage = this.convertPackage(this.context.getProcessingEnvironment().getElementUtils().getPackageOf(declaration));
        ClientName specifiedName = declaration.getAnnotation(ClientName.class);
        String simpleName = specifiedName == null ? declaration.getSimpleName().toString() : specifiedName.value();
        return convertedPackage + this.getPackageSeparator() + simpleName;
    }

    public String convert(TypeMirror typeMirror) throws TemplateModelException {
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror, (ProcessingEnvironment)this.context.getProcessingEnvironment());
        if (decorated.isArray()) {
            DecoratedTypeMirror componentType = (DecoratedTypeMirror)((ArrayType)decorated).getComponentType();
            if (componentType.isPrimitive()) {
                switch (componentType.getKind()) {
                    case BOOLEAN: {
                        return "com.google.gwt.core.client.JsArrayBoolean";
                    }
                    case BYTE: {
                        return "java.lang.String";
                    }
                    case CHAR: 
                    case INT: 
                    case SHORT: {
                        return "com.google.gwt.core.client.JsArrayInteger";
                    }
                    case DOUBLE: 
                    case FLOAT: 
                    case LONG: {
                        return "com.google.gwt.core.client.JsArrayNumber";
                    }
                }
                return "com.google.gwt.core.client.JsArray";
            }
            if (componentType.isInstanceOf(String.class.getName())) {
                return "com.google.gwt.core.client.JsArrayString";
            }
            return "com.google.gwt.core.client.JsArray<" + this.convert((TypeMirror)componentType) + ">";
        }
        if (decorated.isCollection()) {
            List typeArgs = ((DecoratedDeclaredType)decorated).getTypeArguments();
            if (typeArgs != null && typeArgs.size() == 1) {
                DecoratedTypeMirror componentType = (DecoratedTypeMirror)typeArgs.iterator().next();
                if (componentType.isInstanceOf(String.class.getName())) {
                    return "com.google.gwt.core.client.JsArrayString";
                }
                if (componentType.isInstanceOf(Boolean.class.getName())) {
                    return "com.google.gwt.core.client.JsArrayBoolean";
                }
                if (componentType.isInstanceOf(Integer.class.getName()) || componentType.isInstanceOf(Character.class.getName()) || componentType.isInstanceOf(Short.class.getName())) {
                    return "com.google.gwt.core.client.JsArrayInteger";
                }
                if (componentType.isInstanceOf(Double.class.getName()) || componentType.isInstanceOf(Float.class.getName()) || componentType.isInstanceOf(Long.class.getName())) {
                    return "com.google.gwt.core.client.JsArrayNumber";
                }
                return "com.google.gwt.core.client.JsArray<" + this.convert((TypeMirror)componentType) + ">";
            }
            return "com.google.gwt.core.client.JsArray";
        }
        if (decorated.isDeclared()) {
            DeclaredType declaredType = (DeclaredType)decorated;
            String fqn = ((TypeElement)declaredType.asElement()).getQualifiedName().toString();
            if (this.classConversions.containsKey(fqn)) {
                return this.classConversions.get(fqn);
            }
        } else if (decorated.isPrimitive() && decorated.getKind() == TypeKind.LONG) {
            return Long.class.getName();
        }
        return super.convert(typeMirror);
    }
}

