/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.gwt_json_overlay;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ArtifactType;
import com.webcohesion.enunciate.artifacts.ClientLibraryJavaArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.ProjectExtensionModule;
import com.webcohesion.enunciate.modules.gwt_json_overlay.ClientClassnameForMethod;
import com.webcohesion.enunciate.modules.gwt_json_overlay.GWTJSONOverlayObjectWrapper;
import com.webcohesion.enunciate.modules.gwt_json_overlay.IsAccessorOfTypeLongMethod;
import com.webcohesion.enunciate.modules.gwt_json_overlay.MergedJsonContext;
import com.webcohesion.enunciate.modules.gwt_json_overlay.SimpleNameForMethod;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.JacksonModule;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.util.JacksonCodeErrors;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import com.webcohesion.enunciate.modules.jackson1.Jackson1Module;
import com.webcohesion.enunciate.modules.jackson1.model.util.Jackson1CodeErrors;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsModule;
import com.webcohesion.enunciate.util.AntPatternMatcher;
import com.webcohesion.enunciate.util.freemarker.ClientPackageForMethod;
import com.webcohesion.enunciate.util.freemarker.FileDirective;
import com.webcohesion.enunciate.util.freemarker.IsFacetExcludedMethod;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class GWTJSONOverlayModule
extends BasicGeneratingModule
implements ApiFeatureProviderModule,
ProjectExtensionModule {
    private static final String LIRBARY_DESCRIPTION_PROPERTY = "com.webcohesion.enunciate.modules.java_xml_client.EnunciateJavaJSONClientModule#LIRBARY_DESCRIPTION_PROPERTY";
    JacksonModule jacksonModule;
    Jackson1Module jackson1Module;
    JaxrsModule jaxrsModule;

    public String getName() {
        return "gwt-json-overlay";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Arrays.asList(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                if (module instanceof JacksonModule) {
                    GWTJSONOverlayModule.this.jacksonModule = (JacksonModule)module;
                    return true;
                }
                if (module instanceof Jackson1Module) {
                    GWTJSONOverlayModule.this.jackson1Module = (Jackson1Module)module;
                    return true;
                }
                if (module instanceof JaxrsModule) {
                    GWTJSONOverlayModule.this.jaxrsModule = (JaxrsModule)module;
                    return true;
                }
                return module instanceof ApiRegistryProviderModule;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "optional jackson, optional jackson1, optional jaxrs";
            }
        });
    }

    public void call(EnunciateContext context) {
        if ((this.jacksonModule == null || this.jacksonModule.getJacksonContext() == null || this.jacksonModule.getJacksonContext().getTypeDefinitions().isEmpty()) && (this.jackson1Module == null || this.jackson1Module.getJacksonContext() == null || this.jackson1Module.getJacksonContext().getTypeDefinitions().isEmpty())) {
            this.info("No Jackson JSON data types: GWT JSON overlays will be generated.", new Object[0]);
            return;
        }
        this.detectAccessorNamingErrors();
        File sourceDir = this.generateClientSources();
        this.packageArtifacts(sourceDir);
    }

    protected void detectAccessorNamingErrors() {
        List namingConflicts;
        if (this.jacksonModule != null && (namingConflicts = JacksonCodeErrors.findConflictingAccessorNamingErrors((EnunciateJacksonContext)this.jacksonModule.getJacksonContext())) != null && !namingConflicts.isEmpty()) {
            this.error("Jackson naming conflicts have been found:", new Object[0]);
            for (String namingConflict : namingConflicts) {
                this.error(namingConflict, new Object[0]);
            }
            this.error("These naming conflicts are often between the field and it's associated property, in which case you need to use one or both of the following strategies to avoid the conflicts:", new Object[0]);
            this.error("1. Explicitly exclude one or the other.", new Object[0]);
            this.error("2. Put the annotations on the property instead of the field.", new Object[0]);
            throw new EnunciateException("Jackson naming conflicts detected.");
        }
        if (this.jackson1Module != null && (namingConflicts = Jackson1CodeErrors.findConflictingAccessorNamingErrors((EnunciateJackson1Context)this.jackson1Module.getJacksonContext())) != null && !namingConflicts.isEmpty()) {
            this.error("Jackson naming conflicts have been found:", new Object[0]);
            for (String namingConflict : namingConflicts) {
                this.error(namingConflict, new Object[0]);
            }
            this.error("These naming conflicts are often between the field and it's associated property, in which case you need to use one or both of the following strategies to avoid the conflicts:", new Object[0]);
            this.error("1. Explicitly exclude one or the other.", new Object[0]);
            this.error("2. Put the annotations on the property instead of the field.", new Object[0]);
            throw new EnunciateException("Jackson naming conflicts detected.");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected File generateClientSources() {
        sourceDir = this.getSourceDir();
        sourceDir.mkdirs();
        model = new HashMap<String, Object>();
        conversions = this.getClientPackageConversions();
        jacksonContext = this.jacksonModule != null ? this.jacksonModule.getJacksonContext() : null;
        jackson1Context = this.jackson1Module != null ? this.jackson1Module.getJacksonContext() : null;
        jsonContext = new MergedJsonContext(jacksonContext, jackson1Context);
        classnameFor = new ClientClassnameForMethod(conversions, jsonContext);
        model.put("packageFor", new ClientPackageForMethod(conversions, this.context));
        model.put("classnameFor", (Object)classnameFor);
        model.put("simpleNameFor", (Object)new SimpleNameForMethod(classnameFor, jsonContext));
        model.put("isAccessorOfTypeLong", new IsAccessorOfTypeLongMethod());
        model.put("file", new FileDirective(sourceDir, this.enunciate.getLogger()));
        model.put("generatedCodeLicense", this.enunciate.getConfiguration().readGeneratedCodeLicenseFile());
        facetIncludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetIncludes());
        facetIncludes.addAll(this.getFacetIncludes());
        facetExcludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetExcludes());
        facetExcludes.addAll(this.getFacetExcludes());
        facetFilter = new FacetFilter(facetIncludes, facetExcludes);
        model.put("isFacetExcluded", new IsFacetExcludedMethod(facetFilter));
        matcher = new AntPatternMatcher();
        matcher.setPathSeparator(".");
        upToDate = this.isUpToDateWithSources(sourceDir);
        if (!upToDate) {
            try {
                this.debug("Generating the GWT JSON Overlay...", new Object[0]);
                if (jacksonContext != null) {
                    for (TypeDefinition typeDefinition : jacksonContext.getTypeDefinitions()) {
                        if (typeDefinition.isSimple() || !facetFilter.accept((HasFacets)typeDefinition)) continue;
                        model.put("type", typeDefinition);
                        template = typeDefinition.isEnum() != false ? this.getTemplateURL("gwt-enum-type.fmt") : this.getTemplateURL("gwt-type.fmt");
                        this.processTemplate(template, model);
                    }
                }
                if (jackson1Context == null) ** GOTO lbl61
                for (TypeDefinition typeDefinition : jackson1Context.getTypeDefinitions()) {
                    if (typeDefinition.isSimple() || !facetFilter.accept((HasFacets)typeDefinition)) continue;
                    model.put("type", typeDefinition);
                    template = typeDefinition.isEnum() != false ? this.getTemplateURL("gwt-enum-type.fmt") : this.getTemplateURL("gwt-type.fmt");
                    this.processTemplate(template, model);
                }
            }
            catch (IOException e) {
                throw new EnunciateException((Throwable)e);
            }
            catch (TemplateException e) {
                throw new EnunciateException((Throwable)e);
            }
        } else {
            this.info("Skipping generation of GWT JSON Overlay as everything appears up-to-date...", new Object[0]);
        }
lbl61:
        // 3 sources

        this.context.setProperty("com.webcohesion.enunciate.modules.java_xml_client.EnunciateJavaJSONClientModule#LIRBARY_DESCRIPTION_PROPERTY", (Object)this.readLibraryDescription(model));
        return sourceDir;
    }

    protected File getSourceDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "src");
    }

    public String processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.debug("Processing template %s.", new Object[]{templateURL});
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler(new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                throw templateException;
            }
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setObjectWrapper((ObjectWrapper)new GWTJSONOverlayObjectWrapper());
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter unhandledOutput = new StringWriter();
        template.process(model, (Writer)unhandledOutput);
        unhandledOutput.close();
        return unhandledOutput.toString();
    }

    protected File packageArtifacts(File sourceDir) {
        File packageDir = this.getPackageDir();
        packageDir.mkdirs();
        try {
            String jarName = this.getJarName();
            File jarFile = new File(packageDir, jarName);
            if (!this.isUpToDateWithSources(jarFile)) {
                boolean anyFiles = this.enunciate.zip(jarFile, new File[]{sourceDir});
                if (!anyFiles) {
                    jarFile = null;
                }
            } else {
                this.info("Skipping creation of the GWT overlay source jar as everything appears up-to-date...", new Object[0]);
            }
            ClientLibraryJavaArtifact artifactBundle = new ClientLibraryJavaArtifact(this.getName(), "gwt.json.overlay", "GWT JSON Overlay");
            artifactBundle.setGroupId(this.getGroupId());
            artifactBundle.setArtifactId(this.getArtifactId());
            artifactBundle.setVersion(this.getVersion());
            artifactBundle.setPlatform("Google Web Toolkit");
            artifactBundle.setDescription((String)this.context.getProperty(LIRBARY_DESCRIPTION_PROPERTY));
            FileArtifact sourcesJar = new FileArtifact(this.getName(), "gwt.json.overlay.sources", jarFile);
            sourcesJar.setDescription("The sources for the GWT JSON overlay.");
            sourcesJar.setPublic(false);
            sourcesJar.setArtifactType(ArtifactType.sources);
            artifactBundle.addArtifact(sourcesJar);
            this.enunciate.addArtifact((Artifact)sourcesJar);
            this.enunciate.addArtifact((Artifact)artifactBundle);
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
        return packageDir;
    }

    protected File getPackageDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "build");
    }

    protected String readLibraryDescription(Map<String, Object> model) {
        model.put("sample_resource", this.findExampleResourceMethod());
        URL res = GWTJSONOverlayModule.class.getResource("library_description.fmt");
        try {
            return this.processTemplate(res, model);
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    public Method findExampleResourceMethod() {
        Method example = null;
        List resourceGroups = this.jaxrsModule.getJaxrsContext().getResourceGroups();
        for (ResourceGroup resourceGroup : resourceGroups) {
            List resources = resourceGroup.getResources();
            for (Resource resource : resources) {
                for (Method method : resource.getMethods()) {
                    if (!this.hasXmlResponseEntity(method)) continue;
                    if (this.hasXmlRequestEntity(method)) {
                        return method;
                    }
                    example = example == null ? method : example;
                }
            }
        }
        return example;
    }

    private boolean hasXmlResponseEntity(Method method) {
        if (method.getResponseEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getResponseEntity().getMediaTypes()) {
                String syntax = mediaTypeDescriptor.getSyntax();
                if (!"JSON".equals(syntax) && !"JSON".equals(syntax)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasXmlRequestEntity(Method method) {
        if (method.getRequestEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getRequestEntity().getMediaTypes()) {
                String syntax = mediaTypeDescriptor.getSyntax();
                if (!"JSON".equals(syntax) && !"JSON".equals(syntax)) continue;
                return true;
            }
        }
        return false;
    }

    protected URL getTemplateURL(String template) {
        return GWTJSONOverlayModule.class.getResource(template);
    }

    public String getJarName() {
        return this.config.getString("[@jarName]", this.getSlug() + "-gwt-json-overlay.jar");
    }

    public Map<String, String> getClientPackageConversions() {
        List conversionElements = this.config.configurationsAt("package-conversions.convert");
        HashMap<String, String> conversions = new HashMap<String, String>();
        for (HierarchicalConfiguration conversionElement : conversionElements) {
            conversions.put(conversionElement.getString("[@from]"), conversionElement.getString("[@to]"));
        }
        return conversions;
    }

    public String getSlug() {
        return this.config.getString("[@slug]", this.enunciate.getConfiguration().getSlug());
    }

    public String getGroupId() {
        return this.config.getString("[@groupId]", null);
    }

    public String getArtifactId() {
        return this.config.getString("[@artifactId]", null);
    }

    public String getVersion() {
        return this.config.getString("[@version]", null);
    }

    public List<File> getProjectSources() {
        return Collections.emptyList();
    }

    public List<File> getProjectTestSources() {
        return Arrays.asList(this.getSourceDir());
    }

    public List<File> getProjectResourceDirectories() {
        return Collections.emptyList();
    }

    public List<File> getProjectTestResourceDirectories() {
        return Collections.emptyList();
    }

    public Set<String> getFacetIncludes() {
        List includes = this.config.getList("facets.include[@name]");
        TreeSet<String> facetIncludes = new TreeSet<String>();
        for (Object include : includes) {
            facetIncludes.add(String.valueOf(include));
        }
        return facetIncludes;
    }

    public Set<String> getFacetExcludes() {
        List excludes = this.config.getList("facets.exclude[@name]");
        TreeSet<String> facetExcludes = new TreeSet<String>();
        for (Object exclude : excludes) {
            facetExcludes.add(String.valueOf(exclude));
        }
        return facetExcludes;
    }
}

