/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson.model.types;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.webcohesion.enunciate.javac.decorations.Annotations;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.model.Accessor;
import com.webcohesion.enunciate.modules.jackson.model.adapters.Adaptable;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson.model.types.JsonTypeVisitor;
import com.webcohesion.enunciate.modules.jackson.model.types.KnownJsonType;
import com.webcohesion.enunciate.modules.jackson.model.util.MapType;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;

public class JsonTypeFactory {
    public static JsonType findSpecifiedType(Adaptable adaptable, EnunciateJacksonContext context) {
        JsonType jsonType = null;
        if (adaptable instanceof Accessor) {
            TypeMirror hint;
            TypeHint typeHint;
            Accessor accessor = (Accessor)adaptable;
            JsonFormat format = (JsonFormat)accessor.getAnnotation(JsonFormat.class);
            if (format != null) {
                switch (format.shape()) {
                    case ARRAY: {
                        return KnownJsonType.ARRAY;
                    }
                    case BOOLEAN: {
                        return KnownJsonType.BOOLEAN;
                    }
                    case NUMBER: 
                    case NUMBER_FLOAT: {
                        return KnownJsonType.NUMBER;
                    }
                    case NUMBER_INT: {
                        return KnownJsonType.WHOLE_NUMBER;
                    }
                    case OBJECT: {
                        return KnownJsonType.OBJECT;
                    }
                    case STRING: 
                    case SCALAR: {
                        return KnownJsonType.STRING;
                    }
                }
            }
            if ((typeHint = (TypeHint)accessor.getAnnotation(TypeHint.class)) != null && (hint = TypeHintUtils.getTypeHint((TypeHint)typeHint, (ProcessingEnvironment)context.getContext().getProcessingEnvironment(), null)) != null) {
                return JsonTypeFactory.getJsonType(hint, context);
            }
            final JsonSerialize serializeInfo = (JsonSerialize)accessor.getAnnotation(JsonSerialize.class);
            if (serializeInfo != null) {
                DecoratedProcessingEnvironment env = context.getContext().getProcessingEnvironment();
                DecoratedTypeMirror using = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws Exception {
                        return serializeInfo.using();
                    }
                }, (ProcessingEnvironment)env, JsonSerializer.None.class);
                if (using != null) {
                    return KnownJsonType.OBJECT;
                }
                DecoratedTypeMirror as = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws Exception {
                        return serializeInfo.as();
                    }
                }, (ProcessingEnvironment)env, Void.class);
                if (as != null) {
                    return JsonTypeFactory.getJsonType((TypeMirror)as, context);
                }
                DecoratedTypeMirror contentAs = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws Exception {
                        return serializeInfo.contentAs();
                    }
                }, (ProcessingEnvironment)env, Void.class);
                DecoratedTypeMirror contentUsing = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                    @Override
                    public Class<?> call() throws Exception {
                        return serializeInfo.contentUsing();
                    }
                }, (ProcessingEnvironment)env, JsonSerializer.None.class);
                DecoratedTypeMirror accessorType = (DecoratedTypeMirror)accessor.asType();
                if (accessorType.isCollection() || accessorType.isArray()) {
                    if (contentUsing != null) {
                        return new JsonArrayType(KnownJsonType.OBJECT);
                    }
                    if (contentAs != null) {
                        return new JsonArrayType(JsonTypeFactory.getJsonType((TypeMirror)contentAs, context));
                    }
                } else {
                    MapType mapType = MapType.findMapType((TypeMirror)accessorType, context);
                    if (mapType != null) {
                        DecoratedTypeMirror keyAs = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                            @Override
                            public Class<?> call() throws Exception {
                                return serializeInfo.keyAs();
                            }
                        }, (ProcessingEnvironment)env, Void.class);
                        DecoratedTypeMirror keyUsing = Annotations.mirrorOf((Callable)new Callable<Class<?>>(){

                            @Override
                            public Class<?> call() throws Exception {
                                return serializeInfo.keyUsing();
                            }
                        }, (ProcessingEnvironment)env, JsonSerializer.None.class);
                        if (keyAs != null || contentAs != null) {
                            KnownJsonType keyType;
                            JsonType jsonType2 = keyUsing == null ? JsonTypeFactory.getJsonType((TypeMirror)(keyAs == null ? (DecoratedTypeMirror)mapType.getKeyType() : keyAs), context) : (keyType = KnownJsonType.OBJECT);
                            KnownJsonType valueType = contentUsing == null ? JsonTypeFactory.getJsonType((TypeMirror)(contentAs == null ? (DecoratedTypeMirror)mapType.getValueType() : contentAs), context) : KnownJsonType.OBJECT;
                            return new JsonMapType(keyType, valueType);
                        }
                    }
                }
            }
        }
        if (adaptable.isAdapted()) {
            jsonType = JsonTypeFactory.getJsonType(adaptable.getAdapterType().getAdaptingType(), context);
        }
        return jsonType;
    }

    public static JsonType getJsonType(TypeMirror typeMirror, EnunciateJacksonContext context) {
        return typeMirror.accept(new JsonTypeVisitor(), new JsonTypeVisitor.Context(context, false, false, new LinkedList<String>()));
    }
}

