/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.metadata.Ignore;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicEnunicateModule;
import com.webcohesion.enunciate.module.MediaTypeDefinitionModule;
import com.webcohesion.enunciate.module.TypeFilteringModule;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import com.webcohesion.enunciate.modules.jackson1.model.types.KnownJsonType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.codehaus.jackson.annotate.JacksonAnnotation;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.reflections.adapters.MetadataAdapter;

public class Jackson1Module
extends BasicEnunicateModule
implements TypeFilteringModule,
MediaTypeDefinitionModule,
ApiRegistryProviderModule,
ApiFeatureProviderModule {
    private ApiRegistryProviderModule.DataTypeDetectionStrategy defaultDataTypeDetectionStrategy;
    private boolean jacksonDetected = false;
    private boolean jaxbSupportDetected = false;
    private EnunciateJackson1Context jacksonContext;
    private ApiRegistry apiRegistry;

    public String getName() {
        return "jackson1";
    }

    public boolean isHonorJaxbAnnotations() {
        return this.config.getBoolean("[@honorJaxb]", this.jaxbSupportDetected);
    }

    public boolean isCollapseTypeHierarchy() {
        return this.config.getBoolean("[@collapse-type-hierarchy]", false);
    }

    public KnownJsonType getDateFormat() {
        String dateFormatString = this.config.getString("[@dateFormat]", KnownJsonType.WHOLE_NUMBER.name());
        return KnownJsonType.valueOf(dateFormatString.toUpperCase());
    }

    public void setApiRegistry(ApiRegistry registry) {
        this.apiRegistry = registry;
    }

    public EnunciateJackson1Context getJacksonContext() {
        return this.jacksonContext;
    }

    public void call(EnunciateContext context) {
        this.jacksonContext = new EnunciateJackson1Context(context, this.isHonorJaxbAnnotations(), this.getDateFormat(), this.isCollapseTypeHierarchy(), this.getMixins());
        ApiRegistryProviderModule.DataTypeDetectionStrategy detectionStrategy = this.getDataTypeDetectionStrategy();
        switch (detectionStrategy) {
            case aggressive: {
                for (Element declaration : context.getApiElements()) {
                    this.addPotentialJacksonElement(declaration, new LinkedList<Element>());
                }
                break;
            }
            case local: {
                for (Element declaration : context.getLocalApiElements()) {
                    this.addPotentialJacksonElement(declaration, new LinkedList<Element>());
                }
            }
            default: {
                if (!context.hasExplicitIncludes()) break;
                for (Element declaration : context.getApiElements()) {
                    if (!context.isExplicitlyIncluded(declaration)) continue;
                    this.addPotentialJacksonElement(declaration, new LinkedList<Element>());
                }
            }
        }
    }

    public boolean isEnabled() {
        return !this.config.getBoolean("[@disabled]", !this.jacksonDetected);
    }

    public ApiRegistryProviderModule.DataTypeDetectionStrategy getDataTypeDetectionStrategy() {
        String dataTypeDetection = this.config.getString("[@datatype-detection]", null);
        if (dataTypeDetection != null) {
            try {
                return ApiRegistryProviderModule.DataTypeDetectionStrategy.valueOf((String)dataTypeDetection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.defaultDataTypeDetectionStrategy == null ? ApiRegistryProviderModule.DataTypeDetectionStrategy.local : this.defaultDataTypeDetectionStrategy;
    }

    public void setDefaultDataTypeDetectionStrategy(ApiRegistryProviderModule.DataTypeDetectionStrategy strategy) {
        this.defaultDataTypeDetectionStrategy = strategy;
    }

    public void addDataTypeDefinitions(TypeMirror type, Set<String> declaredMediaTypes, LinkedList<Element> contextStack) {
        boolean jsonApplies = false;
        for (String mediaType : declaredMediaTypes) {
            if (!"*/*".equals(mediaType) && !"text/*".equals(mediaType) && !"application/*".equals(mediaType) && !"application/json".equals(mediaType) && !mediaType.endsWith("+json")) continue;
            jsonApplies = true;
            break;
        }
        if (jsonApplies) {
            boolean wasEmpty = this.jacksonContext.isEmpty();
            this.jacksonContext.addReferencedTypeDefinitions(type, contextStack);
            if (wasEmpty && !this.jacksonContext.isEmpty()) {
                this.apiRegistry.getSyntaxes().add(this.jacksonContext);
            }
        } else {
            this.debug("Element %s is NOT to be added as a Jackson data type because %s doesn't seem to include JSON.", new Object[]{type, declaredMediaTypes});
        }
    }

    public Map<String, String> getMixins() {
        HashMap<String, String> mixins = new HashMap<String, String>();
        List mixinElements = this.config.configurationsAt("mixin");
        for (HierarchicalConfiguration mixinElement : mixinElements) {
            mixins.put(mixinElement.getString("[@target]", ""), mixinElement.getString("[@source]", ""));
        }
        return mixins;
    }

    protected void addPotentialJacksonElement(Element declaration, LinkedList<Element> contextStack) {
        if (declaration instanceof TypeElement && !this.jacksonContext.isKnownTypeDefinition((TypeElement)declaration) && this.isExplicitTypeDefinition(declaration, this.jacksonContext.isHonorJaxb())) {
            if (this.jacksonContext.getTypeDefinitions().isEmpty()) {
                this.apiRegistry.getSyntaxes().add(this.jacksonContext);
                this.warn("Enunciate support for Jackson 1.x is deprecated. It is recommended that you update to Jackson 2.x.", new Object[0]);
            }
            this.jacksonContext.add(this.jacksonContext.createTypeDefinition((TypeElement)declaration), contextStack);
        }
    }

    protected boolean isExplicitTypeDefinition(Element declaration, boolean honorJaxb) {
        if (declaration.getKind() != ElementKind.CLASS && declaration.getKind() != ElementKind.ENUM) {
            this.debug("%s isn't a potential Jackson type because it's not a class or an enum.", new Object[]{declaration});
            return false;
        }
        PackageElement pckg = this.context.getProcessingEnvironment().getElementUtils().getPackageOf(declaration);
        if (pckg != null && pckg.getAnnotation(Ignore.class) != null) {
            this.debug("%s isn't a potential Jackson type because its package is annotated as to be ignored.", new Object[]{declaration});
            return false;
        }
        if (this.isThrowable(declaration)) {
            this.debug("%s isn't a potential Jackson type because it's an instance of java.lang.Throwable.", new Object[]{declaration});
            return false;
        }
        List<? extends AnnotationMirror> annotationMirrors = declaration.getAnnotationMirrors();
        boolean explicitXMLTypeOrElement = false;
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Element annotationDeclaration = annotationMirror.getAnnotationType().asElement();
            if (annotationDeclaration != null) {
                String fqn;
                String string = fqn = annotationDeclaration instanceof TypeElement ? ((TypeElement)annotationDeclaration).getQualifiedName().toString() : "";
                if (JsonIgnore.class.getName().equals(fqn) || fqn.startsWith("javax.xml.ws") || fqn.startsWith("javax.ws.rs") || fqn.startsWith("javax.jws")) {
                    this.debug("%s isn't a potential Jackson type because of annotation %s.", new Object[]{declaration, fqn});
                    return false;
                }
                if (honorJaxb) {
                    if (XmlTransient.class.getName().equals(fqn)) {
                        this.debug("%s isn't a potential Jackson type because of annotation %s.", new Object[]{declaration, fqn});
                        return false;
                    }
                    if (XmlType.class.getName().equals(fqn) || XmlRootElement.class.getName().equals(fqn)) {
                        this.debug("%s will be considered a Jackson type because we're honoring the %s annotation.", new Object[]{declaration, fqn});
                        explicitXMLTypeOrElement = true;
                    }
                }
                boolean bl = explicitXMLTypeOrElement = explicitXMLTypeOrElement || this.isJacksonSerializationAnnotation(fqn);
            }
            if (!explicitXMLTypeOrElement) continue;
            break;
        }
        return explicitXMLTypeOrElement;
    }

    protected boolean isThrowable(Element declaration) {
        return declaration.getKind() == ElementKind.CLASS && ((DecoratedTypeMirror)declaration.asType()).isInstanceOf(Throwable.class);
    }

    public boolean acceptType(Object type, MetadataAdapter metadata) {
        String classname = metadata.getClassName(type);
        this.jacksonDetected |= ObjectMapper.class.getName().equals(classname);
        this.jaxbSupportDetected |= "org.codehaus.jackson.xc.JaxbAnnotationIntrospector".equals(classname);
        List classAnnotations = metadata.getClassAnnotationNames(type);
        if (classAnnotations != null) {
            for (String fqn : classAnnotations) {
                if (!this.isJacksonSerializationAnnotation(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isJacksonSerializationAnnotation(String fqn) {
        return !JacksonAnnotation.class.getName().equals(fqn) && JsonSerialize.class.getName().equals(fqn);
    }
}

