/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1.api.impl;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.datatype.Example;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import com.webcohesion.enunciate.modules.jackson1.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.EnumValue;
import com.webcohesion.enunciate.modules.jackson1.model.Member;
import com.webcohesion.enunciate.modules.jackson1.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonArrayType;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonClassType;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonMapType;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonType;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class ExampleImpl
implements Example {
    private final ObjectTypeDefinition type;

    public ExampleImpl(ObjectTypeDefinition type) {
        this.type = type;
    }

    public String getLang() {
        return "js";
    }

    public String getBody() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        Context context = new Context();
        context.stack = new LinkedList();
        this.build(node, this.type, context);
        ObjectMapper mapper = new ObjectMapper().enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
        try {
            return mapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new EnunciateException((Throwable)e);
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void build(ObjectNode node, ObjectTypeDefinition type, Context context) {
        if (context.stack.size() > 2) {
            return;
        }
        if (type.getTypeIdInclusion() == JsonTypeInfo.As.PROPERTY && type.getTypeIdProperty() != null) {
            node.put(type.getTypeIdProperty(), "...");
        }
        FacetFilter facetFilter = type.getContext().getContext().getConfiguration().getFacetFilter();
        for (Member member : type.getMembers()) {
            DocumentationExample documentationExample;
            if (!facetFilter.accept((HasFacets)member) || ElementUtils.findDeprecationMessage((DecoratedElement)member) != null) continue;
            String example = null;
            String example2 = null;
            JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)member.getJavaDoc().get((Object)"documentationExample");
            if (tags != null && tags.size() > 0) {
                String tag = ((String)tags.get(0)).trim();
                example2 = example = tag.isEmpty() ? null : tag;
                if (tags.size() > 1) {
                    tag = ((String)tags.get(1)).trim();
                    String string = example2 = tag.isEmpty() ? null : tag;
                }
            }
            if ((documentationExample = (DocumentationExample)member.getAnnotation(DocumentationExample.class)) != null) {
                if (documentationExample.exclude()) continue;
                example = documentationExample.value();
                example = "##default".equals(example) ? null : example;
                example2 = documentationExample.value2();
                String string = example2 = "##default".equals(example2) ? null : example2;
            }
            if (context.currentIndex % 2 > 0) {
                String placeholder = example2;
                example2 = example;
                example = placeholder;
            }
            if (member.getChoices().size() > 1) {
                ArrayNode wrapperNode;
                String choiceName;
                JsonType jsonType;
                if (member.isCollectionType()) {
                    ArrayNode exampleNode = JsonNodeFactory.instance.arrayNode();
                    for (Member member2 : member.getChoices()) {
                        jsonType = member2.getJsonType();
                        choiceName = member2.getName();
                        if ("".equals(choiceName)) {
                            choiceName = "...";
                        }
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_ARRAY) {
                            wrapperNode = JsonNodeFactory.instance.arrayNode();
                            wrapperNode.add(choiceName);
                            wrapperNode.add(this.exampleNode(jsonType, example, example2, context));
                            exampleNode.add((JsonNode)wrapperNode);
                            continue;
                        }
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                            wrapperNode = JsonNodeFactory.instance.objectNode();
                            wrapperNode.put(choiceName, this.exampleNode(jsonType, example, example2, context));
                            exampleNode.add((JsonNode)wrapperNode);
                            continue;
                        }
                        JsonNode itemNode = this.exampleNode(jsonType, example, example2, context);
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.PROPERTY) {
                            if (member.getSubtypeIdProperty() != null && itemNode instanceof ObjectNode) {
                                ((ObjectNode)itemNode).put(member.getSubtypeIdProperty(), "...");
                            }
                        } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.EXTERNAL_PROPERTY && member.getSubtypeIdProperty() != null) {
                            node.put(member.getSubtypeIdProperty(), "...");
                        }
                        node.put(member.getName(), (JsonNode)exampleNode);
                        exampleNode.add(itemNode);
                    }
                    continue;
                }
                for (Member member3 : member.getChoices()) {
                    void var13_20;
                    jsonType = member3.getJsonType();
                    choiceName = member3.getName();
                    if ("".equals(choiceName)) {
                        choiceName = "...";
                    }
                    if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_ARRAY) {
                        wrapperNode = JsonNodeFactory.instance.arrayNode();
                        wrapperNode.add(choiceName);
                        wrapperNode.add(this.exampleNode(jsonType, example, example2, context));
                        ArrayNode arrayNode = wrapperNode;
                    } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.WRAPPER_OBJECT) {
                        wrapperNode = JsonNodeFactory.instance.objectNode();
                        wrapperNode.put(choiceName, this.exampleNode(jsonType, example, example2, context));
                        ArrayNode arrayNode = wrapperNode;
                    } else {
                        JsonNode jsonNode = this.exampleNode(jsonType, example, example2, context);
                        if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.PROPERTY) {
                            if (member.getSubtypeIdProperty() != null && jsonNode instanceof ObjectNode) {
                                ((ObjectNode)jsonNode).put(member.getSubtypeIdProperty(), "...");
                            }
                        } else if (member.getSubtypeIdInclusion() == JsonTypeInfo.As.EXTERNAL_PROPERTY && member.getSubtypeIdProperty() != null) {
                            node.put(member.getSubtypeIdProperty(), "...");
                        }
                    }
                    node.put(member.getName(), (JsonNode)var13_20);
                }
                continue;
            }
            node.put(member.getName(), this.exampleNode(member.getJsonType(), example, example2, context));
        }
        JsonType supertype = type.getSupertype();
        if (supertype instanceof JsonClassType && ((JsonClassType)supertype).getTypeDefinition() instanceof ObjectTypeDefinition) {
            this.build(node, (ObjectTypeDefinition)((JsonClassType)supertype).getTypeDefinition(), context);
        }
        if (type.getWildcardMember() != null && ElementUtils.findDeprecationMessage((DecoratedElement)type.getWildcardMember()) == null) {
            node.put("extension1", "...");
            node.put("extension2", "...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode exampleNode(JsonType jsonType, String specifiedExample, String specifiedExample2, Context context) {
        if (jsonType instanceof JsonClassType) {
            TypeDefinition typeDefinition = ((JsonClassType)jsonType).getTypeDefinition();
            if (typeDefinition instanceof ObjectTypeDefinition) {
                ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
                if (!context.stack.contains(typeDefinition.getQualifiedName().toString())) {
                    context.stack.push(typeDefinition.getQualifiedName().toString());
                    try {
                        this.build(objectNode, (ObjectTypeDefinition)typeDefinition, context);
                    }
                    finally {
                        context.stack.pop();
                    }
                }
                return objectNode;
            }
            if (typeDefinition instanceof EnumTypeDefinition) {
                String example = "???";
                if (specifiedExample != null) {
                    example = specifiedExample;
                } else {
                    List<EnumValue> enumValues = ((EnumTypeDefinition)typeDefinition).getEnumValues();
                    if (enumValues.size() > 0) {
                        int index = new Random().nextInt(enumValues.size());
                        example = enumValues.get(index).getValue();
                    }
                }
                return JsonNodeFactory.instance.textNode(example);
            }
            return this.exampleNode(((SimpleTypeDefinition)typeDefinition).getBaseType(), specifiedExample, specifiedExample2, context);
        }
        if (jsonType instanceof JsonMapType) {
            ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
            mapNode.put("property1", "...");
            mapNode.put("property2", "...");
            return mapNode;
        }
        if (jsonType.isArray()) {
            ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
            if (jsonType instanceof JsonArrayType) {
                JsonNode componentNode = this.exampleNode(((JsonArrayType)jsonType).getComponentType(), specifiedExample, specifiedExample2, context);
                arrayNode.add(componentNode);
                Context context2 = new Context();
                context2.stack = context.stack;
                context2.currentIndex = 1;
                JsonNode componentNode2 = this.exampleNode(((JsonArrayType)jsonType).getComponentType(), specifiedExample2, specifiedExample, context2);
                arrayNode.add(componentNode2);
            }
            return arrayNode;
        }
        if (jsonType.isWholeNumber()) {
            Long example = 12345L;
            if (specifiedExample != null) {
                try {
                    example = Long.parseLong(specifiedExample);
                }
                catch (NumberFormatException e) {
                    this.type.getContext().getContext().getLogger().warn("\"%s\" was provided as a documentation example, but it is not a valid JSON whole number, so it will be ignored.", new Object[]{specifiedExample});
                }
            }
            return JsonNodeFactory.instance.numberNode(example);
        }
        if (jsonType.isNumber()) {
            Double example = 12345.0;
            if (specifiedExample != null) {
                try {
                    example = Double.parseDouble(specifiedExample);
                }
                catch (NumberFormatException e) {
                    this.type.getContext().getContext().getLogger().warn("\"%s\" was provided as a documentation example, but it is not a valid JSON number, so it will be ignored.", new Object[]{specifiedExample});
                }
            }
            return JsonNodeFactory.instance.numberNode(example);
        }
        if (jsonType.isBoolean()) {
            boolean example = !"false".equals(specifiedExample);
            return JsonNodeFactory.instance.booleanNode(example);
        }
        if (jsonType.isString()) {
            String example = specifiedExample;
            if (example == null) {
                example = "...";
            }
            return JsonNodeFactory.instance.textNode(example);
        }
        return JsonNodeFactory.instance.objectNode();
    }

    private static class Context {
        LinkedList<String> stack;
        int currentIndex = 0;

        private Context() {
        }
    }
}

