/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1.api.impl;

import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.datatype.Property;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.jackson1.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jackson1.model.Member;
import com.webcohesion.enunciate.util.BeanValidationUtils;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class PropertyImpl
implements Property {
    private final Member member;

    public PropertyImpl(Member member) {
        this.member = member;
    }

    public String getName() {
        return this.member.getName();
    }

    public DataTypeReference getDataType() {
        return new DataTypeReferenceImpl(this.member.getJsonType());
    }

    public String getDescription() {
        return this.member.getJavaDoc().toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.member);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.member.getAnnotations();
    }

    public boolean isRequired() {
        return this.member.isRequired();
    }

    public String getConstraints() {
        return BeanValidationUtils.describeConstraints((Element)((Object)this.member), (boolean)this.isRequired());
    }

    public String getDefaultValue() {
        return this.member.getDefaultValue();
    }

    public JavaDoc getJavaDoc() {
        return this.member.getJavaDoc();
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.member), (Map)this.member.getContext().getContext().getConfiguration().getAnnotationStyles());
    }
}

