/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1.model.adapters;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class AdapterType
extends DecoratedDeclaredType {
    private final TypeMirror adaptedType;
    private final TypeMirror adaptingType;

    public AdapterType(DeclaredType adapterType, EnunciateJackson1Context context) {
        super(adapterType, (ProcessingEnvironment)context.getContext().getProcessingEnvironment());
        List<? extends TypeMirror> adaptorTypeArgs;
        if (context.isHonorJaxb()) {
            DeclaredType adaptorInterfaceType = AdapterType.findXmlAdapterType(adapterType, new TypeVariableContext(), context.getContext().getProcessingEnvironment());
            if (adaptorInterfaceType == null) {
                throw new EnunciateException(adapterType + " is not an instance of javax.xml.bind.annotation.adapters.XmlAdapter.");
            }
            adaptorTypeArgs = adaptorInterfaceType.getTypeArguments();
            if (adaptorTypeArgs == null || adaptorTypeArgs.size() != 2) {
                throw new EnunciateException(adapterType + " must specify both a value type and a bound type.");
            }
        } else {
            throw new EnunciateException(adapterType + " is not an instance of javax.xml.bind.annotation.adapters.XmlAdapter.");
        }
        this.adaptingType = adaptorTypeArgs.get(0);
        this.adaptedType = context.getContext().getProcessingEnvironment().getTypeUtils().erasure(adaptorTypeArgs.get(1));
    }

    private static DeclaredType findXmlAdapterType(DeclaredType declaredType, TypeVariableContext variableContext, DecoratedProcessingEnvironment env) {
        TypeElement element = (TypeElement)declaredType.asElement();
        if (element == null) {
            return null;
        }
        if (Object.class.getName().equals(element.getQualifiedName().toString())) {
            return null;
        }
        if (XmlAdapter.class.getName().equals(element.getQualifiedName().toString())) {
            return (DeclaredType)variableContext.resolveTypeVariables((TypeMirror)declaredType, (ProcessingEnvironment)env);
        }
        DeclaredType superclass = (DeclaredType)element.getSuperclass();
        if (superclass == null || superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        return AdapterType.findXmlAdapterType(superclass, variableContext.push(element.getTypeParameters(), declaredType.getTypeArguments()), env);
    }

    public boolean canAdapt(TypeMirror type, EnunciateContext context) {
        return context.getProcessingEnvironment().getTypeUtils().isAssignable(type, this.getAdaptedType());
    }

    public TypeMirror getAdaptingType(DecoratedTypeMirror adaptedType, EnunciateContext context) {
        TypeMirror componentType = null;
        if (adaptedType.isCollection()) {
            List<? extends TypeMirror> itemTypes = ((DeclaredType)adaptedType).getTypeArguments();
            componentType = itemTypes.isEmpty() ? TypeMirrorUtils.objectType((DecoratedProcessingEnvironment)context.getProcessingEnvironment()) : itemTypes.get(0);
        } else if (adaptedType instanceof ArrayType) {
            componentType = ((ArrayType)adaptedType).getComponentType();
        }
        if (componentType != null && this.canAdapt(componentType, context)) {
            return context.getProcessingEnvironment().getTypeUtils().getDeclaredType((TypeElement)TypeMirrorUtils.collectionType((DecoratedProcessingEnvironment)context.getProcessingEnvironment()).asElement(), componentType);
        }
        return this.getAdaptingType();
    }

    public TypeMirror getAdaptedType() {
        return this.adaptedType;
    }

    public TypeMirror getAdaptingType() {
        return this.adaptingType;
    }
}

