/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.webcohesion.enunciate.javac.decorations.DecoratedElements;
import com.webcohesion.enunciate.javac.decorations.DecoratedTypes;
import com.webcohesion.enunciate.javac.decorations.SourcePosition;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class DecoratedProcessingEnvironment
implements ProcessingEnvironment {
    private final ProcessingEnvironment delegate;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Trees trees;

    public DecoratedProcessingEnvironment(ProcessingEnvironment delegate) {
        while (delegate instanceof DecoratedProcessingEnvironment) {
            delegate = ((DecoratedProcessingEnvironment)delegate).delegate;
        }
        this.delegate = delegate;
        this.trees = Trees.instance(delegate);
    }

    @Override
    public Map<String, String> getOptions() {
        return this.delegate.getOptions();
    }

    @Override
    public Messager getMessager() {
        return this.delegate.getMessager();
    }

    @Override
    public Filer getFiler() {
        return this.delegate.getFiler();
    }

    @Override
    public Elements getElementUtils() {
        return new DecoratedElements(this.delegate.getElementUtils(), this);
    }

    @Override
    public Types getTypeUtils() {
        return new DecoratedTypes(this.delegate.getTypeUtils(), this);
    }

    @Override
    public SourceVersion getSourceVersion() {
        return this.delegate.getSourceVersion();
    }

    @Override
    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public Object getProperty(String property) {
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    public SourcePosition findSourcePosition(Element element) {
        while (element instanceof DecoratedElement) {
            element = ((DecoratedElement)element).getDelegate();
        }
        TreePath path = this.trees.getPath(element);
        if (path != null) {
            CompilationUnitTree cu = path.getCompilationUnit();
            SourcePositions positions = this.trees.getSourcePositions();
            long position = positions.getStartPosition(cu, path.getLeaf());
            long line = cu.getLineMap().getLineNumber(position);
            long column = cu.getLineMap().getColumnNumber(position);
            return new SourcePosition(path, cu.getSourceFile(), position, line, column);
        }
        return null;
    }
}

