/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.element;

import com.webcohesion.enunciate.javac.decorations.ElementDecorator;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedVariableElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedReferenceType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

public class DecoratedExecutableElement
extends DecoratedElement<ExecutableElement>
implements ExecutableElement {
    public static final Pattern INHERITDOC_PATTERN = Pattern.compile("^[ \\t]*\\{@inheritDoc.*?\\}[ \\t]*");
    private List<? extends VariableElement> parameters;
    private List<? extends TypeMirror> thrownTypes;
    private List<? extends TypeParameterElement> typeParameters;
    private TypeMirror typeMirror;

    public DecoratedExecutableElement(ExecutableElement delegate, ProcessingEnvironment env) {
        super(delegate, env);
    }

    protected DecoratedExecutableElement(DecoratedExecutableElement copy) {
        super(copy.delegate, copy.env);
        this.parameters = copy.parameters;
        this.thrownTypes = copy.thrownTypes;
        this.typeParameters = copy.typeParameters;
        this.typeMirror = copy.typeMirror;
    }

    protected List<? extends TypeMirror> loadDecoratedThrownTypes(ExecutableElement delegate) {
        List<? extends TypeMirror> thrownTypes = TypeMirrorDecorator.decorate(delegate.getThrownTypes(), (ProcessingEnvironment)this.env);
        if (thrownTypes != null && !thrownTypes.isEmpty()) {
            HashMap<String, String> throwsComments = new HashMap<String, String>();
            ArrayList allThrowsComments = new ArrayList();
            JavaDoc javaDoc = this.getJavaDoc();
            if (javaDoc.get("throws") != null) {
                allThrowsComments.addAll((Collection)javaDoc.get("throws"));
            }
            if (javaDoc.get("exception") != null) {
                allThrowsComments.addAll((Collection)javaDoc.get("exception"));
            }
            for (String string : allThrowsComments) {
                int spaceIndex = JavaDoc.indexOfFirstWhitespace(string);
                String exception = string.substring(0, spaceIndex);
                String throwsComment = "";
                if (spaceIndex + 1 < string.length()) {
                    throwsComment = string.substring(spaceIndex + 1);
                }
                throwsComments.put(exception, throwsComment);
            }
            for (TypeMirror typeMirror : thrownTypes) {
                String fullyQualifiedThrownTypeName = String.valueOf(typeMirror);
                String throwsComment = (String)throwsComments.get(fullyQualifiedThrownTypeName);
                if (throwsComment == null) {
                    throwsComment = (String)throwsComments.get(fullyQualifiedThrownTypeName.substring(fullyQualifiedThrownTypeName.lastIndexOf(46) + 1));
                }
                ((DecoratedReferenceType)typeMirror).setDocComment(throwsComment);
            }
        }
        return thrownTypes;
    }

    protected List<? extends VariableElement> loadDecoratedParameters() {
        JavaDoc javaDoc = this.getJavaDoc();
        HashMap<String, String> paramsComments = this.loadParamsComments(javaDoc);
        List<? extends VariableElement> parameters = ElementDecorator.decorate(((ExecutableElement)this.delegate).getParameters(), (ProcessingEnvironment)this.env);
        if (parameters != null) {
            for (VariableElement variableElement : parameters) {
                if (paramsComments.get(variableElement.getSimpleName().toString()) == null) continue;
                ((DecoratedVariableElement)variableElement).setDocComment(paramsComments.get(variableElement.getSimpleName().toString()));
            }
        }
        return parameters;
    }

    protected HashMap<String, String> loadParamsComments(JavaDoc javaDoc) {
        HashMap<String, String> paramsComments = new HashMap<String, String>();
        if (javaDoc.get("param") != null) {
            for (String paramDoc : (JavaDoc.JavaDocTagList)javaDoc.get("param")) {
                int spaceIndex = (paramDoc = paramDoc.replaceAll("\\s", " ")).indexOf(32);
                if (spaceIndex == -1) {
                    spaceIndex = paramDoc.length();
                }
                String param = paramDoc.substring(0, spaceIndex);
                String paramComment = "";
                if (spaceIndex + 1 < paramDoc.length()) {
                    paramComment = paramDoc.substring(spaceIndex + 1);
                }
                paramsComments.put(param, paramComment);
            }
        }
        return paramsComments;
    }

    @Override
    protected JavaDoc constructJavaDoc(String docComment, JavaDocTagHandler handler) {
        if (docComment == null || "".equals(docComment.trim()) || INHERITDOC_PATTERN.matcher(docComment).find()) {
            if (docComment == null) {
                docComment = "";
            }
            docComment = this.replaceDocInheritance(docComment);
        }
        return super.constructJavaDoc(docComment, handler);
    }

    private String replaceDocInheritance(String currentComment) {
        return this.replaceDocInheritance(new TreeSet<String>(), currentComment, (TypeElement)((ExecutableElement)this.delegate).getEnclosingElement());
    }

    private String replaceDocInheritance(Set<String> visitedDecls, String currentComment, TypeElement declaringType) {
        if (declaringType != null && this.commentNeedsReplacement(currentComment)) {
            ArrayList<? extends TypeMirror> supers = new ArrayList<TypeMirror>(declaringType.getInterfaces());
            TypeMirror superclass = declaringType.getSuperclass();
            if (superclass != null && superclass.getKind() != TypeKind.NONE) {
                supers.add(superclass);
            }
            Elements declarations = this.env.getElementUtils();
            ArrayList<TypeElement> decls = new ArrayList<TypeElement>(supers.size());
            for (TypeMirror typeMirror : supers) {
                TypeElement decl;
                if (!(typeMirror instanceof DeclaredType) || (decl = (TypeElement)((DeclaredType)typeMirror).asElement()) == null || visitedDecls.contains(decl.getQualifiedName().toString())) continue;
                visitedDecls.add(decl.getQualifiedName().toString());
                for (ExecutableElement methodDeclaration : ElementFilter.methodsIn(decl.getEnclosedElements())) {
                    if (!declarations.hides(this.delegate, methodDeclaration) || this.commentNeedsReplacement(currentComment = this.doReplace(currentComment, declarations.getDocComment(methodDeclaration)))) continue;
                    return currentComment;
                }
                decls.add(decl);
            }
            for (TypeElement typeElement : decls) {
                if (this.commentNeedsReplacement(currentComment = this.replaceDocInheritance(visitedDecls, currentComment, typeElement))) continue;
                return currentComment;
            }
        }
        return currentComment;
    }

    private String doReplace(String currentComment, String replacement) {
        if (replacement == null) {
            replacement = "";
        }
        if ("".equals(currentComment)) {
            return replacement.trim();
        }
        return INHERITDOC_PATTERN.matcher(currentComment).replaceAll(replacement);
    }

    protected boolean commentNeedsReplacement(String currentComment) {
        return currentComment == null || "".equals(currentComment.trim()) || INHERITDOC_PATTERN.matcher(currentComment).find();
    }

    @Override
    public List<? extends TypeParameterElement> getTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = ElementDecorator.decorate(((ExecutableElement)this.delegate).getTypeParameters(), (ProcessingEnvironment)this.env);
        }
        return this.typeParameters;
    }

    @Override
    public TypeMirror getReturnType() {
        if (this.typeMirror == null) {
            this.typeMirror = TypeMirrorDecorator.decorate(((ExecutableElement)this.delegate).getReturnType(), (ProcessingEnvironment)this.env);
            if (this.getJavaDoc().get("return") != null) {
                ((DecoratedTypeMirror)this.typeMirror).setDocComment(((JavaDoc.JavaDocTagList)this.getJavaDoc().get("return")).toString());
            }
        }
        return this.typeMirror;
    }

    @Override
    public boolean isVarArgs() {
        return ((ExecutableElement)this.delegate).isVarArgs();
    }

    @Override
    public AnnotationValue getDefaultValue() {
        return ((ExecutableElement)this.delegate).getDefaultValue();
    }

    @Override
    public List<? extends VariableElement> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.loadDecoratedParameters();
        }
        return this.parameters;
    }

    @Override
    public List<? extends TypeMirror> getThrownTypes() {
        if (this.thrownTypes == null) {
            this.thrownTypes = this.loadDecoratedThrownTypes((ExecutableElement)this.delegate);
        }
        return this.thrownTypes;
    }

    public boolean isGetter() {
        return (this.getSimpleName().toString().startsWith("get") || this.isIs()) && this.getParameters().isEmpty();
    }

    private boolean isIs() {
        return this.getSimpleName().toString().startsWith("is") && (this.getReturnType().getKind() == TypeKind.BOOLEAN || ((DecoratedTypeMirror)this.getReturnType()).isInstanceOf(Boolean.class));
    }

    public boolean isSetter() {
        return this.getSimpleName().toString().startsWith("set") && this.getParameters().size() == 1;
    }

    public String getPropertyName() {
        String propertyName = null;
        if (this.isIs()) {
            propertyName = Introspector.decapitalize(this.getSimpleName().toString().substring(2));
        } else if (this.isGetter() || this.isSetter()) {
            propertyName = Introspector.decapitalize(this.getSimpleName().toString().substring(3));
        }
        return propertyName;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitExecutable(this, p);
    }
}

