/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.element;

import com.webcohesion.enunciate.javac.decorations.ElementDecorator;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedExecutableElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class DecoratedTypeElement
extends DecoratedElement<TypeElement>
implements TypeElement {
    private PackageElement pckg;
    private List<PropertyElement> properties;
    private TypeMirror superclass;
    private List<? extends TypeMirror> interfaces;
    private List<ExecutableElement> methods;
    private List<ExecutableElement> constructors;
    private List<VariableElement> enumConstants;

    public DecoratedTypeElement(TypeElement delegate, ProcessingEnvironment env) {
        super(delegate, env);
    }

    public PackageElement getPackage() {
        if (this.pckg == null) {
            this.pckg = ElementDecorator.decorate(this.env.getElementUtils().getPackageOf(this.delegate), (ProcessingEnvironment)this.env);
        }
        return this.pckg;
    }

    @Override
    public List<? extends TypeParameterElement> getTypeParameters() {
        return ElementDecorator.decorate(((TypeElement)this.delegate).getTypeParameters(), (ProcessingEnvironment)this.env);
    }

    @Override
    public NestingKind getNestingKind() {
        return ((TypeElement)this.delegate).getNestingKind();
    }

    @Override
    public Name getQualifiedName() {
        return ((TypeElement)this.delegate).getQualifiedName();
    }

    @Override
    public TypeMirror getSuperclass() {
        if (this.superclass == null) {
            this.superclass = TypeMirrorDecorator.decorate(((TypeElement)this.delegate).getSuperclass(), (ProcessingEnvironment)this.env);
        }
        return this.superclass;
    }

    @Override
    public List<? extends TypeMirror> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = TypeMirrorDecorator.decorate(((TypeElement)this.delegate).getInterfaces(), (ProcessingEnvironment)this.env);
        }
        return this.interfaces;
    }

    public List<? extends ExecutableElement> getMethods() {
        if (this.methods == null) {
            this.methods = ElementDecorator.decorate(ElementFilter.methodsIn(((TypeElement)this.delegate).getEnclosedElements()), (ProcessingEnvironment)this.env);
        }
        return this.methods;
    }

    public List<ExecutableElement> getConstructors() {
        if (this.constructors == null) {
            this.constructors = ElementDecorator.decorate(ElementFilter.constructorsIn(((TypeElement)this.delegate).getEnclosedElements()), (ProcessingEnvironment)this.env);
        }
        return this.constructors;
    }

    public List<PropertyElement> getProperties() {
        return this.getProperties(true);
    }

    public List<PropertyElement> getProperties(boolean requirePublic) {
        if (this.properties == null) {
            this.properties = this.loadProperties(requirePublic);
        }
        return this.properties;
    }

    public List<VariableElement> enumValues() {
        if (this.enumConstants == null) {
            this.enumConstants = this.loadEnumConstants();
        }
        return this.enumConstants;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        TypeElement superDecl;
        A annotation = super.getAnnotation(annotationType);
        if (this.isClass() && annotation == null && annotationType.getAnnotation(Inherited.class) != null && this.getSuperclass() instanceof DeclaredType && (superDecl = (TypeElement)((DeclaredType)this.getSuperclass()).asElement()) != null && !Object.class.getName().equals(superDecl.getQualifiedName().toString())) {
            return superDecl.getAnnotation(annotationType);
        }
        return annotation;
    }

    protected List<PropertyElement> loadProperties(boolean requirePublic) {
        HashMap<String, DecoratedExecutableElement> getters = new HashMap<String, DecoratedExecutableElement>();
        HashMap setters = new HashMap();
        for (ExecutableElement executableElement : this.getMethods()) {
            DecoratedExecutableElement decoratedMethod = (DecoratedExecutableElement)executableElement;
            if (requirePublic && !decoratedMethod.isPublic() || !decoratedMethod.isGetter() && !decoratedMethod.isSetter()) continue;
            HashMap<String, DecoratedExecutableElement> methodMap = decoratedMethod.isGetter() ? getters : setters;
            methodMap.put(decoratedMethod.getPropertyName(), decoratedMethod);
        }
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>(getters.size());
        for (String propertyName : getters.keySet()) {
            DecoratedExecutableElement setter;
            DecoratedExecutableElement getter = (DecoratedExecutableElement)getters.get(propertyName);
            if (this.isPaired(getter, setter = (DecoratedExecutableElement)setters.remove(propertyName))) {
                properties.add(new PropertyElement(getter, setter, this.env));
                continue;
            }
            properties.add(new PropertyElement(getter, null, this.env));
        }
        for (DecoratedExecutableElement setter : setters.values()) {
            properties.add(new PropertyElement(null, setter, this.env));
        }
        return properties;
    }

    protected List<VariableElement> loadEnumConstants() {
        ArrayList<VariableElement> constants = new ArrayList<VariableElement>();
        if (this.isEnum()) {
            List<VariableElement> fields = ElementFilter.fieldsIn(((TypeElement)this.delegate).getEnclosedElements());
            for (VariableElement field : fields) {
                if (field.getKind() != ElementKind.ENUM_CONSTANT) continue;
                constants.add(field);
            }
        }
        return constants;
    }

    protected boolean isPaired(DecoratedExecutableElement getter, DecoratedExecutableElement setter) {
        if (getter == null) {
            return false;
        }
        if (!getter.isGetter()) {
            return false;
        }
        if (getter.getParameters().size() != 0) {
            return false;
        }
        if (setter != null) {
            if (!setter.isSetter()) {
                return false;
            }
            if (!getter.getPropertyName().equals(setter.getPropertyName())) {
                return false;
            }
            List<? extends VariableElement> setterParams = setter.getParameters();
            if (setterParams == null || setterParams.size() != 1 || !this.env.getTypeUtils().isSameType(getter.getReturnType(), setterParams.iterator().next().asType())) {
                return false;
            }
        }
        return true;
    }

    public boolean isClass() {
        return this.getKind() == ElementKind.CLASS;
    }

    public boolean isInterface() {
        return this.getKind() == ElementKind.INTERFACE;
    }

    public boolean isEnum() {
        return this.getKind() == ElementKind.ENUM;
    }

    public boolean isAnnotatedType() {
        return this.getKind() == ElementKind.ANNOTATION_TYPE;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitType(this, p);
    }
}

