/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.javac.decorations.element;

import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import java.util.Collection;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ElementUtils {
    private ElementUtils() {
    }

    public static String findDeprecationMessage(DecoratedElement<?> el) {
        JavaDoc.JavaDocTagList tagList;
        Deprecated deprecation = el.getAnnotation(Deprecated.class);
        String message = null;
        if (deprecation != null) {
            message = "";
        }
        if ((tagList = (JavaDoc.JavaDocTagList)el.getJavaDoc().get("deprecated")) != null) {
            message = tagList.toString();
        }
        return message;
    }

    public static boolean isCollection(TypeElement declaration) {
        if (declaration != null) {
            String fqn = declaration.getQualifiedName().toString();
            if (Collection.class.getName().equals(fqn)) {
                return true;
            }
            if (Object.class.getName().equals(fqn)) {
                return false;
            }
            TypeMirror superclass = declaration.getSuperclass();
            if (superclass instanceof DeclaredType && ElementUtils.isCollection((TypeElement)((DeclaredType)superclass).asElement())) {
                return true;
            }
            for (TypeMirror typeMirror : declaration.getInterfaces()) {
                if (!(typeMirror instanceof DeclaredType) || !ElementUtils.isCollection((TypeElement)((DeclaredType)typeMirror).asElement())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMap(TypeElement declaration) {
        if (declaration != null) {
            String fqn = declaration.getQualifiedName().toString();
            if (Map.class.getName().equals(fqn)) {
                return true;
            }
            if (Object.class.getName().equals(fqn)) {
                return false;
            }
            TypeMirror superclass = declaration.getSuperclass();
            if (superclass instanceof DeclaredType && ElementUtils.isMap((TypeElement)((DeclaredType)superclass).asElement())) {
                return true;
            }
            for (TypeMirror typeMirror : declaration.getInterfaces()) {
                if (!(typeMirror instanceof DeclaredType) || !ElementUtils.isMap((TypeElement)((DeclaredType)typeMirror).asElement())) continue;
                return true;
            }
        }
        return false;
    }
}

