/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.api.impl;

import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.datatype.DataTypeReference;
import com.webcohesion.enunciate.api.services.Fault;
import com.webcohesion.enunciate.api.services.Operation;
import com.webcohesion.enunciate.api.services.Parameter;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.jaxb.api.impl.DataTypeReferenceImpl;
import com.webcohesion.enunciate.modules.jaxws.api.impl.FaultImpl;
import com.webcohesion.enunciate.modules.jaxws.api.impl.ParameterImpl;
import com.webcohesion.enunciate.modules.jaxws.api.impl.ServiceImpl;
import com.webcohesion.enunciate.modules.jaxws.model.WebFault;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.modules.jaxws.model.WebParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class OperationImpl
implements Operation {
    private final WebMethod webMethod;
    private final ServiceImpl service;

    public OperationImpl(WebMethod webMethod, ServiceImpl service) {
        this.webMethod = webMethod;
        this.service = service;
    }

    public String getName() {
        return this.webMethod.getOperationName();
    }

    public String getSlug() {
        return this.service.getSlug() + "_method_" + this.getName();
    }

    public String getDescription() {
        return this.webMethod.getJavaDoc().toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.webMethod);
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.webMethod.getJavaDoc().get((Object)"since");
        return tags == null ? null : tags.toString();
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.webMethod.getJavaDoc().get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public DataTypeReference getReturnType() {
        if (this.webMethod.isOneWay() || this.webMethod.getReturnType().isVoid()) {
            return null;
        }
        return new DataTypeReferenceImpl(this.webMethod.getWebResult().getXmlType(), "unbounded".equals(this.webMethod.getWebResult().getMaxOccurs()));
    }

    public List<? extends Parameter> getInputParameters() {
        ArrayList<ParameterImpl> params = new ArrayList<ParameterImpl>();
        for (WebParam param : this.webMethod.getWebParameters()) {
            if (!param.isInput()) continue;
            params.add(new ParameterImpl(param));
        }
        return params;
    }

    public List<? extends Parameter> getOutputParameters() {
        ArrayList<ParameterImpl> params = new ArrayList<ParameterImpl>();
        for (WebParam param : this.webMethod.getWebParameters()) {
            if (!param.isOutput()) continue;
            params.add(new ParameterImpl(param));
        }
        return params;
    }

    public String getReturnDescription() {
        DecoratedTypeMirror returnType = this.webMethod.getReturnType();
        return returnType.getDocValue();
    }

    public List<? extends Fault> getFaults() {
        ArrayList<FaultImpl> faults = new ArrayList<FaultImpl>();
        for (WebFault webFault : this.webMethod.getWebFaults()) {
            faults.add(new FaultImpl(webFault));
        }
        return faults;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.webMethod.getAnnotations();
    }

    public JavaDoc getJavaDoc() {
        return this.webMethod.getJavaDoc();
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.webMethod), (Map)this.webMethod.getContext().getContext().getConfiguration().getAnnotationStyles());
    }
}

