/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.api.impl;

import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.services.Operation;
import com.webcohesion.enunciate.api.services.Service;
import com.webcohesion.enunciate.api.services.ServiceGroup;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.metadata.Label;
import com.webcohesion.enunciate.modules.jaxws.api.impl.OperationImpl;
import com.webcohesion.enunciate.modules.jaxws.model.EndpointInterface;
import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class ServiceImpl
implements Service {
    private final EndpointInterface ei;
    private final String contextPath;

    public ServiceImpl(EndpointInterface ei, String contextPath) {
        this.ei = ei;
        this.contextPath = contextPath;
    }

    public String getLabel() {
        String tag;
        Label label = (Label)this.ei.getAnnotation(Label.class);
        if (label != null) {
            return label.value();
        }
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.ei.getJavaDoc().get((Object)"label");
        if (tags != null && tags.size() > 0 && !(tag = ((String)tags.get(0)).trim()).isEmpty()) {
            return tag;
        }
        String serviceName = this.ei.getServiceName();
        if (serviceName.equals(this.ei.getSimpleName() + "Service")) {
            serviceName = this.ei.getSimpleName().toString();
        }
        return serviceName;
    }

    public String getPath() {
        return this.contextPath + this.ei.getPath();
    }

    public String getNamespace() {
        return this.ei.getTargetNamespace();
    }

    public ServiceGroup getGroup() {
        return this.ei.getContext().getWsdls().get(this.ei.getTargetNamespace());
    }

    public String getSlug() {
        return "service_" + (String)this.ei.getContext().getJaxbContext().getNamespacePrefixes().get(this.ei.getTargetNamespace()) + "_" + this.ei.getServiceName();
    }

    public String getDescription() {
        return this.ei.getJavaDoc().toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.ei);
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.ei.getJavaDoc().get((Object)"since");
        return tags == null ? null : tags.toString();
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.ei.getJavaDoc().get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public List<? extends Operation> getOperations() {
        ArrayList<OperationImpl> operations = new ArrayList<OperationImpl>();
        for (WebMethod webMethod : this.ei.getWebMethods()) {
            operations.add(new OperationImpl(webMethod, this));
        }
        return operations;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.ei.getAnnotations();
    }

    public JavaDoc getJavaDoc() {
        return this.ei.getJavaDoc();
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.ei), (Map)this.ei.getContext().getContext().getConfiguration().getAnnotationStyles());
    }
}

