/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.mojo;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.module.DocumentationProviderModule;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.WebInfAwareModule;
import com.webcohesion.enunciate.mojo.ConfigMojo;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="assemble", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AssembleBaseMojo
extends ConfigMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", property="enunciate.docsDir", required=true)
    protected String docsDir;
    @Parameter
    protected String docsSubdir;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", property="enunciate.webappDirectory")
    protected String webappDirectory;
    @Parameter(defaultValue="true")
    protected boolean forceWarPackaging = true;
    @Parameter(defaultValue="${basedir}/src/main/webapp/WEB-INF")
    protected String webInfDirectory;

    @Override
    protected void applyAdditionalConfiguration(EnunciateModule module) {
        super.applyAdditionalConfiguration(module);
        if (module instanceof DocumentationProviderModule) {
            DocumentationProviderModule docsProvider = (DocumentationProviderModule)module;
            docsProvider.setDefaultDocsDir(new File(this.docsDir));
            if (this.docsSubdir != null) {
                docsProvider.setDefaultDocsSubdir(this.docsSubdir);
            }
        }
        if (module instanceof WebInfAwareModule) {
            ((WebInfAwareModule)module).setWebInfDir(new File(this.webInfDirectory));
        }
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skipEnunciate) {
            this.getLog().info((CharSequence)"Skipping enunciate per configuration.");
            return;
        }
        if (this.forceWarPackaging && !"war".equalsIgnoreCase(this.project.getPackaging())) {
            throw new MojoExecutionException("The 'assemble' goal requires 'war' packaging.");
        }
        super.execute();
    }

    @Override
    protected void postProcess(Enunciate enunciate) {
        super.postProcess(enunciate);
        File webInfClasses = new File(new File(new File(this.webappDirectory), "WEB-INF"), "classes");
        webInfClasses.mkdirs();
        Set artifacts = enunciate.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!artifact.isBelongsOnServerSideClasspath()) continue;
            try {
                artifact.exportTo(webInfClasses, enunciate);
            }
            catch (IOException e) {
                throw new EnunciateException((Throwable)e);
            }
        }
    }
}

