/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.mojo;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ArtifactType;
import com.webcohesion.enunciate.artifacts.ClientLibraryArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="deploy-artifact", defaultPhase=LifecyclePhase.DEPLOY, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DeployArtifactBaseMojo
extends AbstractMojo
implements Contextualizable {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");
    @Component
    protected ArtifactDeployer deployer;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(required=true)
    protected String enunciateArtifactId;
    @Parameter(defaultValue="${project.distributionManagementArtifactRepository}", readonly=true)
    protected ArtifactRepository deploymentRepository;
    @Parameter(defaultValue="${altDeploymentRepository}")
    protected String altDeploymentRepository;
    protected PlexusContainer container;
    @Parameter(defaultValue="${project.groupId}")
    protected String groupId;
    @Parameter(defaultValue="${project.artifactId}-client")
    protected String artifactId;
    @Parameter(defaultValue="${project.version}")
    protected String version;
    @Parameter(defaultValue="${project.packaging}")
    protected String packaging;
    @Parameter
    protected String description;
    @Component
    protected ArtifactFactory artifactFactory;
    @Parameter
    protected File pomFile;
    @Parameter(defaultValue="true")
    protected boolean generatePom;
    @Parameter
    protected String classifier;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectArtifactMetadata metadata;
        File sshFile;
        ArtifactRepository repo;
        String protocol;
        String artifactName;
        int dotIndex;
        if (this.enunciateArtifactId == null) {
            throw new MojoExecutionException("An enunciate artifact id must be supplied.");
        }
        Enunciate enunciate = (Enunciate)this.getPluginContext().get("com.webcohesion.enunciate.mojo.ConfigMojo#ENUNCIATE_PROPERTY");
        if (enunciate == null) {
            throw new MojoExecutionException("No enunciate mechanism found in the project!");
        }
        Artifact enunciateArtifact = enunciate.findArtifact(this.enunciateArtifactId);
        if (enunciateArtifact == null) {
            throw new MojoExecutionException("Unknown Enunciate artifact: " + this.enunciateArtifactId + ".");
        }
        File mainArtifact = null;
        File sources = null;
        File javadocs = null;
        if (enunciateArtifact instanceof ClientLibraryArtifact) {
            for (Artifact childArtifact : ((ClientLibraryArtifact)enunciateArtifact).getArtifacts()) {
                ArtifactType artifactType;
                if (!(childArtifact instanceof FileArtifact) || (artifactType = ((FileArtifact)childArtifact).getArtifactType()) == null) continue;
                switch (artifactType) {
                    case binaries: {
                        mainArtifact = ((FileArtifact)childArtifact).getFile();
                        break;
                    }
                    case sources: {
                        sources = ((FileArtifact)childArtifact).getFile();
                        break;
                    }
                    case javadocs: {
                        javadocs = ((FileArtifact)childArtifact).getFile();
                    }
                }
            }
        } else if (enunciateArtifact instanceof FileArtifact) {
            mainArtifact = ((FileArtifact)enunciateArtifact).getFile();
        } else {
            try {
                mainArtifact = enunciate.createTempFile(this.enunciateArtifactId, "artifact");
                enunciateArtifact.exportTo(mainArtifact, enunciate);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create a temp file.", (Exception)e);
            }
        }
        if (mainArtifact == null && sources != null) {
            mainArtifact = sources;
            sources = null;
        }
        if (mainArtifact == null) {
            throw new MojoExecutionException("Unable to determine the file to deploy from enunciate artifact " + this.enunciateArtifactId + ".");
        }
        Model model = null;
        if (this.pomFile != null) {
            this.generatePom = false;
            model = this.readModel(this.pomFile);
            this.processModel(model);
        }
        if (this.packaging == null && (dotIndex = (artifactName = mainArtifact.getName()).indexOf(46)) > 0 && dotIndex + 1 < artifactName.length()) {
            this.packaging = artifactName.substring(dotIndex + 1);
        }
        if (this.packaging == null) {
            throw new MojoExecutionException("Unable to determine the packaging of enunciate artifact " + this.enunciateArtifactId + ". Please specify it in the configuration.");
        }
        if (this.version == null) {
            throw new MojoExecutionException("Null version.");
        }
        if (model == null) {
            model = new Model();
            model.setModelVersion("4.0.0");
            model.setGroupId(this.groupId);
            model.setArtifactId(this.artifactId);
            model.setVersion(this.version);
            model.setPackaging(this.packaging);
            model.setDescription(this.description);
        }
        if ((protocol = (repo = this.getDeploymentRepository()).getProtocol()).equals("scp") && !(sshFile = new File(System.getProperty("user.home"), ".ssh")).exists()) {
            sshFile.mkdirs();
        }
        org.apache.maven.artifact.Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        if (this.generatePom) {
            metadata = new ProjectArtifactMetadata(artifact, this.generatePomFile(model));
            artifact.addMetadata((ArtifactMetadata)metadata);
        } else {
            metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        try {
            this.getDeployer().deploy(mainArtifact, artifact, repo, this.localRepository);
            if (sources != null || javadocs != null) {
                MavenProject project = new MavenProject(model);
                project.setArtifact(artifact);
                if (sources != null) {
                    this.projectHelper.attachArtifact(project, artifact.getType(), "sources", sources);
                    this.getDeployer().deploy(sources, (org.apache.maven.artifact.Artifact)project.getAttachedArtifacts().get(0), repo, this.localRepository);
                }
                if (javadocs != null) {
                    this.projectHelper.attachArtifact(project, artifact.getType(), "javadoc", javadocs);
                    this.getDeployer().deploy(javadocs, (org.apache.maven.artifact.Artifact)project.getAttachedArtifacts().get(0), repo, this.localRepository);
                }
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    private ArtifactRepository getDeploymentRepository() throws MojoExecutionException, MojoFailureException {
        if (this.deploymentRepository == null && this.altDeploymentRepository == null) {
            String msg = "Deployment failed: repository element was not specified in the pom inside distributionManagement element or in -DaltDeploymentRepository=id::layout::url parameter";
            throw new MojoExecutionException(msg);
        }
        ArtifactRepository repo = null;
        if (this.altDeploymentRepository != null) {
            ArtifactRepositoryLayout repoLayout;
            this.getLog().info((CharSequence)("Using alternate deployment repository " + this.altDeploymentRepository));
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(this.altDeploymentRepository);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)this.altDeploymentRepository, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::layout::url\".");
            }
            String id = matcher.group(1).trim();
            String layout = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            try {
                repoLayout = (ArtifactRepositoryLayout)this.container.lookup(ArtifactRepositoryLayout.ROLE, layout);
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("Cannot find repository layout: " + layout, (Exception)((Object)e));
            }
            repo = new DefaultArtifactRepository(id, url, repoLayout);
        }
        if (repo == null) {
            repo = this.deploymentRepository;
        }
        return repo;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            if (parent != null && parent.getGroupId() != null) {
                this.groupId = parent.getGroupId();
            }
            if (model.getGroupId() != null) {
                this.groupId = model.getGroupId();
            }
        }
        if (this.artifactId == null && model.getArtifactId() != null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null && model.getVersion() != null) {
            this.version = model.getVersion();
        }
        if (this.packaging == null && model.getPackaging() != null) {
            this.packaging = model.getPackaging();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Model readModel(File pomFile) throws MojoExecutionException {
        Model model;
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Specified pomFile does not exist");
        }
        FileReader reader = null;
        try {
            reader = new FileReader(pomFile);
            MavenXpp3Reader modelReader = new MavenXpp3Reader();
            model = modelReader.read((Reader)reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Error reading specified POM file: " + e.getMessage(), (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Error reading specified POM file: " + e2.getMessage(), (Exception)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new MojoExecutionException("Error reading specified POM file: " + e3.getMessage(), (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return model;
    }

    private File generatePomFile(Model model) throws MojoExecutionException {
        File file;
        FileWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvninstall", ".pom");
            tempFile.deleteOnExit();
            fw = new FileWriter(tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }
}

