/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.Example;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Parameter;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.api.resources.StatusCode;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.spring_web.api.impl.MethodExampleImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ParameterImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.RequestEntityImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResponseEntityImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResponseHeaderParameterImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class MethodImpl
implements Method {
    private final String httpMethod;
    private final RequestMapping requestMapping;
    private final ResourceGroup group;

    public MethodImpl(String httpMethod, RequestMapping requestMapping, ResourceGroup group) {
        this.httpMethod = httpMethod;
        this.requestMapping = requestMapping;
        this.group = group;
    }

    public Resource getResource() {
        return new ResourceImpl(this.requestMapping, this.group);
    }

    public String getLabel() {
        return this.requestMapping.getLabel() == null ? this.httpMethod : this.requestMapping.getLabel();
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getSlug() {
        return this.group.getSlug() + "_" + this.requestMapping.getSimpleName() + "_" + this.httpMethod;
    }

    public String getDescription() {
        return this.requestMapping.getJavaDoc().toString();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.requestMapping);
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.requestMapping.getJavaDoc().get((Object)"since");
        return tags == null ? null : tags.toString();
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.requestMapping.getJavaDoc().get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public boolean isIncludeDefaultParameterValues() {
        for (RequestParameter parameter : this.requestMapping.getRequestParameters()) {
            if (parameter.getDefaultValue() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isHasParameterConstraints() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.getConstraints() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isHasParameterMultiplicity() {
        for (RequestParameter parameter : this.requestMapping.getRequestParameters()) {
            if (!parameter.isMultivalued()) continue;
            return true;
        }
        return false;
    }

    public List<? extends Parameter> getParameters() {
        Set<RequestParameter> resourceParams = this.requestMapping.getRequestParameters();
        ArrayList<ParameterImpl> parameters = new ArrayList<ParameterImpl>(resourceParams.size());
        for (RequestParameter param : resourceParams) {
            parameters.add(new ParameterImpl(param));
        }
        return parameters;
    }

    public Entity getRequestEntity() {
        ResourceEntityParameter entityParameter = this.requestMapping.getEntityParameter();
        return entityParameter == null ? null : new RequestEntityImpl(this.requestMapping, entityParameter);
    }

    public List<? extends StatusCode> getResponseCodes() {
        return this.requestMapping.getStatusCodes();
    }

    public Entity getResponseEntity() {
        ResourceRepresentationMetadata responseMetadata = this.requestMapping.getRepresentationMetadata();
        return responseMetadata == null ? null : new ResponseEntityImpl(this.requestMapping, responseMetadata);
    }

    public List<? extends StatusCode> getWarnings() {
        return this.requestMapping.getWarnings();
    }

    public List<? extends Parameter> getResponseHeaders() {
        Map<String, String> responseHeaders = this.requestMapping.getResponseHeaders();
        ArrayList<ResponseHeaderParameterImpl> headerValues = new ArrayList<ResponseHeaderParameterImpl>();
        for (Map.Entry<String, String> responseHeader : responseHeaders.entrySet()) {
            headerValues.add(new ResponseHeaderParameterImpl(responseHeader.getKey(), responseHeader.getValue(), Collections.<String>emptySet()));
        }
        return headerValues;
    }

    public Set<String> getSecurityRoles() {
        return this.requestMapping.getSecurityRoles();
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.requestMapping.getAnnotations();
    }

    public JavaDoc getJavaDoc() {
        return this.requestMapping.getJavaDoc();
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.requestMapping), (Map)this.requestMapping.getContext().getContext().getConfiguration().getAnnotationStyles());
    }

    public Example getExample() {
        return new MethodExampleImpl(this.httpMethod, this.requestMapping);
    }
}

