/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.spring_web.api.impl.MethodImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class ResourceImpl
implements Resource {
    final RequestMapping requestMapping;
    final ResourceGroup group;

    public ResourceImpl(RequestMapping requestMapping, ResourceGroup group) {
        this.requestMapping = requestMapping;
        this.group = group;
    }

    public String getPath() {
        return this.requestMapping.getFullpath();
    }

    public String getRelativePath() {
        String relativePath = this.getPath();
        while (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    public String getSlug() {
        return this.group.getSlug() + "_" + this.requestMapping.getSimpleName();
    }

    public String getDeprecated() {
        return ElementUtils.findDeprecationMessage((DecoratedElement)this.requestMapping);
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.requestMapping.getJavaDoc().get((Object)"since");
        return tags == null ? null : tags.toString();
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.requestMapping.getJavaDoc().get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public List<? extends Method> getMethods() {
        Set<String> httpMethods = this.requestMapping.getHttpMethods();
        ArrayList<MethodImpl> methodList = new ArrayList<MethodImpl>(httpMethods.size());
        for (String httpMethod : httpMethods) {
            methodList.add(new MethodImpl(httpMethod, this.requestMapping, this.group));
        }
        return methodList;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.requestMapping.getAnnotations();
    }

    public JavaDoc getJavaDoc() {
        return this.requestMapping.getJavaDoc();
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.requestMapping), (Map)this.requestMapping.getContext().getContext().getConfiguration().getAnnotationStyles());
    }
}

