/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.dcat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.Dict;
import eu.trentorise.opendata.traceprov.dcat.ADcatCatalog;
import eu.trentorise.opendata.traceprov.dcat.AFoafAgent;
import eu.trentorise.opendata.traceprov.dcat.ASkosConceptScheme;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class DcatCatalog
extends ADcatCatalog {
    private final Dict description;
    private final String homepage;
    private final String issued;
    private final ImmutableList<Locale> languages;
    private final String license;
    private final String modified;
    private final AFoafAgent publisher;
    private final String rights;
    private final String spatial;
    private final ASkosConceptScheme themes;
    private final Dict title;
    private final String uri;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final DcatCatalog INSTANCE = DcatCatalog.validate(new DcatCatalog());
    private static final long serialVersionUID = 1L;

    private DcatCatalog() {
        this.languages = ImmutableList.of();
        this.description = this.initShim.getDescription();
        this.homepage = this.initShim.getHomepage();
        this.issued = this.initShim.getIssued();
        this.license = this.initShim.getLicense();
        this.modified = this.initShim.getModified();
        this.publisher = this.initShim.getPublisher();
        this.rights = this.initShim.getRights();
        this.spatial = this.initShim.getSpatial();
        this.themes = this.initShim.getThemes();
        this.title = this.initShim.getTitle();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private DcatCatalog(Builder builder) {
        this.languages = builder.languagesBuilder.build();
        if (builder.description != null) {
            this.initShim.setDescription(builder.description);
        }
        if (builder.homepage != null) {
            this.initShim.setHomepage(builder.homepage);
        }
        if (builder.issued != null) {
            this.initShim.setIssued(builder.issued);
        }
        if (builder.license != null) {
            this.initShim.setLicense(builder.license);
        }
        if (builder.modified != null) {
            this.initShim.setModified(builder.modified);
        }
        if (builder.publisher != null) {
            this.initShim.setPublisher(builder.publisher);
        }
        if (builder.rights != null) {
            this.initShim.setRights(builder.rights);
        }
        if (builder.spatial != null) {
            this.initShim.setSpatial(builder.spatial);
        }
        if (builder.themes != null) {
            this.initShim.setThemes(builder.themes);
        }
        if (builder.title != null) {
            this.initShim.setTitle(builder.title);
        }
        if (builder.uri != null) {
            this.initShim.setUri(builder.uri);
        }
        this.description = this.initShim.getDescription();
        this.homepage = this.initShim.getHomepage();
        this.issued = this.initShim.getIssued();
        this.license = this.initShim.getLicense();
        this.modified = this.initShim.getModified();
        this.publisher = this.initShim.getPublisher();
        this.rights = this.initShim.getRights();
        this.spatial = this.initShim.getSpatial();
        this.themes = this.initShim.getThemes();
        this.title = this.initShim.getTitle();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private DcatCatalog(Dict description, String homepage, String issued, ImmutableList<Locale> languages, String license, String modified, AFoafAgent publisher, String rights, String spatial, ASkosConceptScheme themes, Dict title, String uri) {
        this.description = description;
        this.homepage = homepage;
        this.issued = issued;
        this.languages = languages;
        this.license = license;
        this.modified = modified;
        this.publisher = publisher;
        this.rights = rights;
        this.spatial = spatial;
        this.themes = themes;
        this.title = title;
        this.uri = uri;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public Dict getDescription() {
        return this.initShim != null ? this.initShim.getDescription() : this.description;
    }

    @Override
    @JsonProperty
    public String getHomepage() {
        return this.initShim != null ? this.initShim.getHomepage() : this.homepage;
    }

    @Override
    @JsonProperty
    public String getIssued() {
        return this.initShim != null ? this.initShim.getIssued() : this.issued;
    }

    @JsonProperty
    public ImmutableList<Locale> getLanguages() {
        return this.languages;
    }

    @Override
    @JsonProperty
    public String getLicense() {
        return this.initShim != null ? this.initShim.getLicense() : this.license;
    }

    @Override
    @JsonProperty
    public String getModified() {
        return this.initShim != null ? this.initShim.getModified() : this.modified;
    }

    @Override
    @JsonProperty
    public AFoafAgent getPublisher() {
        return this.initShim != null ? this.initShim.getPublisher() : this.publisher;
    }

    @Override
    @JsonProperty
    public String getRights() {
        return this.initShim != null ? this.initShim.getRights() : this.rights;
    }

    @Override
    @JsonProperty
    public String getSpatial() {
        return this.initShim != null ? this.initShim.getSpatial() : this.spatial;
    }

    @Override
    @JsonProperty
    public ASkosConceptScheme getThemes() {
        return this.initShim != null ? this.initShim.getThemes() : this.themes;
    }

    @Override
    @JsonProperty
    public Dict getTitle() {
        return this.initShim != null ? this.initShim.getTitle() : this.title;
    }

    @Override
    @JsonProperty
    public String getUri() {
        return this.initShim != null ? this.initShim.getUri() : this.uri;
    }

    public final DcatCatalog withDescription(Dict value) {
        if (this.description == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(newValue, this.homepage, this.issued, this.languages, this.license, this.modified, this.publisher, this.rights, this.spatial, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withHomepage(String value) {
        if (this.homepage == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, newValue, this.issued, this.languages, this.license, this.modified, this.publisher, this.rights, this.spatial, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withIssued(String value) {
        if (this.issued == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, newValue, this.languages, this.license, this.modified, this.publisher, this.rights, this.spatial, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withLanguages(Locale ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, (ImmutableList<Locale>)newValue, this.license, this.modified, this.publisher, this.rights, this.spatial, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withLanguages(Iterable<? extends Locale> elements) {
        if (this.languages == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, (ImmutableList<Locale>)newValue, this.license, this.modified, this.publisher, this.rights, this.spatial, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withLicense(String value) {
        if (this.license == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, this.languages, newValue, this.modified, this.publisher, this.rights, this.spatial, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withModified(String value) {
        if (this.modified == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, this.languages, this.license, newValue, this.publisher, this.rights, this.spatial, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withPublisher(AFoafAgent value) {
        if (this.publisher == value) {
            return this;
        }
        AFoafAgent newValue = (AFoafAgent)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, this.languages, this.license, this.modified, newValue, this.rights, this.spatial, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withRights(String value) {
        if (this.rights == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, this.languages, this.license, this.modified, this.publisher, newValue, this.spatial, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withSpatial(String value) {
        if (this.spatial == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, this.languages, this.license, this.modified, this.publisher, this.rights, newValue, this.themes, this.title, this.uri));
    }

    public final DcatCatalog withThemes(ASkosConceptScheme value) {
        if (this.themes == value) {
            return this;
        }
        ASkosConceptScheme newValue = (ASkosConceptScheme)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, this.languages, this.license, this.modified, this.publisher, this.rights, this.spatial, newValue, this.title, this.uri));
    }

    public final DcatCatalog withTitle(Dict value) {
        if (this.title == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, this.languages, this.license, this.modified, this.publisher, this.rights, this.spatial, this.themes, newValue, this.uri));
    }

    public final DcatCatalog withUri(String value) {
        if (this.uri == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return DcatCatalog.validate(new DcatCatalog(this.description, this.homepage, this.issued, this.languages, this.license, this.modified, this.publisher, this.rights, this.spatial, this.themes, this.title, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DcatCatalog && this.equalTo((DcatCatalog)another);
    }

    private boolean equalTo(DcatCatalog another) {
        return this.description.equals((Object)another.description) && this.homepage.equals(another.homepage) && this.issued.equals(another.issued) && this.languages.equals(another.languages) && this.license.equals(another.license) && this.modified.equals(another.modified) && this.publisher.equals(another.publisher) && this.rights.equals(another.rights) && this.spatial.equals(another.spatial) && this.themes.equals(another.themes) && this.title.equals((Object)another.title) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.description.hashCode();
        h = h * 17 + this.homepage.hashCode();
        h = h * 17 + this.issued.hashCode();
        h = h * 17 + this.languages.hashCode();
        h = h * 17 + this.license.hashCode();
        h = h * 17 + this.modified.hashCode();
        h = h * 17 + this.publisher.hashCode();
        h = h * 17 + this.rights.hashCode();
        h = h * 17 + this.spatial.hashCode();
        h = h * 17 + this.themes.hashCode();
        h = h * 17 + this.title.hashCode();
        h = h * 17 + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DcatCatalog").add("description", (Object)this.description).add("homepage", (Object)this.homepage).add("issued", (Object)this.issued).add("languages", this.languages).add("license", (Object)this.license).add("modified", (Object)this.modified).add("publisher", (Object)this.publisher).add("rights", (Object)this.rights).add("spatial", (Object)this.spatial).add("themes", (Object)this.themes).add("title", (Object)this.title).add("uri", (Object)this.uri).toString();
    }

    @Deprecated
    @JsonCreator
    static DcatCatalog fromJson(Json json) {
        Builder builder = DcatCatalog.builder();
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.homepage != null) {
            builder.setHomepage(json.homepage);
        }
        if (json.issued != null) {
            builder.setIssued(json.issued);
        }
        if (json.languages != null) {
            builder.addAllLanguages(json.languages);
        }
        if (json.license != null) {
            builder.setLicense(json.license);
        }
        if (json.modified != null) {
            builder.setModified(json.modified);
        }
        if (json.publisher != null) {
            builder.setPublisher(json.publisher);
        }
        if (json.rights != null) {
            builder.setRights(json.rights);
        }
        if (json.spatial != null) {
            builder.setSpatial(json.spatial);
        }
        if (json.themes != null) {
            builder.setThemes(json.themes);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.uri != null) {
            builder.setUri(json.uri);
        }
        return builder.build();
    }

    public static DcatCatalog of() {
        return INSTANCE;
    }

    private static DcatCatalog validate(DcatCatalog instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static DcatCatalog copyOf(DcatCatalog instance) {
        if (instance instanceof DcatCatalog) {
            return instance;
        }
        return DcatCatalog.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return DcatCatalog.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Dict description;
        @Nullable
        private String homepage;
        @Nullable
        private String issued;
        private ImmutableList.Builder<Locale> languagesBuilder = ImmutableList.builder();
        @Nullable
        private String license;
        @Nullable
        private String modified;
        @Nullable
        private AFoafAgent publisher;
        @Nullable
        private String rights;
        @Nullable
        private String spatial;
        @Nullable
        private ASkosConceptScheme themes;
        @Nullable
        private Dict title;
        @Nullable
        private String uri;

        private Builder() {
        }

        public final Builder from(DcatCatalog instance) {
            Preconditions.checkNotNull((Object)instance);
            this.setDescription(instance.getDescription());
            this.setHomepage(instance.getHomepage());
            this.setIssued(instance.getIssued());
            this.addAllLanguages((Iterable<? extends Locale>)instance.getLanguages());
            this.setLicense(instance.getLicense());
            this.setModified(instance.getModified());
            this.setPublisher(instance.getPublisher());
            this.setRights(instance.getRights());
            this.setSpatial(instance.getSpatial());
            this.setThemes(instance.getThemes());
            this.setTitle(instance.getTitle());
            this.setUri(instance.getUri());
            return this;
        }

        public final Builder setDescription(Dict description) {
            this.description = (Dict)Preconditions.checkNotNull((Object)description);
            return this;
        }

        public final Builder setHomepage(String homepage) {
            this.homepage = (String)Preconditions.checkNotNull((Object)homepage);
            return this;
        }

        public final Builder setIssued(String issued) {
            this.issued = (String)Preconditions.checkNotNull((Object)issued);
            return this;
        }

        public final Builder addLanguages(Locale element) {
            this.languagesBuilder.add((Object)element);
            return this;
        }

        public final Builder addLanguages(Locale ... elements) {
            this.languagesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder setLanguages(Iterable<? extends Locale> elements) {
            this.languagesBuilder = ImmutableList.builder();
            return this.addAllLanguages(elements);
        }

        public final Builder addAllLanguages(Iterable<? extends Locale> elements) {
            this.languagesBuilder.addAll(elements);
            return this;
        }

        public final Builder setLicense(String license) {
            this.license = (String)Preconditions.checkNotNull((Object)license);
            return this;
        }

        public final Builder setModified(String modified) {
            this.modified = (String)Preconditions.checkNotNull((Object)modified);
            return this;
        }

        public final Builder setPublisher(AFoafAgent publisher) {
            this.publisher = (AFoafAgent)Preconditions.checkNotNull((Object)publisher);
            return this;
        }

        public final Builder setRights(String rights) {
            this.rights = (String)Preconditions.checkNotNull((Object)rights);
            return this;
        }

        public final Builder setSpatial(String spatial) {
            this.spatial = (String)Preconditions.checkNotNull((Object)spatial);
            return this;
        }

        public final Builder setThemes(ASkosConceptScheme themes) {
            this.themes = (ASkosConceptScheme)Preconditions.checkNotNull((Object)themes);
            return this;
        }

        public final Builder setTitle(Dict title) {
            this.title = (Dict)Preconditions.checkNotNull((Object)title);
            return this;
        }

        public final Builder setUri(String uri) {
            this.uri = (String)Preconditions.checkNotNull((Object)uri);
            return this;
        }

        public DcatCatalog build() throws IllegalStateException {
            return DcatCatalog.validate(new DcatCatalog(this));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        Dict description;
        @JsonProperty
        @Nullable
        String homepage;
        @JsonProperty
        @Nullable
        String issued;
        @JsonProperty
        @Nullable
        List<Locale> languages;
        @JsonProperty
        @Nullable
        String license;
        @JsonProperty
        @Nullable
        String modified;
        @JsonProperty
        @Nullable
        AFoafAgent publisher;
        @JsonProperty
        @Nullable
        String rights;
        @JsonProperty
        @Nullable
        String spatial;
        @JsonProperty
        @Nullable
        ASkosConceptScheme themes;
        @JsonProperty
        @Nullable
        Dict title;
        @JsonProperty
        @Nullable
        String uri;

        Json() {
        }
    }

    private final class InitShim {
        private Dict description;
        private byte descriptionStage;
        private String homepage;
        private byte homepageStage;
        private String issued;
        private byte issuedStage;
        private String license;
        private byte licenseStage;
        private String modified;
        private byte modifiedStage;
        private AFoafAgent publisher;
        private byte publisherStage;
        private String rights;
        private byte rightsStage;
        private String spatial;
        private byte spatialStage;
        private ASkosConceptScheme themes;
        private byte themesStage;
        private Dict title;
        private byte titleStage;
        private String uri;
        private byte uriStage;

        private InitShim() {
        }

        Dict getDescription() {
            if (this.descriptionStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descriptionStage == 0) {
                this.descriptionStage = (byte)-1;
                this.description = (Dict)Preconditions.checkNotNull((Object)DcatCatalog.super.getDescription());
                this.descriptionStage = 1;
            }
            return this.description;
        }

        Dict setDescription(Dict value) {
            this.description = value;
            this.descriptionStage = 1;
            return value;
        }

        String getHomepage() {
            if (this.homepageStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.homepageStage == 0) {
                this.homepageStage = (byte)-1;
                this.homepage = (String)Preconditions.checkNotNull((Object)DcatCatalog.super.getHomepage());
                this.homepageStage = 1;
            }
            return this.homepage;
        }

        String setHomepage(String value) {
            this.homepage = value;
            this.homepageStage = 1;
            return value;
        }

        String getIssued() {
            if (this.issuedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.issuedStage == 0) {
                this.issuedStage = (byte)-1;
                this.issued = (String)Preconditions.checkNotNull((Object)DcatCatalog.super.getIssued());
                this.issuedStage = 1;
            }
            return this.issued;
        }

        String setIssued(String value) {
            this.issued = value;
            this.issuedStage = 1;
            return value;
        }

        String getLicense() {
            if (this.licenseStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.licenseStage == 0) {
                this.licenseStage = (byte)-1;
                this.license = (String)Preconditions.checkNotNull((Object)DcatCatalog.super.getLicense());
                this.licenseStage = 1;
            }
            return this.license;
        }

        String setLicense(String value) {
            this.license = value;
            this.licenseStage = 1;
            return value;
        }

        String getModified() {
            if (this.modifiedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modifiedStage == 0) {
                this.modifiedStage = (byte)-1;
                this.modified = (String)Preconditions.checkNotNull((Object)DcatCatalog.super.getModified());
                this.modifiedStage = 1;
            }
            return this.modified;
        }

        String setModified(String value) {
            this.modified = value;
            this.modifiedStage = 1;
            return value;
        }

        AFoafAgent getPublisher() {
            if (this.publisherStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.publisherStage == 0) {
                this.publisherStage = (byte)-1;
                this.publisher = (AFoafAgent)Preconditions.checkNotNull((Object)DcatCatalog.super.getPublisher());
                this.publisherStage = 1;
            }
            return this.publisher;
        }

        AFoafAgent setPublisher(AFoafAgent value) {
            this.publisher = value;
            this.publisherStage = 1;
            return value;
        }

        String getRights() {
            if (this.rightsStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rightsStage == 0) {
                this.rightsStage = (byte)-1;
                this.rights = (String)Preconditions.checkNotNull((Object)DcatCatalog.super.getRights());
                this.rightsStage = 1;
            }
            return this.rights;
        }

        String setRights(String value) {
            this.rights = value;
            this.rightsStage = 1;
            return value;
        }

        String getSpatial() {
            if (this.spatialStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spatialStage == 0) {
                this.spatialStage = (byte)-1;
                this.spatial = (String)Preconditions.checkNotNull((Object)DcatCatalog.super.getSpatial());
                this.spatialStage = 1;
            }
            return this.spatial;
        }

        String setSpatial(String value) {
            this.spatial = value;
            this.spatialStage = 1;
            return value;
        }

        ASkosConceptScheme getThemes() {
            if (this.themesStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.themesStage == 0) {
                this.themesStage = (byte)-1;
                this.themes = (ASkosConceptScheme)Preconditions.checkNotNull((Object)DcatCatalog.super.getThemes());
                this.themesStage = 1;
            }
            return this.themes;
        }

        ASkosConceptScheme setThemes(ASkosConceptScheme value) {
            this.themes = value;
            this.themesStage = 1;
            return value;
        }

        Dict getTitle() {
            if (this.titleStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.titleStage == 0) {
                this.titleStage = (byte)-1;
                this.title = (Dict)Preconditions.checkNotNull((Object)DcatCatalog.super.getTitle());
                this.titleStage = 1;
            }
            return this.title;
        }

        Dict setTitle(Dict value) {
            this.title = value;
            this.titleStage = 1;
            return value;
        }

        String getUri() {
            if (this.uriStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriStage == 0) {
                this.uriStage = (byte)-1;
                this.uri = (String)Preconditions.checkNotNull((Object)DcatCatalog.super.getUri());
                this.uriStage = 1;
            }
            return this.uri;
        }

        String setUri(String value) {
            this.uri = value;
            this.uriStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.descriptionStage == -1) {
                attributes.add("description");
            }
            if (this.homepageStage == -1) {
                attributes.add("homepage");
            }
            if (this.issuedStage == -1) {
                attributes.add("issued");
            }
            if (this.licenseStage == -1) {
                attributes.add("license");
            }
            if (this.modifiedStage == -1) {
                attributes.add("modified");
            }
            if (this.publisherStage == -1) {
                attributes.add("publisher");
            }
            if (this.rightsStage == -1) {
                attributes.add("rights");
            }
            if (this.spatialStage == -1) {
                attributes.add("spatial");
            }
            if (this.themesStage == -1) {
                attributes.add("themes");
            }
            if (this.titleStage == -1) {
                attributes.add("title");
            }
            if (this.uriStage == -1) {
                attributes.add("uri");
            }
            return "Cannot build DcatCatalog, attribute initializers form cycle" + attributes;
        }
    }
}

