/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.dcat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.commons.Dict;
import eu.trentorise.opendata.traceprov.dcat.ASkosConcept;
import eu.trentorise.opendata.traceprov.dcat.SkosConceptScheme;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class SkosConcept
extends ASkosConcept {
    private final SkosConceptScheme inScheme;
    private final Dict prefLabel;
    private final String uri;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final SkosConcept INSTANCE = SkosConcept.validate(new SkosConcept());
    private static final long serialVersionUID = 1L;

    private SkosConcept() {
        this.inScheme = this.initShim.getInScheme();
        this.prefLabel = this.initShim.getPrefLabel();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private SkosConcept(SkosConceptScheme inScheme, Dict prefLabel, String uri) {
        this.inScheme = (SkosConceptScheme)Preconditions.checkNotNull((Object)inScheme);
        this.prefLabel = (Dict)Preconditions.checkNotNull((Object)prefLabel);
        this.uri = (String)Preconditions.checkNotNull((Object)uri);
        this.initShim = null;
    }

    private SkosConcept(Builder builder) {
        if (builder.inScheme != null) {
            this.initShim.setInScheme(builder.inScheme);
        }
        if (builder.prefLabel != null) {
            this.initShim.setPrefLabel(builder.prefLabel);
        }
        if (builder.uri != null) {
            this.initShim.setUri(builder.uri);
        }
        this.inScheme = this.initShim.getInScheme();
        this.prefLabel = this.initShim.getPrefLabel();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private SkosConcept(SkosConcept original, SkosConceptScheme inScheme, Dict prefLabel, String uri) {
        this.inScheme = inScheme;
        this.prefLabel = prefLabel;
        this.uri = uri;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public SkosConceptScheme getInScheme() {
        return this.initShim != null ? this.initShim.getInScheme() : this.inScheme;
    }

    @Override
    @JsonProperty
    public Dict getPrefLabel() {
        return this.initShim != null ? this.initShim.getPrefLabel() : this.prefLabel;
    }

    @Override
    @JsonProperty
    public String getUri() {
        return this.initShim != null ? this.initShim.getUri() : this.uri;
    }

    public final SkosConcept withInScheme(SkosConceptScheme value) {
        if (this.inScheme == value) {
            return this;
        }
        SkosConceptScheme newValue = (SkosConceptScheme)Preconditions.checkNotNull((Object)value);
        return SkosConcept.validate(new SkosConcept(this, newValue, this.prefLabel, this.uri));
    }

    public final SkosConcept withPrefLabel(Dict value) {
        if (this.prefLabel == value) {
            return this;
        }
        Dict newValue = (Dict)Preconditions.checkNotNull((Object)value);
        return SkosConcept.validate(new SkosConcept(this, this.inScheme, newValue, this.uri));
    }

    public final SkosConcept withUri(String value) {
        if (this.uri == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return SkosConcept.validate(new SkosConcept(this, this.inScheme, this.prefLabel, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SkosConcept && this.equalTo((SkosConcept)another);
    }

    private boolean equalTo(SkosConcept another) {
        return this.inScheme.equals(another.inScheme) && this.prefLabel.equals((Object)another.prefLabel) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.inScheme.hashCode();
        h = h * 17 + this.prefLabel.hashCode();
        h = h * 17 + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SkosConcept").add("inScheme", (Object)this.inScheme).add("prefLabel", (Object)this.prefLabel).add("uri", (Object)this.uri).toString();
    }

    @Deprecated
    @JsonCreator
    static SkosConcept fromJson(Json json) {
        Builder builder = SkosConcept.builder();
        if (json.inScheme != null) {
            builder.setInScheme(json.inScheme);
        }
        if (json.prefLabel != null) {
            builder.setPrefLabel(json.prefLabel);
        }
        if (json.uri != null) {
            builder.setUri(json.uri);
        }
        return builder.build();
    }

    public static SkosConcept of() {
        return INSTANCE;
    }

    public static SkosConcept of(SkosConceptScheme inScheme, Dict prefLabel, String uri) {
        return SkosConcept.validate(new SkosConcept(inScheme, prefLabel, uri));
    }

    private static SkosConcept validate(SkosConcept instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static SkosConcept copyOf(SkosConcept instance) {
        if (instance instanceof SkosConcept) {
            return instance;
        }
        return SkosConcept.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return SkosConcept.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private SkosConceptScheme inScheme;
        @Nullable
        private Dict prefLabel;
        @Nullable
        private String uri;

        private Builder() {
        }

        public final Builder from(SkosConcept instance) {
            Preconditions.checkNotNull((Object)instance);
            this.setInScheme(instance.getInScheme());
            this.setPrefLabel(instance.getPrefLabel());
            this.setUri(instance.getUri());
            return this;
        }

        public final Builder setInScheme(SkosConceptScheme inScheme) {
            this.inScheme = (SkosConceptScheme)Preconditions.checkNotNull((Object)inScheme);
            return this;
        }

        public final Builder setPrefLabel(Dict prefLabel) {
            this.prefLabel = (Dict)Preconditions.checkNotNull((Object)prefLabel);
            return this;
        }

        public final Builder setUri(String uri) {
            this.uri = (String)Preconditions.checkNotNull((Object)uri);
            return this;
        }

        public SkosConcept build() throws IllegalStateException {
            return SkosConcept.validate(new SkosConcept(this));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        SkosConceptScheme inScheme;
        @JsonProperty
        @Nullable
        Dict prefLabel;
        @JsonProperty
        @Nullable
        String uri;

        Json() {
        }
    }

    private final class InitShim {
        private SkosConceptScheme inScheme;
        private byte inSchemeStage;
        private Dict prefLabel;
        private byte prefLabelStage;
        private String uri;
        private byte uriStage;

        private InitShim() {
        }

        SkosConceptScheme getInScheme() {
            if (this.inSchemeStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inSchemeStage == 0) {
                this.inSchemeStage = (byte)-1;
                this.inScheme = (SkosConceptScheme)Preconditions.checkNotNull((Object)SkosConcept.super.getInScheme());
                this.inSchemeStage = 1;
            }
            return this.inScheme;
        }

        SkosConceptScheme setInScheme(SkosConceptScheme value) {
            this.inScheme = value;
            this.inSchemeStage = 1;
            return value;
        }

        Dict getPrefLabel() {
            if (this.prefLabelStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.prefLabelStage == 0) {
                this.prefLabelStage = (byte)-1;
                this.prefLabel = (Dict)Preconditions.checkNotNull((Object)SkosConcept.super.getPrefLabel());
                this.prefLabelStage = 1;
            }
            return this.prefLabel;
        }

        Dict setPrefLabel(Dict value) {
            this.prefLabel = value;
            this.prefLabelStage = 1;
            return value;
        }

        String getUri() {
            if (this.uriStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriStage == 0) {
                this.uriStage = (byte)-1;
                this.uri = (String)Preconditions.checkNotNull((Object)SkosConcept.super.getUri());
                this.uriStage = 1;
            }
            return this.uri;
        }

        String setUri(String value) {
            this.uri = value;
            this.uriStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.inSchemeStage == -1) {
                attributes.add("inScheme");
            }
            if (this.prefLabelStage == -1) {
                attributes.add("prefLabel");
            }
            if (this.uriStage == -1) {
                attributes.add("uri");
            }
            return "Cannot build SkosConcept, attribute initializers form cycle" + attributes;
        }
    }
}

