/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.dcat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.traceprov.dcat.ASkosConceptScheme;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class SkosConceptScheme
extends ASkosConceptScheme {
    private final String prefLabel;
    private final String uri;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final SkosConceptScheme INSTANCE = SkosConceptScheme.validate(new SkosConceptScheme());
    private static final long serialVersionUID = 1L;

    private SkosConceptScheme() {
        this.prefLabel = this.initShim.getPrefLabel();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private SkosConceptScheme(String prefLabel, String uri) {
        this.prefLabel = (String)Preconditions.checkNotNull((Object)prefLabel);
        this.uri = (String)Preconditions.checkNotNull((Object)uri);
        this.initShim = null;
    }

    private SkosConceptScheme(Builder builder) {
        if (builder.prefLabel != null) {
            this.initShim.setPrefLabel(builder.prefLabel);
        }
        if (builder.uri != null) {
            this.initShim.setUri(builder.uri);
        }
        this.prefLabel = this.initShim.getPrefLabel();
        this.uri = this.initShim.getUri();
        this.initShim = null;
    }

    private SkosConceptScheme(SkosConceptScheme original, String prefLabel, String uri) {
        this.prefLabel = prefLabel;
        this.uri = uri;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getPrefLabel() {
        return this.initShim != null ? this.initShim.getPrefLabel() : this.prefLabel;
    }

    @Override
    @JsonProperty
    public String getUri() {
        return this.initShim != null ? this.initShim.getUri() : this.uri;
    }

    public final SkosConceptScheme withPrefLabel(String value) {
        if (this.prefLabel == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return SkosConceptScheme.validate(new SkosConceptScheme(this, newValue, this.uri));
    }

    public final SkosConceptScheme withUri(String value) {
        if (this.uri == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return SkosConceptScheme.validate(new SkosConceptScheme(this, this.prefLabel, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SkosConceptScheme && this.equalTo((SkosConceptScheme)another);
    }

    private boolean equalTo(SkosConceptScheme another) {
        return this.prefLabel.equals(another.prefLabel) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.prefLabel.hashCode();
        h = h * 17 + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SkosConceptScheme").add("prefLabel", (Object)this.prefLabel).add("uri", (Object)this.uri).toString();
    }

    @Deprecated
    @JsonCreator
    static SkosConceptScheme fromJson(Json json) {
        Builder builder = SkosConceptScheme.builder();
        if (json.prefLabel != null) {
            builder.setPrefLabel(json.prefLabel);
        }
        if (json.uri != null) {
            builder.setUri(json.uri);
        }
        return builder.build();
    }

    public static SkosConceptScheme of() {
        return INSTANCE;
    }

    public static SkosConceptScheme of(String prefLabel, String uri) {
        return SkosConceptScheme.validate(new SkosConceptScheme(prefLabel, uri));
    }

    private static SkosConceptScheme validate(SkosConceptScheme instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static SkosConceptScheme copyOf(SkosConceptScheme instance) {
        if (instance instanceof SkosConceptScheme) {
            return instance;
        }
        return SkosConceptScheme.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return SkosConceptScheme.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String prefLabel;
        @Nullable
        private String uri;

        private Builder() {
        }

        public final Builder from(SkosConceptScheme instance) {
            Preconditions.checkNotNull((Object)instance);
            this.setPrefLabel(instance.getPrefLabel());
            this.setUri(instance.getUri());
            return this;
        }

        public final Builder setPrefLabel(String prefLabel) {
            this.prefLabel = (String)Preconditions.checkNotNull((Object)prefLabel);
            return this;
        }

        public final Builder setUri(String uri) {
            this.uri = (String)Preconditions.checkNotNull((Object)uri);
            return this;
        }

        public SkosConceptScheme build() throws IllegalStateException {
            return SkosConceptScheme.validate(new SkosConceptScheme(this));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String prefLabel;
        @JsonProperty
        @Nullable
        String uri;

        Json() {
        }
    }

    private final class InitShim {
        private String prefLabel;
        private byte prefLabelStage;
        private String uri;
        private byte uriStage;

        private InitShim() {
        }

        String getPrefLabel() {
            if (this.prefLabelStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.prefLabelStage == 0) {
                this.prefLabelStage = (byte)-1;
                this.prefLabel = (String)Preconditions.checkNotNull((Object)SkosConceptScheme.super.getPrefLabel());
                this.prefLabelStage = 1;
            }
            return this.prefLabel;
        }

        String setPrefLabel(String value) {
            this.prefLabel = value;
            this.prefLabelStage = 1;
            return value;
        }

        String getUri() {
            if (this.uriStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriStage == 0) {
                this.uriStage = (byte)-1;
                this.uri = (String)Preconditions.checkNotNull((Object)SkosConceptScheme.super.getUri());
                this.uriStage = 1;
            }
            return this.uri;
        }

        String setUri(String value) {
            this.uri = value;
            this.uriStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.prefLabelStage == -1) {
                attributes.add("prefLabel");
            }
            if (this.uriStage == -1) {
                attributes.add("uri");
            }
            return "Cannot build SkosConceptScheme, attribute initializers form cycle" + attributes;
        }
    }
}

