/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.dcat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.traceprov.dcat.AVCard;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class VCard
extends AVCard {
    private final String uri;
    private final String fn;
    private final String adr;
    private final String email;
    private final String tel;
    private final String org;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final VCard INSTANCE = VCard.validate(new VCard());
    private static final long serialVersionUID = 1L;

    private VCard() {
        this.uri = this.initShim.getUri();
        this.fn = this.initShim.getFn();
        this.adr = this.initShim.getAdr();
        this.email = this.initShim.getEmail();
        this.tel = this.initShim.getTel();
        this.org = this.initShim.getOrg();
        this.initShim = null;
    }

    private VCard(Builder builder) {
        if (builder.uri != null) {
            this.initShim.setUri(builder.uri);
        }
        if (builder.fn != null) {
            this.initShim.setFn(builder.fn);
        }
        if (builder.adr != null) {
            this.initShim.setAdr(builder.adr);
        }
        if (builder.email != null) {
            this.initShim.setEmail(builder.email);
        }
        if (builder.tel != null) {
            this.initShim.setTel(builder.tel);
        }
        if (builder.org != null) {
            this.initShim.setOrg(builder.org);
        }
        this.uri = this.initShim.getUri();
        this.fn = this.initShim.getFn();
        this.adr = this.initShim.getAdr();
        this.email = this.initShim.getEmail();
        this.tel = this.initShim.getTel();
        this.org = this.initShim.getOrg();
        this.initShim = null;
    }

    private VCard(String uri, String fn, String adr, String email, String tel, String org) {
        this.uri = uri;
        this.fn = fn;
        this.adr = adr;
        this.email = email;
        this.tel = tel;
        this.org = org;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getUri() {
        return this.initShim != null ? this.initShim.getUri() : this.uri;
    }

    @Override
    @JsonProperty
    public String getFn() {
        return this.initShim != null ? this.initShim.getFn() : this.fn;
    }

    @Override
    @JsonProperty
    public String getAdr() {
        return this.initShim != null ? this.initShim.getAdr() : this.adr;
    }

    @Override
    @JsonProperty
    public String getEmail() {
        return this.initShim != null ? this.initShim.getEmail() : this.email;
    }

    @Override
    @JsonProperty
    public String getTel() {
        return this.initShim != null ? this.initShim.getTel() : this.tel;
    }

    @Override
    @JsonProperty
    public String getOrg() {
        return this.initShim != null ? this.initShim.getOrg() : this.org;
    }

    public final VCard withUri(String value) {
        if (this.uri == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return VCard.validate(new VCard(newValue, this.fn, this.adr, this.email, this.tel, this.org));
    }

    public final VCard withFn(String value) {
        if (this.fn == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return VCard.validate(new VCard(this.uri, newValue, this.adr, this.email, this.tel, this.org));
    }

    public final VCard withAdr(String value) {
        if (this.adr == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return VCard.validate(new VCard(this.uri, this.fn, newValue, this.email, this.tel, this.org));
    }

    public final VCard withEmail(String value) {
        if (this.email == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return VCard.validate(new VCard(this.uri, this.fn, this.adr, newValue, this.tel, this.org));
    }

    public final VCard withTel(String value) {
        if (this.tel == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return VCard.validate(new VCard(this.uri, this.fn, this.adr, this.email, newValue, this.org));
    }

    public final VCard withOrg(String value) {
        if (this.org == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return VCard.validate(new VCard(this.uri, this.fn, this.adr, this.email, this.tel, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof VCard && this.equalTo((VCard)another);
    }

    private boolean equalTo(VCard another) {
        return this.uri.equals(another.uri) && this.fn.equals(another.fn) && this.adr.equals(another.adr) && this.email.equals(another.email) && this.tel.equals(another.tel) && this.org.equals(another.org);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.uri.hashCode();
        h = h * 17 + this.fn.hashCode();
        h = h * 17 + this.adr.hashCode();
        h = h * 17 + this.email.hashCode();
        h = h * 17 + this.tel.hashCode();
        h = h * 17 + this.org.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"VCard").add("uri", (Object)this.uri).add("fn", (Object)this.fn).add("adr", (Object)this.adr).add("email", (Object)this.email).add("tel", (Object)this.tel).add("org", (Object)this.org).toString();
    }

    @Deprecated
    @JsonCreator
    static VCard fromJson(Json json) {
        Builder builder = VCard.builder();
        if (json.uri != null) {
            builder.setUri(json.uri);
        }
        if (json.fn != null) {
            builder.setFn(json.fn);
        }
        if (json.adr != null) {
            builder.setAdr(json.adr);
        }
        if (json.email != null) {
            builder.setEmail(json.email);
        }
        if (json.tel != null) {
            builder.setTel(json.tel);
        }
        if (json.org != null) {
            builder.setOrg(json.org);
        }
        return builder.build();
    }

    public static VCard of() {
        return INSTANCE;
    }

    private static VCard validate(VCard instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static VCard copyOf(VCard instance) {
        if (instance instanceof VCard) {
            return instance;
        }
        return VCard.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return VCard.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String uri;
        @Nullable
        private String fn;
        @Nullable
        private String adr;
        @Nullable
        private String email;
        @Nullable
        private String tel;
        @Nullable
        private String org;

        private Builder() {
        }

        public final Builder from(VCard instance) {
            Preconditions.checkNotNull((Object)instance);
            this.setUri(instance.getUri());
            this.setFn(instance.getFn());
            this.setAdr(instance.getAdr());
            this.setEmail(instance.getEmail());
            this.setTel(instance.getTel());
            this.setOrg(instance.getOrg());
            return this;
        }

        public final Builder setUri(String uri) {
            this.uri = (String)Preconditions.checkNotNull((Object)uri);
            return this;
        }

        public final Builder setFn(String fn) {
            this.fn = (String)Preconditions.checkNotNull((Object)fn);
            return this;
        }

        public final Builder setAdr(String adr) {
            this.adr = (String)Preconditions.checkNotNull((Object)adr);
            return this;
        }

        public final Builder setEmail(String email) {
            this.email = (String)Preconditions.checkNotNull((Object)email);
            return this;
        }

        public final Builder setTel(String tel) {
            this.tel = (String)Preconditions.checkNotNull((Object)tel);
            return this;
        }

        public final Builder setOrg(String org) {
            this.org = (String)Preconditions.checkNotNull((Object)org);
            return this;
        }

        public VCard build() throws IllegalStateException {
            return VCard.validate(new VCard(this));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String uri;
        @JsonProperty
        @Nullable
        String fn;
        @JsonProperty
        @Nullable
        String adr;
        @JsonProperty
        @Nullable
        String email;
        @JsonProperty
        @Nullable
        String tel;
        @JsonProperty
        @Nullable
        String org;

        Json() {
        }
    }

    private final class InitShim {
        private String uri;
        private byte uriStage;
        private String fn;
        private byte fnStage;
        private String adr;
        private byte adrStage;
        private String email;
        private byte emailStage;
        private String tel;
        private byte telStage;
        private String org;
        private byte orgStage;

        private InitShim() {
        }

        String getUri() {
            if (this.uriStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriStage == 0) {
                this.uriStage = (byte)-1;
                this.uri = (String)Preconditions.checkNotNull((Object)VCard.super.getUri());
                this.uriStage = 1;
            }
            return this.uri;
        }

        String setUri(String value) {
            this.uri = value;
            this.uriStage = 1;
            return value;
        }

        String getFn() {
            if (this.fnStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fnStage == 0) {
                this.fnStage = (byte)-1;
                this.fn = (String)Preconditions.checkNotNull((Object)VCard.super.getFn());
                this.fnStage = 1;
            }
            return this.fn;
        }

        String setFn(String value) {
            this.fn = value;
            this.fnStage = 1;
            return value;
        }

        String getAdr() {
            if (this.adrStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.adrStage == 0) {
                this.adrStage = (byte)-1;
                this.adr = (String)Preconditions.checkNotNull((Object)VCard.super.getAdr());
                this.adrStage = 1;
            }
            return this.adr;
        }

        String setAdr(String value) {
            this.adr = value;
            this.adrStage = 1;
            return value;
        }

        String getEmail() {
            if (this.emailStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.emailStage == 0) {
                this.emailStage = (byte)-1;
                this.email = (String)Preconditions.checkNotNull((Object)VCard.super.getEmail());
                this.emailStage = 1;
            }
            return this.email;
        }

        String setEmail(String value) {
            this.email = value;
            this.emailStage = 1;
            return value;
        }

        String getTel() {
            if (this.telStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.telStage == 0) {
                this.telStage = (byte)-1;
                this.tel = (String)Preconditions.checkNotNull((Object)VCard.super.getTel());
                this.telStage = 1;
            }
            return this.tel;
        }

        String setTel(String value) {
            this.tel = value;
            this.telStage = 1;
            return value;
        }

        String getOrg() {
            if (this.orgStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orgStage == 0) {
                this.orgStage = (byte)-1;
                this.org = (String)Preconditions.checkNotNull((Object)VCard.super.getOrg());
                this.orgStage = 1;
            }
            return this.org;
        }

        String setOrg(String value) {
            this.org = value;
            this.orgStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.uriStage == -1) {
                attributes.add("uri");
            }
            if (this.fnStage == -1) {
                attributes.add("fn");
            }
            if (this.adrStage == -1) {
                attributes.add("adr");
            }
            if (this.emailStage == -1) {
                attributes.add("email");
            }
            if (this.telStage == -1) {
                attributes.add("tel");
            }
            if (this.orgStage == -1) {
                attributes.add("org");
            }
            return "Cannot build VCard, attribute initializers form cycle" + attributes;
        }
    }
}

