/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.geojson;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import eu.trentorise.opendata.traceprov.geojson.Crs;
import java.io.Serializable;
import java.util.Map;
import org.immutables.value.Value;

@JsonSerialize(as=Crs.class)
@JsonDeserialize(as=Crs.class)
@Value.Immutable
abstract class ACrs
implements Serializable {
    private static final long serialVersionUID = 1L;

    ACrs() {
    }

    @Value.Default
    public String getType() {
        return "name";
    }

    @Value.Default
    public Map<String, ?> getProperties() {
        return ImmutableMap.of((Object)"name", (Object)"urn:ogc:def:crs:OGC:1.3:CRS84");
    }

    public static Crs ofName(String name) {
        return Crs.of("name", ImmutableMap.of((Object)"name", (Object)name));
    }

    public static Crs ofLink(String href) {
        return Crs.of("link", ImmutableMap.of((Object)"href", (Object)href));
    }

    public static Crs ofLink(String href, String type) {
        return Crs.of("link", ImmutableMap.of((Object)"href", (Object)href, (Object)"type", (Object)type));
    }

    @Value.Check
    protected void check() {
        switch (this.getType()) {
            case "name": {
                Preconditions.checkArgument((boolean)this.getProperties().containsKey("name"), (Object)"properties[\"name\"] must be present for 'name' type!");
                Preconditions.checkNotNull(this.getProperties().get("name"), (Object)"properties[\"name\"] must not be null!");
                break;
            }
            case "link": {
                Preconditions.checkNotNull(this.getProperties().get("href"), (Object)"properties[\"href\"] must not be null for 'link' type!");
                if (!this.getProperties().containsKey("type")) break;
                Preconditions.checkNotNull(this.getProperties().get("type"), (Object)"properties[\"type\"] must not be null for 'link' type!");
                break;
            }
            case "default": {
                throw new IllegalStateException("Unrecognized type " + this.getType() + "!");
            }
        }
    }
}

