/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.geojson;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import eu.trentorise.opendata.traceprov.geojson.AGeometry;
import eu.trentorise.opendata.traceprov.geojson.MultiLineString;
import eu.trentorise.opendata.traceprov.validation.Preconditions;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=MultiLineString.class)
@JsonDeserialize(as=MultiLineString.class)
@Value.Immutable
abstract class AMultiLineString
extends AGeometry {
    private static final long serialVersionUID = 1L;

    AMultiLineString() {
    }

    public abstract ImmutableList<ImmutableList<ImmutableList<Double>>> getCoordinates();

    @Value.Check
    protected void check() {
        for (ImmutableList lineString : this.getCoordinates()) {
            Preconditions.checkPositions((List<ImmutableList<Double>>)lineString, 2, "Invalid lineString!");
        }
    }
}

